/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.haclient.dualservice.DualExecutor;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AliHBaseMultiClusterConnection;
import org.apache.hadoop.hbase.client.AliHBaseResultScanner;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Pair;

public class AliHBaseMultiTable
extends HTable
implements HTableInterface,
RegionLocator {
    private static final Log LOG = LogFactory.getLog(AliHBaseMultiTable.class);
    private volatile HTable activeHTable = null;
    private volatile HTable standbyHTable = null;
    private long switchCount = 0L;
    private AliHBaseMultiClusterConnection connection;
    private Configuration conf;
    private TableName tableName;
    private AliHBaseConstants.ClusterType currentType;
    private boolean tableDualEnabled = false;
    private int glitchTimeout;
    private int scannerTimeout;

    public AliHBaseMultiTable(TableName tableName, AliHBaseMultiClusterConnection connection, HTable table) throws IOException {
        super(tableName, (ClusterConnection)connection, new ConnectionConfiguration(connection.getConfiguration()), null, null, (ExecutorService)new NoopExecutorService());
        this.activeHTable = table;
        this.connection = connection;
        this.tableName = tableName;
        this.currentType = AliHBaseConstants.ClusterType.valueOf(connection.getConfiguration().get("hbase.cluster.type"));
        this.switchCount = connection.getSwitchCount();
        this.conf = connection.getConfiguration();
        this.tableDualEnabled = this.conf.getBoolean("hbase.dualservice.table.enable", false) ? true : this.conf.getBoolean(DualExecutor.createTableConfKey(tableName.getNameAsString(), "hbase.dualservice.enable"), false);
        this.glitchTimeout = this.conf.getInt(DualExecutor.createTableConfKey(tableName.getNameAsString(), "hbase.dualservice.glitchtimeout"), this.conf.getInt("hbase.dualservice.glitchtimeout", 30));
        this.scannerTimeout = this.conf.getInt("hbase.client.scanner.timeout.period", 60000);
        if (this.tableDualEnabled) {
            this.standbyHTable = this.connection.getHTableWithStandbyConnection(tableName);
        }
    }

    private HTable getCurrentHTable() throws IOException {
        if (this.switchCount < this.connection.getSwitchCount()) {
            Configuration currentConf = this.connection.getConfiguration();
            AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(currentConf.get("hbase.cluster.type"));
            if (this.currentType != AliHBaseConstants.ClusterType.HBASE || clusterType != AliHBaseConstants.ClusterType.HBASE) {
                LOG.debug((Object)("Update HTable, from " + (Object)((Object)this.currentType) + ", to " + (Object)((Object)clusterType)));
                HTable newTable = this.connection.getHTableByType(this.tableName);
                HTable lastHTable = this.activeHTable;
                this.activeHTable = newTable;
                if (lastHTable != null) {
                    try {
                        lastHTable.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("last htable close failed" + e));
                    }
                }
            }
            this.currentType = clusterType;
            this.switchCount = this.connection.getSwitchCount();
            this.conf = currentConf;
            if (this.tableDualEnabled) {
                this.standbyHTable = this.connection.getHTableWithStandbyConnection(this.tableName);
            }
        }
        return this.activeHTable;
    }

    public boolean getTableDualEnable() {
        return this.tableDualEnabled;
    }

    public Configuration getConfiguration() {
        try {
            return this.getCurrentHTable().getConfiguration();
        }
        catch (IOException e) {
            LOG.error((Object)("getConfiguration failed : " + e));
            return null;
        }
    }

    public HRegionLocation getRegionLocation(String row) throws IOException {
        return this.getCurrentHTable().getRegionLocation(row);
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.getCurrentHTable().getRegionLocation(row);
    }

    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        return this.getCurrentHTable().getRegionLocation(row, reload);
    }

    public byte[] getTableName() {
        return this.tableName.getName();
    }

    public TableName getName() {
        return this.tableName;
    }

    public int getScannerCaching() {
        try {
            return this.getCurrentHTable().getScannerCaching();
        }
        catch (IOException e) {
            LOG.error((Object)("getScannerCaching failed : " + e));
            return 0;
        }
    }

    public List<Row> getWriteBuffer() {
        try {
            return this.getCurrentHTable().getWriteBuffer();
        }
        catch (IOException e) {
            LOG.error((Object)("getWriteBuffer failed : " + e));
            return null;
        }
    }

    public void setScannerCaching(int scannerCaching) {
        try {
            this.getCurrentHTable().setScannerCaching(scannerCaching);
        }
        catch (IOException e) {
            LOG.error((Object)("setScannerCaching failed : " + e));
        }
    }

    public byte[][] getStartKeys() throws IOException {
        return this.getCurrentHTable().getStartKeys();
    }

    public byte[][] getEndKeys() throws IOException {
        return this.getCurrentHTable().getEndKeys();
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.getCurrentHTable().getStartEndKeys();
    }

    public NavigableMap<HRegionInfo, ServerName> getRegionLocations() throws IOException {
        return this.getCurrentHTable().getRegionLocations();
    }

    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        return this.getCurrentHTable().getAllRegionLocations();
    }

    public List<HRegionLocation> getRegionsInRange(byte[] startKey, byte[] endKey) throws IOException {
        return this.getCurrentHTable().getRegionsInRange(startKey, endKey);
    }

    public List<HRegionLocation> getRegionsInRange(byte[] startKey, byte[] endKey, boolean reload) throws IOException {
        return this.getCurrentHTable().getRegionsInRange(startKey, endKey, reload);
    }

    public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
        return this.getCurrentHTable().getRowOrBefore(row, family);
    }

    public HConnection getConnection() {
        return this.connection;
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.getCurrentHTable().getTableDescriptor();
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        DualExecutor executor;
        if (this.tableDualEnabled && (executor = this.connection.getDualExecutor()) != null && scan.isSmall()) {
            HTable activeTable = this.getCurrentHTable();
            return new AliHBaseResultScanner(activeTable, this.standbyHTable, executor, scan, this.glitchTimeout, this.scannerTimeout);
        }
        return this.getCurrentHTable().getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public Result get(Get get2) throws IOException {
        DualExecutor executor;
        if (this.tableDualEnabled && (executor = this.connection.getDualExecutor()) != null) {
            HTable activeTable = this.getCurrentHTable();
            return executor.dualGet(activeTable, this.standbyHTable, this.tableName.getName(), get2, this.glitchTimeout, this.getOperationTimeout());
        }
        return this.getCurrentHTable().get(get2);
    }

    public Result[] get(List<Get> gets) throws IOException {
        DualExecutor executor;
        if (this.tableDualEnabled && (executor = this.connection.getDualExecutor()) != null) {
            HTable activeTable = this.getCurrentHTable();
            return executor.dualBatchGet(activeTable, this.standbyHTable, this.tableName.getName(), gets, this.glitchTimeout, this.getOperationTimeout());
        }
        return this.getCurrentHTable().get(gets);
    }

    public void batch(List<? extends Row> actions, Object[] results) throws InterruptedException, IOException {
        this.getCurrentHTable().batch(actions, results);
    }

    public Object[] batch(List<? extends Row> actions) throws InterruptedException, IOException {
        return this.getCurrentHTable().batch(actions);
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.getCurrentHTable().batchCallback(actions, results, callback);
    }

    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        return this.getCurrentHTable().batchCallback(actions, callback);
    }

    public void delete(Delete delete) throws IOException {
        DualExecutor executor;
        if (this.tableDualEnabled && (executor = this.connection.getDualExecutor()) != null) {
            HTable activeTable = this.getCurrentHTable();
            executor.dualDelete(activeTable, this.standbyHTable, this.tableName.getName(), delete, this.glitchTimeout, this.getOperationTimeout());
            return;
        }
        this.getCurrentHTable().delete(delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        DualExecutor executor;
        if (this.tableDualEnabled && (executor = this.connection.getDualExecutor()) != null) {
            HTable activeTable = this.getCurrentHTable();
            executor.dualBatchDelete(activeTable, this.standbyHTable, this.tableName.getName(), deletes, this.glitchTimeout, this.getOperationTimeout());
            return;
        }
        this.getCurrentHTable().delete(deletes);
    }

    public void put(Put put2) throws IOException {
        DualExecutor executor;
        if (this.tableDualEnabled && (executor = this.connection.getDualExecutor()) != null) {
            HTable activeTable = this.getCurrentHTable();
            executor.dualPut(activeTable, this.standbyHTable, this.tableName.getName(), put2, this.glitchTimeout, this.getOperationTimeout());
            return;
        }
        this.getCurrentHTable().put(put2);
    }

    public void put(List<Put> puts) throws IOException {
        DualExecutor executor;
        if (this.tableDualEnabled && (executor = this.connection.getDualExecutor()) != null) {
            HTable activeTable = this.getCurrentHTable();
            executor.dualBatchPut(activeTable, this.standbyHTable, this.tableName.getName(), puts, this.glitchTimeout, this.getOperationTimeout());
            return;
        }
        this.getCurrentHTable().put(puts);
    }

    public void mutateRow(RowMutations rm) throws IOException {
        this.getCurrentHTable().mutateRow(rm);
    }

    public Result append(Append append2) throws IOException {
        return this.getCurrentHTable().append(append2);
    }

    public Result increment(Increment increment2) throws IOException {
        return this.getCurrentHTable().increment(increment2);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.getCurrentHTable().incrementColumnValue(row, family, qualifier, amount);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        return this.getCurrentHTable().incrementColumnValue(row, family, qualifier, amount, writeToWAL);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        return this.getCurrentHTable().incrementColumnValue(row, family, qualifier, amount, durability);
    }

    @Deprecated
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put2) throws IOException {
        return this.getCurrentHTable().checkAndPut(row, family, qualifier, value, put2);
    }

    @Deprecated
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put2) throws IOException {
        return this.getCurrentHTable().checkAndPut(row, family, qualifier, compareOp, value, put2);
    }

    @Deprecated
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.getCurrentHTable().checkAndDelete(row, family, qualifier, value, delete);
    }

    @Deprecated
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        return this.getCurrentHTable().checkAndDelete(row, family, qualifier, compareOp, value, delete);
    }

    @Deprecated
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rm) throws IOException {
        return this.getCurrentHTable().checkAndMutate(row, family, qualifier, compareOp, value, rm);
    }

    public boolean exists(Get get2) throws IOException {
        return this.getCurrentHTable().exists(get2);
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        return this.getCurrentHTable().existsAll(gets);
    }

    public Boolean[] exists(List<Get> gets) throws IOException {
        return this.getCurrentHTable().exists(gets);
    }

    public void flushCommits() throws IOException {
        this.getCurrentHTable().flushCommits();
    }

    public <R> void processBatchCallback(List<? extends Row> list, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.getCurrentHTable().processBatchCallback(list, results, callback);
    }

    public void processBatch(List<? extends Row> list, Object[] results) throws IOException, InterruptedException {
        this.getCurrentHTable().batch(list, results);
    }

    public void close() throws IOException {
        super.close();
        if (this.activeHTable != null) {
            this.activeHTable.close();
        }
        if (this.standbyHTable != null) {
            this.standbyHTable.close();
        }
    }

    public void validatePut(Put put2) throws IllegalArgumentException {
        try {
            this.getCurrentHTable().validatePut(put2);
        }
        catch (IOException e) {
            LOG.error((Object)("validatePut failed : " + e));
        }
    }

    public void clearRegionCache() {
        try {
            this.getCurrentHTable().clearRegionCache();
        }
        catch (IOException e) {
            LOG.error((Object)("clearRegionCache failed : " + e));
        }
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        try {
            return this.getCurrentHTable().coprocessorService(row);
        }
        catch (IOException e) {
            LOG.error((Object)("coprocessorService failed : " + e));
            return null;
        }
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        return this.getCurrentHTable().coprocessorService(service, startKey, endKey, callable);
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.getCurrentHTable().coprocessorService(service, startKey, endKey, callable, callback);
    }

    public boolean isAutoFlush() {
        try {
            return this.getCurrentHTable().isAutoFlush();
        }
        catch (IOException e) {
            LOG.error((Object)("isAutoFlush failed : " + e));
            return false;
        }
    }

    public void setAutoFlush(boolean autoFlush) {
        try {
            this.getCurrentHTable().setAutoFlush(autoFlush);
        }
        catch (IOException e) {
            LOG.error((Object)("setAutoFlush failed : " + e));
        }
    }

    public void setAutoFlushTo(boolean autoFlush) {
        try {
            this.getCurrentHTable().setAutoFlushTo(autoFlush);
        }
        catch (IOException e) {
            LOG.error((Object)("setAutoFlushTo failed : " + e));
        }
    }

    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        try {
            this.getCurrentHTable().setAutoFlush(autoFlush, clearBufferOnFail);
        }
        catch (IOException e) {
            LOG.error((Object)("setAutoFlush failed : " + e));
        }
    }

    public long getWriteBufferSize() {
        try {
            return this.getCurrentHTable().getWriteBufferSize();
        }
        catch (IOException e) {
            LOG.error((Object)("getWriteBufferSize failed : " + e));
            return 0L;
        }
    }

    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.getCurrentHTable().setWriteBufferSize(writeBufferSize);
    }

    @Deprecated
    public int getRpcTimeout() {
        try {
            return this.getCurrentHTable().getRpcTimeout();
        }
        catch (IOException e) {
            LOG.error((Object)("getRpcTimeout failed : " + e));
            return 0;
        }
    }

    @Deprecated
    public void setRpcTimeout(int rpcTimeout) {
        try {
            this.getCurrentHTable().setRpcTimeout(rpcTimeout);
        }
        catch (IOException e) {
            LOG.error((Object)("setRpcTimeout failed : " + e));
        }
    }

    public int getOperationTimeout() {
        try {
            return this.getCurrentHTable().getOperationTimeout();
        }
        catch (IOException e) {
            LOG.error((Object)("getOperationTimeout failed : " + e));
            return 0;
        }
    }

    public void setOperationTimeout(int operationTimeout) {
        try {
            this.getCurrentHTable().setOperationTimeout(operationTimeout);
        }
        catch (IOException e) {
            LOG.error((Object)("setOperationTimeout failed : " + e));
        }
    }

    public String toString() {
        try {
            return this.getCurrentHTable().toString();
        }
        catch (IOException e) {
            LOG.error((Object)("toString failed : " + e));
            return null;
        }
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        return this.getCurrentHTable().batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype);
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.getCurrentHTable().batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype, callback);
    }

    public RegionLocator getRegionLocator() {
        try {
            return this.getCurrentHTable().getRegionLocator();
        }
        catch (IOException e) {
            LOG.error((Object)("getRegionLocator failed : " + e));
            return null;
        }
    }

    private static class NoopExecutorService
    implements ExecutorService {
        private NoopExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return null;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return null;
        }

        @Override
        public Future<?> submit(Runnable task) {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        @Override
        public void execute(Runnable command) {
        }
    }
}

