/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseUEClientService;
import com.alibaba.hbase.client.AliHBaseUEConnection;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AliHBaseUETable;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.NoopRegistry;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.security.User;

public class AliHBaseUEClusterConnection
extends ConnectionManager.HConnectionImplementation {
    private AliHBaseUEConnection connection;

    public AliHBaseUEClusterConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        this(conf, pool, user);
    }

    private static Configuration setupConf(Configuration conf) {
        conf.setBoolean("hbase.regionsizecalculator.enable", false);
        conf.setBoolean("hbase.stopfake.hbaseclient", true);
        conf.set("hbase.client.registry.impl", NoopRegistry.class.getName());
        return conf;
    }

    public Configuration getConfiguration() {
        if (this.connection != null) {
            return this.connection.getConfiguration();
        }
        return super.getConfiguration();
    }

    public AliHBaseUEClusterConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        super(AliHBaseUEClusterConnection.setupConf(conf), false);
        this.connection = new AliHBaseUEConnection(conf, pool, user);
    }

    void retrieveClusterId() {
    }

    public AliHBaseUEClusterConnection(AliHBaseUEConnection connection) throws IOException {
        super(connection.getConfiguration(), false);
        this.connection = connection;
    }

    public HTableInterface getTable(TableName tableName) throws IOException {
        return this.connection.getTable(tableName);
    }

    public HTableInterface getTable(TableName tableName, ExecutorService pool) throws IOException {
        return this.connection.getTable(tableName, pool);
    }

    public BufferedMutator getBufferedMutator(TableName tableName) {
        try {
            return this.connection.getBufferedMutator(tableName);
        }
        catch (IOException e) {
            throw new IllegalStateException("getBufferedMutator exception ", e);
        }
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) {
        try {
            return this.connection.getBufferedMutator(params);
        }
        catch (IOException e) {
            throw new IllegalStateException("getBufferedMutator exception ", e);
        }
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        return this.connection.getRegionLocator(tableName);
    }

    public Admin getAdmin() throws IOException {
        return this.connection.getAdmin();
    }

    void internalClose() {
        if (this.isZeroReference()) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("close exception ", e);
            }
        }
    }

    public boolean isClosed() {
        return this.connection.isClosed();
    }

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return true;
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        try (Admin admin = this.getAdmin();){
            boolean bl = admin.isTableAvailable(tableName, splitKeys);
            return bl;
        }
    }

    public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
        try (AliHBaseUETable table = (AliHBaseUETable)this.getTable(tableName);){
            HRegionLocation hRegionLocation = table.getRegionLocation(row);
            return hRegionLocation;
        }
    }

    public void clearRegionCache() {
    }

    public void cacheLocation(TableName tableName, RegionLocations location) {
    }

    public void clearRegionCache(TableName tableName) {
    }

    public void deleteCachedRegionLocation(HRegionLocation location) {
    }

    public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
        return this.locateRegion(tableName, row);
    }

    public RegionLocations relocateRegion(TableName tableName, byte[] row, int replicaId) throws IOException {
        RegionLocations regionLocations = new RegionLocations(new HRegionLocation[]{this.locateRegion(tableName, row)});
        return regionLocations;
    }

    public void updateCachedLocations(TableName tableName, byte[] regionName, byte[] rowkey, Object exception, ServerName source) {
    }

    public HRegionLocation locateRegion(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("locateRegion by region name is not supported");
    }

    public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
        try (AliHBaseUETable table = (AliHBaseUETable)this.getTable(tableName);){
            List<HRegionLocation> list = table.getAllRegionLocations();
            return list;
        }
    }

    public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
        return this.locateRegions(tableName);
    }

    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
        RegionLocations regionLocations = new RegionLocations(new HRegionLocation[]{this.locateRegion(tableName, row)});
        return regionLocations;
    }

    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
        return this.locateRegion(tableName, row, useCache, retry);
    }

    public MasterProtos.MasterService.BlockingInterface getMaster() {
        return null;
    }

    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
        return null;
    }

    public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
        return new AliHBaseUEClientService(this.connection);
    }

    public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
        return this.locateRegion(tableName, row);
    }

    public void clearCaches(ServerName sn) {
    }

    public MasterKeepAliveConnection getKeepAliveMasterService() throws MasterNotRunningException {
        return null;
    }

    public boolean isDeadServer(ServerName serverName) {
        return false;
    }

    public NonceGenerator getNonceGenerator() {
        return null;
    }

    public AsyncProcess getAsyncProcess() {
        return null;
    }

    public RpcRetryingCallerFactory getNewRpcRetryingCallerFactory(Configuration conf) {
        return null;
    }

    public RpcRetryingCallerFactory getRpcRetryingCallerFactory() {
        return null;
    }

    public RpcControllerFactory getRpcControllerFactory() {
        return null;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return new ConnectionConfiguration(this.connection.getConfiguration());
    }

    public boolean isManaged() {
        return false;
    }

    public ServerStatisticTracker getStatisticsTracker() {
        return null;
    }

    public ClientBackoffPolicy getBackoffPolicy() {
        return null;
    }

    public boolean hasCellBlockSupport() {
        return false;
    }

    public HTableInterface getTable(String tableName) throws IOException {
        return this.getTable(TableName.valueOf((String)tableName));
    }

    public HTableInterface getTable(byte[] tableName) throws IOException {
        return this.getTable(TableName.valueOf((byte[])tableName));
    }

    public HTableInterface getTable(String tableName, ExecutorService pool) throws IOException {
        return this.getTable(TableName.valueOf((String)tableName), pool);
    }

    public HTableInterface getTable(byte[] tableName, ExecutorService pool) throws IOException {
        return this.getTable(TableName.valueOf((byte[])tableName), pool);
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        try (Admin admin = this.getAdmin();){
            boolean bl = admin.isTableAvailable(tableName);
            return bl;
        }
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        try (Admin admin = this.getAdmin();){
            boolean bl = admin.isTableDisabled(tableName);
            return bl;
        }
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        try (Admin admin = this.getAdmin();){
            boolean bl = admin.isTableAvailable(tableName);
            return bl;
        }
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
        try (Admin admin = this.getAdmin();){
            boolean bl = admin.isTableAvailable(TableName.valueOf((byte[])tableName), splitKeys);
            return bl;
        }
    }

    public HTableDescriptor[] listTables() throws IOException {
        try (Admin admin = this.getAdmin();){
            HTableDescriptor[] hTableDescriptorArray = admin.listTables();
            return hTableDescriptorArray;
        }
    }

    public String[] getTableNames() throws IOException {
        TableName[] tableNames = this.listTableNames();
        String[] tables = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            tables[i] = tableNames[i].toString();
        }
        return tables;
    }

    public TableName[] listTableNames() throws IOException {
        try (Admin admin = this.getAdmin();){
            TableName[] tableNameArray = admin.listTableNames();
            return tableNameArray;
        }
    }

    public HTableDescriptor getHTableDescriptor(TableName tableName) throws IOException {
        try (Admin admin = this.getAdmin();){
            HTableDescriptor hTableDescriptor = admin.getTableDescriptor(tableName);
            return hTableDescriptor;
        }
    }

    public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
        return this.getHTableDescriptor(TableName.valueOf((byte[])tableName));
    }

    public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
        try (AliHBaseUETable table = (AliHBaseUETable)this.getTable(tableName);){
            HRegionLocation hRegionLocation = table.getRegionLocation(row);
            return hRegionLocation;
        }
    }

    public void clearRegionCache(byte[] tableName) {
    }

    public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
        return this.locateRegion(tableName, row);
    }

    public void updateCachedLocations(TableName tableName, byte[] rowkey, Object exception, HRegionLocation source) {
    }

    public void updateCachedLocations(byte[] tableName, byte[] rowkey, Object exception, HRegionLocation source) {
    }

    public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
        try (AliHBaseUETable table = (AliHBaseUETable)this.getTable(tableName);){
            List<HRegionLocation> list = table.getAllRegionLocations();
            return list;
        }
    }

    public List<HRegionLocation> locateRegions(byte[] tableName, boolean useCache, boolean offlined) throws IOException {
        return this.locateRegions(tableName);
    }

    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName, boolean getMaster) throws IOException {
        return null;
    }

    public HRegionLocation getRegionLocation(byte[] tableName, byte[] row, boolean reload) throws IOException {
        return this.locateRegion(tableName, row);
    }

    public void processBatch(List<? extends Row> actions, TableName tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
        try (AliHBaseUETable table = (AliHBaseUETable)this.getTable(tableName);){
            table.batch(actions, results);
        }
    }

    public void processBatch(List<? extends Row> actions, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
        this.processBatch(actions, TableName.valueOf((byte[])tableName), pool, results);
    }

    public <R> void processBatchCallback(List<? extends Row> list, TableName tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("processBatchCallback with callback is not supported");
    }

    public <R> void processBatchCallback(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("processBatchCallback with callback is not supported");
    }

    public void setRegionCachePrefetch(TableName tableName, boolean enable) {
    }

    public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
    }

    public boolean getRegionCachePrefetch(TableName tableName) {
        return false;
    }

    public boolean getRegionCachePrefetch(byte[] tableName) {
        return false;
    }

    public int getCurrentNrHRS() throws IOException {
        return 0;
    }

    public HTableDescriptor[] getHTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        try (Admin admin = this.getAdmin();){
            HTableDescriptor[] hTableDescriptorArray = admin.getTableDescriptorsByTableName(tableNames);
            return hTableDescriptorArray;
        }
    }

    public HTableDescriptor[] getHTableDescriptors(List<String> tableNames) throws IOException {
        try (Admin admin = this.getAdmin();){
            HTableDescriptor[] hTableDescriptorArray = admin.getTableDescriptors(tableNames);
            return hTableDescriptorArray;
        }
    }

    public void abort(String why, Throwable e) {
    }

    public boolean isAborted() {
        return false;
    }

    public String toString() {
        return "AliHBaseUEClusterConnection-0x" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    public void clearRegionCache(TableName tableName, byte[] row) {
    }
}

