/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseTableInterface;
import com.alibaba.hbase.client.AliHBaseUEBufferedMutator;
import com.alibaba.hbase.client.AliHBaseUEConnection;
import com.alibaba.lindorm.client.core.meta.ExternalIndexConfig;
import com.alibaba.lindorm.client.core.meta.ExternalIndexField;
import com.alibaba.lindorm.client.core.meta.ExternalIndexRowFormatterType;
import com.alibaba.lindorm.client.core.meta.ExternalIndexType;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AliHBaseUEClusterConnection;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class AliHBaseUETable
extends HTable
implements AliHBaseTableInterface,
RegionLocator {
    private TableName myTableName;
    private AliHBaseUEConnection connection;
    private Configuration conf;
    private AliHBaseAPIProxy proxy;
    private boolean isClosed;
    private boolean autoFlush = true;
    private int defaultScannerCaching;
    private AliHBaseUEBufferedMutator mutator;

    public AliHBaseUETable(TableName tableName, AliHBaseUEConnection connection) throws IOException {
        super(tableName, (Connection)new AliHBaseUEClusterConnection(connection), (ExecutorService)new NoopExecutorService());
        this.myTableName = tableName;
        this.connection = connection;
        this.conf = connection.getConfiguration();
        this.defaultScannerCaching = this.conf.getInt("hbase.client.scanner.caching", 100);
        if (this.defaultScannerCaching > 100) {
            this.defaultScannerCaching = 100;
        }
        this.proxy = connection.getAPIProxy(tableName);
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.getRegionLocation(row, false);
    }

    public HRegionLocation getRegionLocation(byte[] row, boolean b) throws IOException {
        return this.proxy.getRegionLocation(row);
    }

    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        return this.proxy.getAllRegionLocations();
    }

    public byte[][] getStartKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getFirst();
    }

    public byte[][] getEndKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getSecond();
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.proxy.getStartEndKeys();
    }

    public TableName getName() {
        return this.myTableName;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.proxy.getDescriptor(this.myTableName);
    }

    public boolean exists(Get get2) throws IOException {
        return this.proxy.exists(get2);
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        return this.proxy.exists(gets);
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException {
        throw new IOException("BatchCallback not supported, use put(List<Put> puts), get(List<Get> gets) or delete(List<Delete> deletes) respectively");
    }

    public Result get(Get get2) throws IOException {
        return this.proxy.get(get2);
    }

    public Result[] get(List<Get> gets) throws IOException {
        return this.proxy.get(gets);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        return this.proxy.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public void put(Put put2) throws IOException {
        if (this.autoFlush) {
            this.proxy.put(put2);
        } else {
            this.getBufferedMutator().mutate((Mutation)put2);
        }
    }

    public void put(List<Put> puts) throws IOException {
        if (this.autoFlush) {
            this.proxy.put(puts);
        } else {
            this.getBufferedMutator().mutate(puts);
        }
    }

    public void delete(Delete delete) throws IOException {
        this.proxy.delete(delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        this.proxy.delete(deletes);
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp op, byte[] value, RowMutations rowMutations) throws IOException {
        return this.proxy.checkAndMutate(row, family, qualifier, op, value, rowMutations);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put2) throws IOException {
        return this.checkAndPut(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, put2);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.checkAndDelete(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, delete);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put2) throws IOException {
        return this.proxy.checkAndPut(row, family, qualifier, compareOp, value, put2);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        return this.proxy.checkAndDelete(row, family, qualifier, compareOp, value, delete);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, Durability.SYNC_WAL);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        Increment increment2 = new Increment(row);
        increment2.addColumn(family, qualifier, amount);
        Result result = this.increment(increment2);
        return Bytes.toLong((byte[])result.getValue(family, qualifier));
    }

    public void mutateRow(RowMutations rm) throws IOException {
        this.proxy.mutateRow(rm);
    }

    public Result append(Append append2) throws IOException {
        return this.proxy.append(append2);
    }

    public Result increment(Increment increment2) throws IOException {
        return this.proxy.increment(increment2);
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.flushCommits();
        if (this.mutator != null) {
            this.mutator.close();
        }
        this.proxy.close();
        this.isClosed = true;
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException {
        this.proxy.batch(actions, results);
    }

    public Object[] batch(List<? extends Row> actions) throws IOException {
        Object[] results = new Object[actions.size()];
        this.batch(actions, results);
        return results;
    }

    public <R> Object[] batchCallback(List<? extends Row> list, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("batchCallback not supported");
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> call) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.proxy.coprocessorService(service, startKey, endKey, callable, callback);
    }

    public long getWriteBufferSize() {
        if (this.mutator != null) {
            return this.mutator.getWriteBufferSize();
        }
        return 0L;
    }

    public void setWriteBufferSize(long l) throws IOException {
        this.getBufferedMutator();
        this.mutator.setWriteBufferSize(l);
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message message, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("batchCoprocessorService not supported");
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message message, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("batchCoprocessorService not supported");
    }

    public void setOperationTimeout(int i) {
    }

    public int getOperationTimeout() {
        return this.connection.getOperationTimeout();
    }

    public int getRpcTimeout() {
        return this.connection.getOperationTimeout();
    }

    public void setRpcTimeout(int i) {
    }

    public int getReadRpcTimeout() {
        return this.connection.getOperationTimeout();
    }

    public void setReadRpcTimeout(int i) {
    }

    public int getWriteRpcTimeout() {
        return this.connection.getOperationTimeout();
    }

    public void setWriteRpcTimeout(int i) {
    }

    public byte[] getTableName() {
        return this.myTableName.toBytes();
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount);
    }

    public Boolean[] exists(List<Get> gets) throws IOException {
        Result[] results = this.get(gets);
        Boolean[] existResult = new Boolean[results.length];
        for (int i = 0; i < results.length; ++i) {
            existResult[i] = results[i].getRow() != null;
        }
        return existResult;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.autoFlush = autoFlush;
        if (this.mutator != null) {
            this.mutator.setClearBufferOnFail(clearBufferOnFail);
        }
    }

    public void setAutoFlushTo(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void flushCommits() throws IOException {
        if (this.mutator == null) {
            return;
        }
        this.getBufferedMutator().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
        Scan scan = new Scan(row);
        if (family != null) {
            scan.addFamily(family);
        }
        scan.setReversed(true);
        scan.setCaching(2);
        try (ResultScanner scanner = this.getScanner(scan);){
            Result result = scanner.next();
            return result;
        }
    }

    public HRegionLocation getRegionLocation(String row) throws IOException {
        return this.getRegionLocation(Bytes.toBytes((String)row));
    }

    public HConnection getConnection() {
        return super.getConnection();
    }

    public int getScannerCaching() {
        return this.defaultScannerCaching;
    }

    public List<Row> getWriteBuffer() {
        return null;
    }

    public void setScannerCaching(int scannerCaching) {
    }

    public NavigableMap<HRegionInfo, ServerName> getRegionLocations() throws IOException {
        return new TreeMap<HRegionInfo, ServerName>();
    }

    public List<HRegionLocation> getRegionsInRange(byte[] startKey, byte[] endKey) throws IOException {
        return this.getRegionsInRange(startKey, endKey, false);
    }

    public List<HRegionLocation> getRegionsInRange(byte[] startKey, byte[] endKey, boolean reload) throws IOException {
        return (List)this.getKeysAndRegionsInRange(startKey, endKey, false, false).getSecond();
    }

    private Pair<List<byte[]>, List<HRegionLocation>> getKeysAndRegionsInRange(byte[] startKey, byte[] endKey, boolean includeEndKey, boolean reload) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])startKey) + " > " + Bytes.toStringBinary((byte[])endKey));
        }
        ArrayList<byte[]> keysInRange = new ArrayList<byte[]>();
        ArrayList<HRegionLocation> regionsInRange = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            regionLocation = this.getRegionLocation(currentKey, reload);
            keysInRange.add(currentKey);
            regionsInRange.add(regionLocation);
        } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0 || includeEndKey && Bytes.compareTo((byte[])currentKey, (byte[])endKey) == 0));
        return new Pair(keysInRange, regionsInRange);
    }

    public <R> void processBatchCallback(List<? extends Row> list, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("batchCallback not supported");
    }

    public void processBatch(List<? extends Row> list, Object[] results) throws IOException, InterruptedException {
        this.batch(list, results);
    }

    public void validatePut(Put put2) throws IllegalArgumentException {
        super.validatePut(put2);
    }

    ExecutorService getPool() {
        return super.getPool();
    }

    public void clearRegionCache() {
    }

    public String toString() {
        return super.toString();
    }

    public RegionLocator getRegionLocator() {
        return this;
    }

    BufferedMutator getBufferedMutator() throws IOException {
        if (this.mutator == null) {
            this.mutator = (AliHBaseUEBufferedMutator)this.connection.getBufferedMutator(this.myTableName);
        }
        return this.mutator;
    }

    @Override
    public void addExternalIndex(String targetIndexName, ExternalIndexType type, ExternalIndexRowFormatterType rowFormatterType, List<ExternalIndexField> fields) throws IOException {
        ExternalIndexConfig config = new ExternalIndexConfig(targetIndexName, type, rowFormatterType);
        this.addExternalIndex(config, fields);
    }

    @Override
    public void addExternalIndex(String targetIndexName, ExternalIndexType type, ExternalIndexRowFormatterType rowFormatterType, ExternalIndexField ... fields) throws IOException {
        ArrayList<ExternalIndexField> list = new ArrayList<ExternalIndexField>();
        for (ExternalIndexField field : fields) {
            list.add(field);
        }
        this.addExternalIndex(targetIndexName, type, rowFormatterType, list);
    }

    @Override
    public void addExternalIndex(ExternalIndexConfig config, List<ExternalIndexField> fields) throws IOException {
        this.proxy.addExternalIndex(config, fields);
    }

    @Override
    public void addExternalIndex(ExternalIndexConfig config, ExternalIndexField ... fields) throws IOException {
        ArrayList<ExternalIndexField> list = new ArrayList<ExternalIndexField>();
        for (ExternalIndexField field : fields) {
            list.add(field);
        }
        this.addExternalIndex(config, fields);
    }

    @Override
    public void addExternalIndex(List<ExternalIndexField> fields) throws IOException {
        this.addExternalIndex(null, fields);
    }

    @Override
    public void addExternalIndex(ExternalIndexField ... fields) throws IOException {
        this.addExternalIndex((ExternalIndexConfig)null, fields);
    }

    @Override
    public void removeExternalIndex(List<String> fields) throws IOException {
        this.proxy.removeExternalIndex(fields);
    }

    @Override
    public void removeExternalIndex(String ... fields) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        for (String field : fields) {
            list.add(field);
        }
        this.removeExternalIndex(list);
    }

    @Override
    public void buildExternalIndex() throws IOException {
        this.proxy.buildExternalIndex();
    }

    @Override
    public void cancelBuildExternalIndex() throws IOException {
        this.proxy.cancelBuildExternalIndex();
    }

    private static class NoopExecutorService
    implements ExecutorService {
        private NoopExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return null;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return null;
        }

        @Override
        public Future<?> submit(Runnable task) {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        @Override
        public void execute(Runnable command) {
        }
    }
}

