/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseThriftClientBuilder;
import com.alibaba.hbase.client.ThriftAdmin;
import com.alibaba.hbase.client.ThriftClientBuilder;
import com.alibaba.hbase.client.ThriftTable;
import com.alibaba.hbase.thrift2.generated.THBaseService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class AliHBaseThriftConnection
implements Connection {
    public static final String ALIHBASE_THRIFT_CLIENT_BUIDLER_CLASS = "alihbase.thrift.client.builder.class";
    private Configuration conf;
    private HttpClient httpClient;
    private boolean httpClientCreated = false;
    private boolean isClosed = false;
    private String host;
    private ThriftClientBuilder clientBuilder;
    private int operationTimeout;
    private int connectTimeout;

    public AliHBaseThriftConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        this(conf, pool, user);
    }

    public AliHBaseThriftConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        this.conf = conf;
        this.host = conf.get("hbase.client.endpoint");
        if (this.host == null) {
            throw new RuntimeException("hbase.client.endpoint is not set");
        }
        this.host = this.host.trim();
        if (!this.host.startsWith("http://") && !this.host.startsWith("https://")) {
            throw new RuntimeException("hbase.client.endpoint should start with http:// or https://");
        }
        String hostOnly = this.host.split("//")[1];
        if (!hostOnly.contains(":")) {
            this.host = this.host + ":" + 9190;
        }
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.connectTimeout = conf.getInt("hbase.ipc.client.socket.timeout.connect", 10000);
        String className = conf.get(ALIHBASE_THRIFT_CLIENT_BUIDLER_CLASS, AliHBaseThriftClientBuilder.class.getName());
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(AliHBaseThriftConnection.class);
            constructor.setAccessible(true);
            this.clientBuilder = (ThriftClientBuilder)constructor.newInstance(this);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public synchronized void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public String getHost() {
        return this.host;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ThriftClientBuilder getClientBuilder() {
        return this.clientBuilder;
    }

    public Admin getAdmin() throws IOException {
        Pair<THBaseService.Client, TTransport> client = this.clientBuilder.getClient();
        return new ThriftAdmin((THBaseService.Client)client.getFirst(), (TTransport)client.getSecond(), this.conf);
    }

    public synchronized HttpClient getHttpClient() {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        int retry = this.conf.getInt("hbase.client.retries.number", 31);
        long pause = this.conf.getLong("hbase.client.pause", 5L);
        HttpClientBuilder builder = HttpClientBuilder.create();
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(this.getConnectTimeout());
        requestBuilder = requestBuilder.setSocketTimeout(this.getOperationTimeout());
        builder.setRetryHandler((HttpRequestRetryHandler)new DelayRetryHandler(retry, pause));
        builder.setDefaultRequestConfig(requestBuilder.build());
        this.httpClient = builder.build();
        this.httpClientCreated = true;
        return this.httpClient;
    }

    public synchronized void close() throws IOException {
        if (this.httpClient != null && this.httpClientCreated) {
            HttpClientUtils.closeQuietly((HttpClient)this.httpClient);
        }
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void abort(String why, Throwable e) {
    }

    public boolean isAborted() {
        return false;
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("batchCoprocessorService not supported in ThriftTable");
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        throw new UnsupportedOperationException("batchCoprocessorService not supported in ThriftTable");
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("batchCoprocessorService not supported in ThriftTable");
    }

    public void clearRegionLocationCache() {
        throw new UnsupportedOperationException("clearRegionLocationCache not supported in ThriftTable");
    }

    public Table getTable(TableName tableName) throws IOException {
        try {
            Pair<THBaseService.Client, TTransport> client = this.clientBuilder.getClient();
            return new ThriftTable(tableName, (THBaseService.Client)client.getFirst(), (TTransport)client.getSecond(), this.conf);
        }
        catch (IOException ioE) {
            throw new RuntimeException(ioE);
        }
    }

    public Table getTable(TableName tableName, ExecutorService executorService) throws IOException {
        return this.getTable(tableName);
    }

    public static class DelayRetryHandler
    extends DefaultHttpRequestRetryHandler {
        private long pause;

        public DelayRetryHandler(int retryCount, long pause) {
            super(retryCount, true, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, SSLException.class));
            this.pause = pause;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (executionCount > 1 && this.pause > 0L) {
                try {
                    long sleepTime = ConnectionUtils.getPauseTime((long)this.pause, (int)(executionCount - 1));
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            return super.retryRequest(exception, executionCount, context);
        }

        protected boolean handleAsIdempotent(HttpRequest request) {
            return true;
        }
    }

    public static class HTTPThriftClientBuilder
    extends ThriftClientBuilder {
        Map<String, String> customHeader = new HashMap<String, String>();

        public HTTPThriftClientBuilder(AliHBaseThriftConnection connection) {
            super(connection);
        }

        public void addCostumHeader(String key, String value) {
            this.customHeader.put(key, value);
        }

        @Override
        public Pair<THBaseService.Client, TTransport> getClient() throws IOException {
            String url = this.connection.getHost();
            try {
                THttpClient httpClient = new THttpClient(url, this.connection.getHttpClient());
                for (Map.Entry<String, String> header : this.customHeader.entrySet()) {
                    httpClient.setCustomHeader(header.getKey(), header.getValue());
                }
                httpClient.open();
                TBinaryProtocol prot = new TBinaryProtocol((TTransport)httpClient);
                THBaseService.Client client = new THBaseService.Client((TProtocol)prot);
                return new Pair((Object)client, (Object)httpClient);
            }
            catch (TTransportException e) {
                throw new IOException(e);
            }
        }
    }
}

