/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseUEConnection;
import com.alibaba.hbase.client.ElementConvertor;
import com.alibaba.lindorm.client.WideColumnService;
import com.alibaba.lindorm.client.core.widecolumnservice.WDelete;
import com.alibaba.lindorm.client.core.widecolumnservice.WPut;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliHBaseUEBufferedMutator
implements BufferedMutator {
    private static final Logger LOG = LoggerFactory.getLogger(AliHBaseUEBufferedMutator.class);
    private final TableName tableName;
    private AliHBaseUEConnection connection;
    private volatile long writeBufferSize;
    private long currentWriteBufferSize;
    private volatile boolean clearBufferOnFail;
    private final ConcurrentLinkedQueue<Mutation> writeBuffer;
    private WideColumnService wideColumnService;

    public AliHBaseUEBufferedMutator(AliHBaseUEConnection connection, TableName tableName) throws IOException {
        this.tableName = tableName;
        this.connection = connection;
        this.writeBuffer = new ConcurrentLinkedQueue();
        this.writeBufferSize = this.connection.getConfiguration().getLong("hbase.client.write.buffer", 0x200000L);
        this.currentWriteBufferSize = 0L;
        this.clearBufferOnFail = this.connection.getConfiguration().getBoolean("hbase.client.bufferedmutator.clearbufferonfail", true);
        this.wideColumnService = connection.getWideColumnService(tableName.getNamespaceAsString());
    }

    public TableName getName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.connection.getConfiguration();
    }

    public void mutate(Mutation mutation) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.mutate(Collections.singletonList(mutation));
    }

    public void mutate(List<? extends Mutation> list) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        ArrayList<WPut> flushPuts = new ArrayList<WPut>();
        ArrayList<WDelete> flushDeletes = new ArrayList<WDelete>();
        for (Mutation mutation : list) {
            this.writeBuffer.add(mutation);
            this.currentWriteBufferSize += mutation.heapSize();
        }
        try {
            if (this.currentWriteBufferSize >= this.writeBufferSize) {
                this.extractOMutation(flushPuts, flushDeletes);
            }
            this.flush(flushPuts, flushDeletes);
        }
        catch (IOException e) {
            LOG.error("Mutate exception ", (Throwable)e);
            throw new InterruptedIOException(e.getMessage());
        }
    }

    private void extractOMutation(List<WPut> flushPuts, List<WDelete> flushDeletes) throws IOException {
        for (Mutation mutation : this.writeBuffer) {
            if (mutation instanceof Put) {
                flushPuts.add(ElementConvertor.toLindormPut((Put)mutation));
                continue;
            }
            if (mutation instanceof Delete) {
                flushDeletes.add(ElementConvertor.toLindormDelete((Delete)mutation));
                continue;
            }
            throw new UnsupportedOperationException("Unsupported mutation type " + mutation.getClass());
        }
        this.writeBuffer.clear();
        this.currentWriteBufferSize = 0L;
    }

    private void flush(List<WPut> flushPuts, List<WDelete> flushDeletes) throws IOException {
        if (!flushPuts.isEmpty()) {
            this.commitPuts(flushPuts);
        }
        if (!flushDeletes.isEmpty()) {
            this.commitDeletes(flushDeletes);
        }
    }

    public void close() throws IOException {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        ArrayList<WPut> flushPuts = new ArrayList<WPut>();
        ArrayList<WDelete> flushDeletes = new ArrayList<WDelete>();
        try {
            ConcurrentLinkedQueue<Mutation> concurrentLinkedQueue = this.writeBuffer;
            synchronized (concurrentLinkedQueue) {
                this.extractOMutation(flushPuts, flushDeletes);
            }
            this.flush(flushPuts, flushDeletes);
        }
        catch (IOException e) {
            LOG.error("Flush exception ", (Throwable)e);
            throw new InterruptedIOException(e.getMessage());
        }
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setClearBufferOnFail(boolean clearBufferOnFail) {
        this.clearBufferOnFail = clearBufferOnFail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPuts(List<WPut> puts) throws IOException {
        boolean flushSuccessfully = false;
        try {
            this.wideColumnService.batchPut(this.tableName.getQualifierAsString(), puts);
            flushSuccessfully = true;
        }
        finally {
            if (!flushSuccessfully && !this.clearBufferOnFail) {
                List<Put> hputs = ElementConvertor.toHBasePuts(puts);
                ConcurrentLinkedQueue<Mutation> concurrentLinkedQueue = this.writeBuffer;
                synchronized (concurrentLinkedQueue) {
                    for (Put put2 : hputs) {
                        this.writeBuffer.add((Mutation)put2);
                        this.currentWriteBufferSize += put2.heapSize();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitDeletes(List<WDelete> deletes) throws IOException {
        boolean flushSuccessfully = false;
        try {
            this.wideColumnService.batchDelete(this.tableName.getQualifierAsString(), deletes);
            flushSuccessfully = true;
        }
        finally {
            if (!flushSuccessfully && !this.clearBufferOnFail) {
                List<Delete> hDeletes = ElementConvertor.toHBaseDeletes(deletes);
                ConcurrentLinkedQueue<Mutation> concurrentLinkedQueue = this.writeBuffer;
                synchronized (concurrentLinkedQueue) {
                    for (Delete delete : hDeletes) {
                        this.writeBuffer.add((Mutation)delete);
                        this.currentWriteBufferSize += delete.heapSize();
                    }
                }
            }
        }
    }
}

