/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseUEAdmin;
import com.alibaba.hbase.client.AliHBaseUEBufferedMutator;
import com.alibaba.hbase.client.AliHBaseUETable;
import com.alibaba.lindorm.client.AdminService;
import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.LindormServiceProvider;
import com.alibaba.lindorm.client.SystemService;
import com.alibaba.lindorm.client.TableService;
import com.alibaba.lindorm.client.WideColumnService;
import com.alibaba.lindorm.client.core.utils.ClientEnvLogUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliHBaseUEConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(AliHBaseUEConnection.class);
    private Configuration conf;
    private boolean isClosed = false;
    private boolean isAborted = false;
    private String seedServer;
    private String userName;
    private String password;
    private int operationTimeout;
    private int connectTimeout;
    private boolean accessFromInternet;
    private ConcurrentHashMap<String, WideColumnService> wideColumnMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TableService> tableServiceMap = new ConcurrentHashMap();
    private AdminService adminService;
    private SystemService systemService;
    private LindormClientConfig lindormClientConfig;

    public AliHBaseUEConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        this(conf, pool, user);
    }

    public AliHBaseUEConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        this.conf = conf;
        String host = conf.get("hbase.client.endpoint");
        if (host == null || host.trim().isEmpty()) {
            this.seedServer = conf.get("lindorm.client.seedserver");
        } else if (host.contains(":")) {
            this.seedServer = host;
        } else {
            int port = 30020;
            this.seedServer = host + ":" + port;
        }
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.connectTimeout = conf.getInt("hbase.ipc.client.socket.timeout.connect", 10000);
        this.userName = conf.get("hbase.client.username");
        this.password = conf.get("hbase.client.password");
        String publicIdentifier = conf.get("hbase.public.hostname.identifier", "-proxy-hbaseue-pub");
        if (this.seedServer.contains(publicIdentifier)) {
            this.accessFromInternet = true;
        }
        if (conf.get("hbase.access.from.internet") != null) {
            this.accessFromInternet = conf.getBoolean("hbase.access.from.internet", false);
        }
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return new AliHBaseUEBufferedMutator(this, tableName);
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        if (params.getTableName() == null) {
            throw new IllegalArgumentException("TableName cannot be null.");
        }
        return new AliHBaseUEBufferedMutator(this, params.getTableName());
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        return new AliHBaseUETable(tableName, this);
    }

    public Admin getAdmin() throws IOException {
        return new AliHBaseUEAdmin(this);
    }

    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            if (this.adminService != null) {
                this.adminService.close();
            }
        }
        catch (IOException ioE) {
            LOG.error("Error happened when closing adminservice", (Throwable)ioE);
        }
        try {
            if (this.systemService != null) {
                this.systemService.close();
            }
        }
        catch (Throwable e) {
            LOG.error("Error happened when closing systemService", e);
        }
        for (Map.Entry<String, WideColumnService> entry : this.wideColumnMap.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                entry.getValue().close();
            }
            catch (IOException ioE) {
                LOG.error("Error happened when closing WideColumnService for namespace " + entry.getKey(), (Throwable)ioE);
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Table getTable(TableName tableName) throws IOException {
        return new AliHBaseUETable(tableName, this);
    }

    public Table getTable(String tableName) throws IOException {
        return this.getTable(TableName.valueOf((String)tableName));
    }

    public Table getTable(TableName tableName, ExecutorService executorService) throws IOException {
        return this.getTable(tableName, null);
    }

    public void abort(String s, Throwable throwable) {
        this.isAborted = true;
        try {
            this.close();
        }
        catch (IOException ioE) {
            LOG.error("Error happened when aborting", (Throwable)ioE);
        }
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AdminService getAdminService() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Connection is closed");
        }
        if (this.adminService == null) {
            AliHBaseUEConnection aliHBaseUEConnection = this;
            synchronized (aliHBaseUEConnection) {
                if (this.isClosed()) {
                    throw new IOException("Connection is closed");
                }
                if (this.adminService == null) {
                    this.adminService = LindormServiceProvider.AdminServiceProvider.create(this.getLindormConfig());
                }
            }
        }
        return this.adminService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SystemService getSystemService() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Connection is closed");
        }
        if (this.systemService == null) {
            AliHBaseUEConnection aliHBaseUEConnection = this;
            synchronized (aliHBaseUEConnection) {
                if (this.isClosed()) {
                    throw new IOException("Connection is closed");
                }
                if (this.systemService == null) {
                    this.systemService = LindormServiceProvider.SystemServiceProvider.create(this.getLindormConfig());
                }
            }
        }
        return this.systemService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WideColumnService getWideColumnService(String namespace) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Connection is closed");
        }
        if (namespace == null) {
            throw new IOException("namespace can't be null!");
        }
        WideColumnService wideColumnService = this.wideColumnMap.get(namespace);
        if (wideColumnService == null) {
            AliHBaseUEConnection aliHBaseUEConnection = this;
            synchronized (aliHBaseUEConnection) {
                if (this.isClosed()) {
                    throw new IOException("Connection is closed");
                }
                LindormClientConfig config = this.getLindormConfig();
                config.setNamespace(namespace);
                WideColumnService service = LindormServiceProvider.WideColumnServiceProvider.create(config);
                WideColumnService old = this.wideColumnMap.putIfAbsent(namespace, service);
                if (old != null) {
                    service.close();
                    return old;
                }
                return service;
            }
        }
        return wideColumnService;
    }

    private LindormClientConfig createLindormConfig() throws IOException {
        LindormClientConfig lindormClientConfig = LindormClientConfig.create();
        for (Map.Entry entry : this.conf) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            lindormClientConfig.set((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.userName != null && !this.userName.isEmpty() && this.password != null && !this.password.isEmpty()) {
            lindormClientConfig.setUser(this.userName, this.password);
        }
        lindormClientConfig.setSeedServer(this.seedServer.trim());
        lindormClientConfig.setTimeout(this.operationTimeout);
        if (this.accessFromInternet) {
            lindormClientConfig.setBoolean("lindorm.rpc.only.use.seedserver", true);
        }
        if (this.conf.get("lindorm.client.sorter.type") != null) {
            lindormClientConfig.set("lindorm.client.sorter.type", this.conf.get("lindorm.client.sorter.type"));
        } else {
            lindormClientConfig.set("lindorm.client.sorter.type", "NAMESORTER");
        }
        return lindormClientConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LindormClientConfig getLindormConfig() throws IOException {
        if (this.lindormClientConfig == null) {
            AliHBaseUEConnection aliHBaseUEConnection = this;
            synchronized (aliHBaseUEConnection) {
                if (this.lindormClientConfig == null) {
                    this.lindormClientConfig = this.createLindormConfig();
                }
            }
        }
        return new LindormClientConfig(this.lindormClientConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableService getTableServiceService(String namespace) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Connection is closed");
        }
        if (namespace == null) {
            throw new IOException("namespace can't be null!");
        }
        TableService tableService = this.tableServiceMap.get(namespace);
        if (tableService == null) {
            AliHBaseUEConnection aliHBaseUEConnection = this;
            synchronized (aliHBaseUEConnection) {
                if (this.isClosed()) {
                    throw new IOException("Connection is closed");
                }
                LindormClientConfig config = this.getLindormConfig();
                config.setNamespace(namespace);
                TableService service = LindormServiceProvider.TableServiceProvider.create(config);
                TableService old = this.tableServiceMap.putIfAbsent(namespace, service);
                if (old != null) {
                    service.close();
                    return old;
                }
                return service;
            }
        }
        return tableService;
    }

    static {
        ClientEnvLogUtil.setEnabled(false);
    }
}

