/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseUEAggregateService;
import com.alibaba.hbase.client.AliHBaseUEConnection;
import com.alibaba.hbase.client.ElementConvertor;
import com.alibaba.hbase.exception.BatchExceptions;
import com.alibaba.lindorm.client.TableService;
import com.alibaba.lindorm.client.WideColumnService;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.widecolumnservice.WAppend;
import com.alibaba.lindorm.client.core.widecolumnservice.WDelete;
import com.alibaba.lindorm.client.core.widecolumnservice.WGet;
import com.alibaba.lindorm.client.core.widecolumnservice.WIncrement;
import com.alibaba.lindorm.client.core.widecolumnservice.WPut;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WRowMutations;
import com.alibaba.lindorm.client.core.widecolumnservice.WScan;
import com.alibaba.lindorm.client.core.widecolumnservice.WScanner;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WCompareFilter;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.util.Bytes;

public class AliHBaseUETable
implements Table,
RegionLocator {
    private TableName tableName;
    private String tableNameWithoutNamespace;
    private AliHBaseUEConnection connection;
    private Configuration conf;
    private int operationTimeout;
    private WideColumnService wideColumnService;
    private TableService tableService;
    private int defaultScannerCaching;

    public AliHBaseUETable(TableName tableName, AliHBaseUEConnection connection) throws IOException {
        this.tableName = tableName;
        this.connection = connection;
        this.conf = connection.getConfiguration();
        this.operationTimeout = connection.getOperationTimeout();
        this.wideColumnService = connection.getWideColumnService(tableName.getNamespaceAsString());
        this.tableService = connection.getTableServiceService(tableName.getNamespaceAsString());
        this.tableNameWithoutNamespace = tableName.getQualifierAsString();
        this.defaultScannerCaching = this.conf.getInt("hbase.client.scanner.caching", 100);
        if (this.defaultScannerCaching > 100) {
            this.defaultScannerCaching = 100;
        }
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.getRegionLocation(row, false);
    }

    public HRegionLocation getRegionLocation(byte[] row, boolean b) throws IOException {
        org.apache.hadoop.hbase.util.Pair<byte[], byte[]> startEndKey = this.getStartEndKey(row);
        return this.createFakeRegionLocation((byte[])startEndKey.getFirst(), (byte[])startEndKey.getSecond());
    }

    private org.apache.hadoop.hbase.util.Pair<byte[], byte[]> getStartEndKey(byte[] row) throws IOException {
        byte[][] endKeys = this.getEndKeys();
        byte[] preStartKey = HConstants.EMPTY_START_ROW;
        for (byte[] endKey : endKeys) {
            if (Bytes.compareTo((byte[])row, (byte[])endKey) < 0) {
                return new org.apache.hadoop.hbase.util.Pair((Object)preStartKey, (Object)endKey);
            }
            preStartKey = endKey;
        }
        return new org.apache.hadoop.hbase.util.Pair((Object)HConstants.EMPTY_START_ROW, (Object)HConstants.EMPTY_START_ROW);
    }

    private HRegionLocation createFakeRegionLocation(byte[] startKey, byte[] endKey) {
        HRegionInfo regionInfo = new HRegionInfo(this.tableName, startKey, endKey);
        return new HRegionLocation(regionInfo, ServerName.valueOf((String)"localhost", (int)0, (long)0L));
    }

    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        ArrayList<HRegionLocation> fakeRegionLocations = new ArrayList<HRegionLocation>();
        byte[] preStartKey = HConstants.EMPTY_START_ROW;
        byte[][] endKeys = this.getEndKeys();
        for (int i = 0; i < endKeys.length; ++i) {
            byte[] endKey = endKeys[i];
            fakeRegionLocations.add(this.createFakeRegionLocation(preStartKey, endKey));
            preStartKey = endKey;
        }
        return fakeRegionLocations;
    }

    public byte[][] getStartKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getFirst();
    }

    public byte[][] getEndKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getSecond();
    }

    public org.apache.hadoop.hbase.util.Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        Pair<byte[][], byte[][]> pair = this.wideColumnService.getStartEndKeys(this.tableName.getQualifierAsString());
        return new org.apache.hadoop.hbase.util.Pair((Object)pair.getFirst(), (Object)pair.getSecond());
    }

    public TableName getName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        LindormTableDescriptor lindormTableDescriptor = this.wideColumnService.describeTable(this.tableName.getQualifierAsString());
        return ElementConvertor.toHbaseTableDescriptor(this.tableName.getNamespaceAsString(), lindormTableDescriptor);
    }

    public boolean exists(Get get2) throws IOException {
        WGet wGet = ElementConvertor.toLindormGet(get2);
        return this.wideColumnService.exists(this.tableNameWithoutNamespace, wGet);
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        Result[] results = this.get(gets);
        boolean[] existResult = new boolean[results.length];
        for (int i = 0; i < results.length; ++i) {
            existResult[i] = results[i].getRow() != null;
        }
        return existResult;
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException {
        throw new IOException("BatchCallback not supported, use put(List<Put> puts), get(List<Get> gets) or delete(List<Delete> deletes) respectively");
    }

    public Result get(Get get2) throws IOException {
        WResult result = this.wideColumnService.get(this.tableNameWithoutNamespace, ElementConvertor.toLindormGet(get2));
        return ElementConvertor.toHBaseResult(result);
    }

    public Result[] get(List<Get> gets) throws IOException {
        WResult[] results = this.wideColumnService.batchGet(this.tableNameWithoutNamespace, ElementConvertor.toLindormGets(gets));
        return ElementConvertor.toHBaseResults(results);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        return new Scanner(scan);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public void put(Put put2) throws IOException {
        WPut wPut = ElementConvertor.toLindormPut(put2);
        this.wideColumnService.put(this.tableNameWithoutNamespace, wPut);
    }

    public void put(List<Put> puts) throws IOException {
        List<WPut> wPuts = ElementConvertor.toLindormPuts(puts);
        this.wideColumnService.batchPut(this.tableNameWithoutNamespace, wPuts);
    }

    public void delete(Delete delete) throws IOException {
        WDelete wDelete = ElementConvertor.toLindormDelete(delete);
        this.wideColumnService.delete(this.tableNameWithoutNamespace, wDelete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        List<WDelete> wDeletes = ElementConvertor.toLindormDeleteList(deletes);
        this.wideColumnService.batchDelete(this.tableNameWithoutNamespace, wDeletes);
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp op, byte[] value, RowMutations rowMutations) throws IOException {
        WRowMutations wRowMutations = ElementConvertor.toLindormRowMutation(rowMutations);
        WCompareFilter.CompareOp wOp = ElementConvertor.toLindormCompareOp(op);
        return this.wideColumnService.checkAndMutate(this.tableNameWithoutNamespace, row, family, qualifier, wOp, value, wRowMutations);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put2) throws IOException {
        return this.checkAndPut(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, put2);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        WDelete wDelete = ElementConvertor.toLindormDelete(delete);
        return this.wideColumnService.checkAndDelete(this.tableNameWithoutNamespace, row, family, qualifier, value, wDelete);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put2) throws IOException {
        WPut wPut = ElementConvertor.toLindormPut(put2);
        WCompareFilter.CompareOp wOp = ElementConvertor.toLindormCompareOp(compareOp);
        return this.wideColumnService.checkAndPut(this.tableNameWithoutNamespace, row, family, qualifier, wOp, value, wPut);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        WDelete wDelete = ElementConvertor.toLindormDelete(delete);
        WCompareFilter.CompareOp wOp = ElementConvertor.toLindormCompareOp(compareOp);
        return this.wideColumnService.checkAndDelete(this.tableNameWithoutNamespace, row, family, qualifier, wOp, value, wDelete);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, Durability.SYNC_WAL);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        Increment increment2 = new Increment(row);
        increment2.addColumn(family, qualifier, amount);
        Result result = this.increment(increment2);
        return Bytes.toLong((byte[])result.getValue(family, qualifier));
    }

    public void mutateRow(RowMutations rm) throws IOException {
        for (Mutation mutation : rm.getMutations()) {
            if (mutation instanceof Put) {
                this.put((Put)mutation);
                continue;
            }
            if (mutation instanceof Delete) {
                this.delete((Delete)mutation);
                continue;
            }
            throw new IOException("mutateRow not supported, use put(List<Put> puts), get(List<Get> gets) or delete(List<Delete> deletes) respectively");
        }
    }

    public Result append(Append append2) throws IOException {
        WAppend wAppend = ElementConvertor.toLindormAppend(append2);
        WResult wResult = this.wideColumnService.append(this.tableNameWithoutNamespace, wAppend);
        return ElementConvertor.toHBaseResult(wResult);
    }

    public Result increment(Increment increment2) throws IOException {
        WIncrement wIncrement = ElementConvertor.toLindormIncrement(increment2);
        WResult wResult = this.wideColumnService.increment(this.tableNameWithoutNamespace, wIncrement);
        return ElementConvertor.toHBaseResult(wResult);
    }

    public void close() throws IOException {
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch(List<? extends Row> actions, Object[] results) throws IOException {
        ArrayList<Object> tactions = new ArrayList<Object>(actions.size());
        for (Row row : actions) {
            if (row instanceof Get) {
                tactions.add(ElementConvertor.toLindormGet((Get)row));
                continue;
            }
            if (row instanceof Put) {
                tactions.add(ElementConvertor.toLindormPut((Put)row));
                continue;
            }
            if (row instanceof Delete) {
                tactions.add(ElementConvertor.toLindormDelete((Delete)row));
                continue;
            }
            if (row instanceof Append) {
                tactions.add(ElementConvertor.toLindormAppend((Append)row));
                continue;
            }
            throw new UnsupportedOperationException("Unsupport type " + row.getClass().getName() + " in batch operation.");
        }
        Object[] hbaseResults = null;
        BatchExceptions batchExceptions = new BatchExceptions();
        try {
            hbaseResults = this.batch(this.tableName.getQualifierAsString(), tactions);
        }
        catch (Throwable throwable) {
            for (int i = 0; i < hbaseResults.length; ++i) {
                if (results != null) {
                    if (hbaseResults[i] == null) {
                        results[i] = null;
                        continue;
                    }
                    if (hbaseResults[i] instanceof WResult) {
                        results[i] = ElementConvertor.toHBaseResult((WResult)hbaseResults[i]);
                        continue;
                    }
                    if (hbaseResults[i] instanceof Result) {
                        results[i] = hbaseResults[i];
                        continue;
                    }
                    if (hbaseResults[i] instanceof Throwable) {
                        results[i] = hbaseResults[i];
                        batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
                        continue;
                    }
                    throw new IOException("Not unsupported result type " + hbaseResults[i]);
                }
                if (hbaseResults[i] == null || !(hbaseResults[i] instanceof Throwable)) continue;
                batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
            }
            throw throwable;
        }
        for (int i = 0; i < hbaseResults.length; ++i) {
            if (results != null) {
                if (hbaseResults[i] == null) {
                    results[i] = null;
                    continue;
                }
                if (hbaseResults[i] instanceof WResult) {
                    results[i] = ElementConvertor.toHBaseResult((WResult)hbaseResults[i]);
                    continue;
                }
                if (hbaseResults[i] instanceof Result) {
                    results[i] = hbaseResults[i];
                    continue;
                }
                if (hbaseResults[i] instanceof Throwable) {
                    results[i] = hbaseResults[i];
                    batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
                    continue;
                }
                throw new IOException("Not unsupported result type " + hbaseResults[i]);
            }
            if (hbaseResults[i] == null || !(hbaseResults[i] instanceof Throwable)) continue;
            batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
        }
        if (batchExceptions.hasErrors()) {
            throw batchExceptions.makeException();
        }
    }

    public Object[] batch(List<? extends Row> actions) throws IOException {
        Object[] results = new Object[actions.size()];
        this.batch(actions, results);
        return results;
    }

    public Object[] batch(String tableName, List<Object> actions) throws IOException {
        Object[] results = new Object[actions.size()];
        ArrayList<WGet> getActions = new ArrayList<WGet>();
        ArrayList<Integer> getActionsIndex = new ArrayList<Integer>();
        ArrayList<WPut> putActions = new ArrayList<WPut>();
        ArrayList<Integer> putActionsIndex = new ArrayList<Integer>();
        ArrayList<WDelete> delActions = new ArrayList<WDelete>();
        ArrayList<Integer> delActionsIndex = new ArrayList<Integer>();
        ArrayList<WAppend> appendActions = new ArrayList<WAppend>();
        ArrayList<Integer> appendActionsIndex = new ArrayList<Integer>();
        for (int i = 0; i < actions.size(); ++i) {
            if (actions.get(i) instanceof WGet) {
                getActions.add((WGet)actions.get(i));
                getActionsIndex.add(i);
                continue;
            }
            if (actions.get(i) instanceof WPut) {
                putActions.add((WPut)actions.get(i));
                putActionsIndex.add(i);
                continue;
            }
            if (actions.get(i) instanceof WDelete) {
                delActions.add((WDelete)actions.get(i));
                delActionsIndex.add(i);
                continue;
            }
            if (actions.get(i) instanceof WAppend) {
                appendActions.add((WAppend)actions.get(i));
                appendActionsIndex.add(i);
                continue;
            }
            throw new UnsupportedOperationException("Not supported action " + actions.get(i).getClass().getName());
        }
        if (!getActions.isEmpty()) {
            try {
                WResult[] getResult = this.wideColumnService.batchGet(tableName, getActions);
                if (getResult.length != getActionsIndex.size()) {
                    throw new IOException("Batch get exception , expect " + getActionsIndex.size() + " results , current return " + getResult.length);
                }
                for (int i = 0; i < getActionsIndex.size(); ++i) {
                    results[((Integer)getActionsIndex.get((int)i)).intValue()] = getResult[i];
                }
            }
            catch (Throwable e) {
                for (Integer index : getActionsIndex) {
                    results[index.intValue()] = e;
                }
            }
        }
        if (!putActions.isEmpty()) {
            try {
                this.wideColumnService.batchPut(tableName, putActions);
                for (Integer index : putActionsIndex) {
                    results[index.intValue()] = new Result();
                }
            }
            catch (Throwable e) {
                for (Integer index : putActionsIndex) {
                    results[index.intValue()] = e;
                }
            }
        }
        if (!delActions.isEmpty()) {
            try {
                this.wideColumnService.batchDelete(tableName, delActions);
                for (Integer index : delActionsIndex) {
                    results[index.intValue()] = new Result();
                }
            }
            catch (Throwable e) {
                for (Integer index : delActionsIndex) {
                    results[index.intValue()] = e;
                }
            }
        }
        if (!appendActions.isEmpty()) {
            try {
                for (WAppend append2 : appendActions) {
                    this.wideColumnService.append(tableName, append2);
                }
                for (Integer index : appendActionsIndex) {
                    results[index.intValue()] = new Result();
                }
            }
            catch (Throwable e) {
                for (Integer index : appendActionsIndex) {
                    results[index.intValue()] = e;
                }
            }
        }
        return results;
    }

    public <R> Object[] batchCallback(List<? extends Row> list, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("batchCallback not supported");
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> call) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        if (service != AggregateProtos.AggregateService.class) {
            throw new UnsupportedOperationException("coprocessorService " + service + " not supported");
        }
        AliHBaseUEAggregateService instance = new AliHBaseUEAggregateService(this.tableService, this.tableNameWithoutNamespace);
        Object result = callable.call(instance);
        if (callback != null) {
            callback.update(null, null, result);
        }
    }

    public long getWriteBufferSize() {
        throw new UnsupportedOperationException("getWriteBufferSize not supported");
    }

    public void setWriteBufferSize(long l) throws IOException {
        throw new UnsupportedOperationException("setWriteBufferSize not supported");
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message message, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("batchCoprocessorService not supported");
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message message, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("batchCoprocessorService not supported");
    }

    public void setOperationTimeout(int i) {
        throw new UnsupportedOperationException("setOperationTimeout not supported");
    }

    public int getOperationTimeout() {
        return this.connection.getOperationTimeout();
    }

    public int getRpcTimeout() {
        return this.connection.getOperationTimeout();
    }

    public void setRpcTimeout(int i) {
        throw new UnsupportedOperationException("setRpcTimeout not supported");
    }

    public int getReadRpcTimeout() {
        return this.connection.getOperationTimeout();
    }

    public void setReadRpcTimeout(int i) {
        throw new UnsupportedOperationException("setReadRpcTimeout not supported");
    }

    public int getWriteRpcTimeout() {
        return this.connection.getOperationTimeout();
    }

    public void setWriteRpcTimeout(int i) {
        throw new UnsupportedOperationException("setWriteRpcTimeout not supported");
    }

    private class Scanner
    implements ResultScanner {
        private final WScanner wScanner;
        protected Result lastResult = null;
        protected final Queue<Result> cache = new ArrayDeque<Result>();

        public Scanner(Scan scan) throws IOException {
            if (scan.getCaching() <= 0) {
                scan.setCaching(AliHBaseUETable.this.defaultScannerCaching);
            } else if (scan.getCaching() == 1 && scan.isReversed()) {
                scan.setCaching(scan.getCaching() + 1);
            }
            WScan wScan = ElementConvertor.toLindormScan(scan);
            this.wScanner = AliHBaseUETable.this.wideColumnService.getScanner(AliHBaseUETable.this.tableNameWithoutNamespace, wScan);
        }

        public Iterator<Result> iterator() {
            return new Iterator<Result>(){
                private Iterator<WResult> it;
                {
                    this.it = Scanner.this.wScanner.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Result next() {
                    WResult wResult = this.it.next();
                    if (wResult == null) {
                        return null;
                    }
                    return ElementConvertor.toHBaseResult(wResult);
                }
            };
        }

        public Result next() throws IOException {
            WResult r = this.wScanner.next();
            if (r == null) {
                return null;
            }
            return ElementConvertor.toHBaseResult(r);
        }

        public void close() {
        }

        public Result[] next(int nbRows) throws IOException {
            Result next;
            ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
            for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
                resultSets.add(next);
            }
            return resultSets.toArray(new Result[resultSets.size()]);
        }
    }
}

