/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.ThriftUtilities;
import com.alibaba.hbase.thrift2.generated.TAppend;
import com.alibaba.hbase.thrift2.generated.TColumnIncrement;
import com.alibaba.hbase.thrift2.generated.TDelete;
import com.alibaba.hbase.thrift2.generated.TGet;
import com.alibaba.hbase.thrift2.generated.THBaseService;
import com.alibaba.hbase.thrift2.generated.TIncrement;
import com.alibaba.hbase.thrift2.generated.TPut;
import com.alibaba.hbase.thrift2.generated.TResult;
import com.alibaba.hbase.thrift2.generated.TRowMutations;
import com.alibaba.hbase.thrift2.generated.TScan;
import com.alibaba.hbase.thrift2.generated.TTableDescriptor;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;

public class ThriftTable
implements Table {
    private TableName tableName;
    private Configuration conf;
    private TTransport tTransport;
    private THBaseService.Client client;
    private ByteBuffer tableNameInBytes;
    private int operationTimeout;
    private final int scannerCaching;

    public ThriftTable(TableName tableName, THBaseService.Client client, TTransport tTransport, Configuration conf) {
        this.tableName = tableName;
        this.tableNameInBytes = ByteBuffer.wrap(tableName.toBytes());
        this.conf = conf;
        this.tTransport = tTransport;
        this.client = client;
        this.scannerCaching = conf.getInt("alihbase.client.scanner.caching", 100);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
    }

    public TableName getName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        try {
            TTableDescriptor tableDescriptor = this.client.getTableDescriptor(ThriftUtilities.tableNameFromHBase(this.tableName));
            return ThriftUtilities.tableDescriptorFromThrift(tableDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public boolean exists(Get get2) throws IOException {
        TGet tGet = ThriftUtilities.getFromHBase(get2);
        try {
            return this.client.exists(this.tableNameInBytes, tGet);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        ArrayList<TGet> tGets = new ArrayList<TGet>();
        for (Get get2 : gets) {
            tGets.add(ThriftUtilities.getFromHBase(get2));
        }
        try {
            List<Boolean> results = this.client.existsAll(this.tableNameInBytes, tGets);
            boolean[] booleans = new boolean[results.size()];
            for (int i = 0; i < results.size(); ++i) {
                booleans[i] = results.get(i);
            }
            return booleans;
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException {
        throw new IOException("Batch not supported in ThriftTable, use put(List<Put> puts), get(List<Get> gets) or delete(List<Delete> deletes) respectively");
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException {
        throw new IOException("BatchCallback not supported in ThriftTable, use put(List<Put> puts), get(List<Get> gets) or delete(List<Delete> deletes) respectively");
    }

    public Result get(Get get2) throws IOException {
        TGet tGet = ThriftUtilities.getFromHBase(get2);
        try {
            TResult tResult = this.client.get(this.tableNameInBytes, tGet);
            return ThriftUtilities.resultFromThrift(tResult);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public Result[] get(List<Get> gets) throws IOException {
        List<TGet> tGets = ThriftUtilities.getsFromHBase(gets);
        try {
            List<TResult> results = this.client.getMultiple(this.tableNameInBytes, tGets);
            return ThriftUtilities.resultsFromThrift(results);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        return new Scanner(scan);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public void put(Put put2) throws IOException {
        TPut tPut = ThriftUtilities.putFromHBase(put2);
        try {
            this.client.put(this.tableNameInBytes, tPut);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void put(List<Put> puts) throws IOException {
        List<TPut> tPuts = ThriftUtilities.putsFromHBase(puts);
        try {
            this.client.putMultiple(this.tableNameInBytes, tPuts);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void delete(Delete delete) throws IOException {
        TDelete tDelete = ThriftUtilities.deleteFromHBase(delete);
        try {
            this.client.deleteSingle(this.tableNameInBytes, tDelete);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void delete(List<Delete> deletes) throws IOException {
        List<TDelete> tDeletes = ThriftUtilities.deletesFromHBase(deletes);
        try {
            this.client.deleteMultiple(this.tableNameInBytes, tDeletes);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp op, byte[] value, RowMutations mutation) throws IOException {
        try {
            ByteBuffer valueBuffer = value == null ? null : ByteBuffer.wrap(value);
            return this.client.checkAndMutate(this.tableNameInBytes, ByteBuffer.wrap(row), ByteBuffer.wrap(family), ByteBuffer.wrap(qualifier), ThriftUtilities.compareOpFromHBase(op), valueBuffer, ThriftUtilities.rowMutationsFromHBase(mutation));
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put2) throws IOException {
        try {
            ByteBuffer valueBuffer = value == null ? null : ByteBuffer.wrap(value);
            return this.client.checkAndPut(this.tableNameInBytes, ByteBuffer.wrap(row), ByteBuffer.wrap(family), ByteBuffer.wrap(qualifier), valueBuffer, ThriftUtilities.putFromHBase(put2));
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        try {
            ByteBuffer valueBuffer = value == null ? null : ByteBuffer.wrap(value);
            return this.client.checkAndDelete(this.tableNameInBytes, ByteBuffer.wrap(row), ByteBuffer.wrap(family), ByteBuffer.wrap(qualifier), valueBuffer, ThriftUtilities.deleteFromHBase(delete));
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, Durability.SYNC_WAL);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        try {
            TIncrement increment2 = new TIncrement();
            increment2.setRow(row);
            TColumnIncrement columnValue = new TColumnIncrement();
            columnValue.setFamily(family).setQualifier(qualifier);
            columnValue.setAmount(amount);
            increment2.addToColumns(columnValue);
            increment2.setDurability(ThriftUtilities.durabilityFromHBase(durability));
            TResult tResult = this.client.increment(this.tableNameInBytes, increment2);
            Result result = ThriftUtilities.resultFromThrift(tResult);
            return Bytes.toLong((byte[])result.getValue(family, qualifier));
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void mutateRow(RowMutations rm) throws IOException {
        TRowMutations tRowMutations = ThriftUtilities.rowMutationsFromHBase(rm);
        try {
            this.client.mutateRow(this.tableNameInBytes, tRowMutations);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public Result append(Append append2) throws IOException {
        TAppend tAppend = ThriftUtilities.appendFromHBase(append2);
        try {
            TResult tResult = this.client.append(this.tableNameInBytes, tAppend);
            return ThriftUtilities.resultFromThrift(tResult);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public Result increment(Increment increment2) throws IOException {
        TIncrement tIncrement = ThriftUtilities.incrementFromHBase(increment2);
        try {
            TResult tResult = this.client.increment(this.tableNameInBytes, tIncrement);
            return ThriftUtilities.resultFromThrift(tResult);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        this.tTransport.close();
    }

    public boolean checkAndPut(byte[] bytes, byte[] bytes1, byte[] bytes2, CompareFilter.CompareOp compareOp, byte[] bytes3, Put put2) throws IOException {
        throw new UnsupportedOperationException("checkAndPut with compareOp not supported in ThriftTable");
    }

    public boolean checkAndDelete(byte[] bytes, byte[] bytes1, byte[] bytes2, CompareFilter.CompareOp compareOp, byte[] bytes3, Delete delete) throws IOException {
        throw new UnsupportedOperationException("checkAndDelete with compareOp not supported in ThriftTable");
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        throw new UnsupportedOperationException("coprocessorService not supported in ThriftTable");
    }

    public Object[] batch(List<? extends Row> list) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("batch not supported in ThriftTable, use put(list<Put>) instead");
    }

    public <R> Object[] batchCallback(List<? extends Row> list, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("batchCallback not supported in ThriftTable");
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> aClass, byte[] bytes, byte[] bytes1, Batch.Call<T, R> call) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("coprocessorService not supported in ThriftTable");
    }

    public <T extends Service, R> void coprocessorService(Class<T> aClass, byte[] bytes, byte[] bytes1, Batch.Call<T, R> call, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("coprocessorService not supported in ThriftTable");
    }

    public long getWriteBufferSize() {
        throw new UnsupportedOperationException("getWriteBufferSize not supported in ThriftTable");
    }

    public void setWriteBufferSize(long l) throws IOException {
        throw new UnsupportedOperationException("setWriteBufferSize not supported in ThriftTable");
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message message, byte[] bytes, byte[] bytes1, R r) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("batchCoprocessorService not supported in ThriftTable");
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message message, byte[] bytes, byte[] bytes1, R r, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("batchCoprocessorService not supported in ThriftTable");
    }

    public void setOperationTimeout(int i) {
        throw new UnsupportedOperationException("setOperationTimeout not supported in ThriftTable");
    }

    public int getOperationTimeout() {
        throw new UnsupportedOperationException("getOperationTimeout not supported in ThriftTable");
    }

    public int getRpcTimeout() {
        throw new UnsupportedOperationException("getRpcTimeout not supported in ThriftTable");
    }

    public void setRpcTimeout(int i) {
        throw new UnsupportedOperationException("setRpcTimeout not supported in ThriftTable");
    }

    public int getReadRpcTimeout() {
        throw new UnsupportedOperationException("getReadRpcTimeout not supported in ThriftTable");
    }

    public void setReadRpcTimeout(int i) {
        throw new UnsupportedOperationException("setReadRpcTimeout not supported in ThriftTable");
    }

    public int getWriteRpcTimeout() {
        throw new UnsupportedOperationException("getWriteRpcTimeout not supported in ThriftTable");
    }

    public void setWriteRpcTimeout(int i) {
        throw new UnsupportedOperationException("setWriteRpcTimeout not supported in ThriftTable");
    }

    private class Scanner
    implements ResultScanner {
        protected TScan scan;
        protected Result lastResult = null;
        protected final Queue<Result> cache = new ArrayDeque<Result>();

        public Scanner(Scan scan) throws IOException {
            if (scan.getCaching() <= 0) {
                scan.setCaching(ThriftTable.this.scannerCaching);
            } else if (scan.getCaching() == 1 && scan.isReversed()) {
                scan.setCaching(scan.getCaching() + 1);
            }
            this.scan = ThriftUtilities.scanFromHBase(scan);
        }

        public Result[] next(int nbRows) throws IOException {
            Result next;
            ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
            for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
                resultSets.add(next);
            }
            return resultSets.toArray(new Result[resultSets.size()]);
        }

        public Iterator<Result> iterator() {
            return new Iterator<Result>(){
                Result next = null;

                @Override
                public boolean hasNext() {
                    if (this.next == null) {
                        try {
                            this.next = Scanner.this.next();
                            return this.next != null;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return true;
                }

                @Override
                public Result next() {
                    if (!this.hasNext()) {
                        return null;
                    }
                    Result temp = this.next;
                    this.next = null;
                    return temp;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public Result next() throws IOException {
            if (this.cache.size() == 0) {
                this.setupNextScanner();
                try {
                    List<TResult> tResults = ThriftTable.this.client.getScannerResults(ThriftTable.this.tableNameInBytes, this.scan, this.scan.getCaching());
                    Result[] results = ThriftUtilities.resultsFromThrift(tResults);
                    boolean firstKey = true;
                    for (Result result : results) {
                        if (firstKey) {
                            firstKey = false;
                            if (this.scan.isReversed() && this.lastResult != null && Bytes.equals((byte[])this.lastResult.getRow(), (byte[])result.getRow())) continue;
                        }
                        this.cache.add(result);
                        this.lastResult = result;
                    }
                }
                catch (TException e) {
                    throw new IOException(e);
                }
            }
            if (this.cache.size() > 0) {
                return this.cache.poll();
            }
            return null;
        }

        public void close() {
        }

        public boolean renewLease() {
            throw new RuntimeException("renewLease() not supported");
        }

        public ScanMetrics getScanMetrics() {
            throw new RuntimeException("getScanMetrics() not supported");
        }

        private void setupNextScanner() {
            if (this.lastResult != null) {
                byte[] lastRow = this.lastResult.getRow();
                if (this.scan.isReversed()) {
                    this.scan.setStartRow(lastRow);
                } else {
                    this.scan.setStartRow(this.createClosestRowAfter(lastRow));
                }
            }
        }

        protected byte[] createClosestRowAfter(byte[] row) {
            if (row == null) {
                throw new RuntimeException("The passed row is null");
            }
            return Arrays.copyOf(row, row.length + 1);
        }
    }
}

