/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client;

import com.alibaba.lindorm.client.core.utils.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LindormClientConfig
implements Cloneable {
    private static final Log LOG = LogFactory.getLog(LindormClientConfig.class);
    private final HashMap<String, String> properties = new HashMap();
    protected String configLocation;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public LindormClientConfig() {
        if (this.classLoader == null) {
            this.classLoader = LindormClientConfig.class.getClassLoader();
        }
    }

    public LindormClientConfig(String file) throws IOException {
        this();
        this.loadConfig(file);
    }

    public LindormClientConfig(LindormClientConfig parent) {
        if (this.classLoader == null) {
            this.classLoader = LindormClientConfig.class.getClassLoader();
        }
        this.properties.putAll(parent.properties);
        this.configLocation = parent.configLocation;
    }

    public LindormClientConfig setUser(String userName, String password) {
        this.set("lindorm.client.username", userName);
        this.set("lindorm.client.password", password);
        return this;
    }

    public String getUser() {
        return this.get("lindorm.client.username");
    }

    public LindormClientConfig setNamespace(String namespace) {
        this.set("lindorm.client.namespace", namespace);
        return this;
    }

    public String getNamespace() {
        return this.get("lindorm.client.namespace", null);
    }

    public LindormClientConfig setTimeout(int timeout) {
        this.setInt("lindorm.client.timeout", timeout);
        return this;
    }

    public int getTimeout() {
        return this.getInt("lindorm.client.timeout", 120000);
    }

    public LindormClientConfig setSeedServer(String ... hostAndport) {
        String hosts = StringUtils.join(",", Arrays.asList(hostAndport));
        this.set("lindorm.client.seedserver", hosts);
        return this;
    }

    public String getSeedServer() {
        return this.get("lindorm.client.seedserver", null);
    }

    public LindormClientConfig set(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public LindormClientConfig remove(String key) {
        this.properties.remove(key);
        return this;
    }

    public String get(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        return null;
    }

    public String get(String key, String defaultValue) {
        String value = this.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public final String getString(String key, String defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public final int getInt(String key, int defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public LindormClientConfig setInt(String key, int value) {
        this.set(key, Integer.toString(value));
        return this;
    }

    public final short getShort(String key, short defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Short.parseShort(value);
        }
        return defaultValue;
    }

    public LindormClientConfig setShort(String key, short value) {
        this.set(key, Short.toString(value));
        return this;
    }

    public final long getLong(String key, long defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public LindormClientConfig setLong(String key, long value) {
        this.set(key, Long.toString(value));
        return this;
    }

    public final float getFloat(String key, float defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Float.parseFloat(value);
        }
        return defaultValue;
    }

    public LindormClientConfig setFloat(String key, float value) {
        this.set(key, Float.toString(value));
        return this;
    }

    public final double getDouble(String key, double defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    public LindormClientConfig setDouble(String key, double value) {
        this.set(key, Double.toString(value));
        return this;
    }

    public final boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public final Class<?> getClass(String key, String defaultValue, Class<?> defaultClass) {
        String value = this.get(key, defaultValue);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(value, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            clazz = defaultClass;
        }
        return clazz;
    }

    public LindormClientConfig setBoolean(String key, boolean value) {
        this.set(key, Boolean.toString(value));
        return this;
    }

    public LindormClientConfig mergeFromMap(Map<String, String> configs) {
        if (configs != null) {
            for (Map.Entry<String, String> config : configs.entrySet()) {
                this.set(config.getKey(), config.getValue());
            }
        }
        return this;
    }

    public final String dumpConfiguration(Set<String> keyToDump) {
        if (this.properties.isEmpty()) {
            return "No configuration settings stored";
        }
        StringBuilder response = new StringBuilder("Configuration:\n");
        response.append("File [" + this.configLocation + "]\n");
        int line = 0;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (keyToDump != null && !keyToDump.contains(entry.getKey())) continue;
            if (line > 0) {
                response.append("\n");
            }
            response.append(entry.getKey()).append(" = ");
            response.append(entry.getValue());
            ++line;
        }
        return response.toString();
    }

    public final String dumpConfiguration() {
        return this.dumpConfiguration(null);
    }

    public final Map<String, String> getMap() {
        return new HashMap<String, String>(this.properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig(String file) throws FileNotFoundException, IOException {
        FileInputStream file_stream = new FileInputStream(file);
        try {
            this.loadConfig(file_stream);
            this.configLocation = file;
            LOG.info((Object)("Successfully loaded configuration file: " + file));
        }
        finally {
            file_stream.close();
        }
    }

    protected void loadConfig(InputStream inputStream) throws IOException {
        Properties props = new Properties();
        props.load(inputStream);
        this.loadHashMap(props);
    }

    private void loadHashMap(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.properties.put(key, props.getProperty(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResource(String fileName) throws IOException {
        URL url = this.classLoader.getResource(fileName);
        if (url != null) {
            InputStream inputStream = url.openStream();
            try {
                this.loadConfig(inputStream);
                LOG.info((Object)("Successfully loaded configuration file: " + url.getPath()));
            }
            finally {
                inputStream.close();
            }
        }
    }

    public static LindormClientConfig create() throws IOException {
        LindormClientConfig config = new LindormClientConfig();
        config.addResource("lindorm-client.properties");
        return config;
    }
}

