/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.ColumnSlot;
import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConjunctiveClause {
    private List<ColumnSlot> columnSlots;

    public ConjunctiveClause(LColumn column, ComparisonExpression expression) throws IllegalDataException {
        this.columnSlots = Collections.singletonList(ColumnSlot.create(column, expression));
    }

    public ConjunctiveClause(List<ColumnSlot> newColumnSlots) {
        this.columnSlots = newColumnSlots;
    }

    public ConjunctiveClause and(ConjunctiveClause other) {
        if (this.columnSlots == null || other.columnSlots == null) {
            return new ConjunctiveClause(null);
        }
        int numColumns = this.columnSlots.size();
        int numOtherColumns = other.columnSlots.size();
        int i = 0;
        int j = 0;
        ArrayList<ColumnSlot> newColumnSlots = new ArrayList<ColumnSlot>(numColumns + numOtherColumns);
        while (i < numColumns || j < numOtherColumns) {
            if (j >= numOtherColumns) {
                newColumnSlots.add(this.columnSlots.get(i++));
                continue;
            }
            if (i >= numColumns) {
                newColumnSlots.add(other.columnSlots.get(j++));
                continue;
            }
            ColumnSlot columnSlot = this.columnSlots.get(i);
            ColumnSlot otherColumnSlot = other.columnSlots.get(j);
            int compare = CompilerUtils.compareColumnPosition(columnSlot.getColumn(), otherColumnSlot.getColumn());
            if (compare < 0) {
                newColumnSlots.add(columnSlot);
                ++i;
                continue;
            }
            if (compare > 0) {
                newColumnSlots.add(otherColumnSlot);
                ++j;
                continue;
            }
            ColumnSlot result = columnSlot.intersect(otherColumnSlot);
            if (!result.isEmpty()) {
                newColumnSlots.add(result);
                ++i;
                ++j;
                continue;
            }
            newColumnSlots = null;
            break;
        }
        return new ConjunctiveClause(newColumnSlots);
    }

    public List<ColumnSlot> getColumnSlots() {
        return this.columnSlots;
    }

    public boolean isEmpty() {
        return this.columnSlots == null || this.columnSlots.isEmpty();
    }

    public int hashCode() {
        if (this.columnSlots == null) {
            return 0;
        }
        int result = 1;
        for (ColumnSlot columnSlot : this.columnSlots) {
            result = result * 31 + columnSlot.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConjunctiveClause)) {
            return false;
        }
        ConjunctiveClause other = (ConjunctiveClause)obj;
        return this.columnSlots == null ? other.columnSlots == null : this.columnSlots.equals(other.columnSlots);
    }
}

