/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.ColumnSlot;
import com.alibaba.lindorm.client.core.compile.Compilable;
import com.alibaba.lindorm.client.core.compile.ConjunctiveClause;
import com.alibaba.lindorm.client.core.compile.DisjunctiveNormalForm;
import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.compile.IntervalQuery;
import com.alibaba.lindorm.client.core.compile.PrefixQuery;
import com.alibaba.lindorm.client.core.compile.QueryFilterInfo;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;

public class DNFCompiler
implements Compilable<List<IntervalQuery>> {
    private TableMeta table;
    private DisjunctiveNormalForm dnf;

    public DNFCompiler(TableMeta table, DisjunctiveNormalForm dnf) {
        this.table = table;
        this.dnf = dnf;
    }

    @Override
    public List<IntervalQuery> compile() throws LindormException {
        List<PrefixQuery> prefixQueries = this.generate();
        return this.optimize(prefixQueries);
    }

    public List<PrefixQuery> generate() {
        if (this.dnf.isDegenerate()) {
            return null;
        }
        List<ConjunctiveClause> conjunctiveClauses = this.dnf.getConjunctiveClauses();
        ArrayList<PrefixQuery> prefixQueries = new ArrayList<PrefixQuery>(conjunctiveClauses.size());
        for (ConjunctiveClause conjunctiveClause : conjunctiveClauses) {
            PrefixQuery query = this.generate(this.table, conjunctiveClause);
            if (query == null) continue;
            prefixQueries.add(query);
        }
        return prefixQueries;
    }

    private PrefixQuery generate(TableMeta table, ConjunctiveClause expression) {
        List<ColumnSlot> columnSlots = expression.getColumnSlots();
        List<ColumnSlot> consecutivePKColumns = this.pickUpConsecutivePKColumns(columnSlots);
        if (this.checkNullValuesExist(consecutivePKColumns)) {
            return null;
        }
        return CompilerUtils.generatePrefixQuery(table, columnSlots, consecutivePKColumns);
    }

    private boolean checkNullValuesExist(List<ColumnSlot> columnSlots) {
        for (ColumnSlot columnSlot : columnSlots) {
            if (!columnSlot.isNullValue()) continue;
            return true;
        }
        return false;
    }

    private List<ColumnSlot> pickUpConsecutivePKColumns(List<ColumnSlot> columnSlots) {
        int position = 0;
        ArrayList<ColumnSlot> consecutivePKColumns = new ArrayList<ColumnSlot>();
        for (ColumnSlot columnSlot : columnSlots) {
            LColumn column = columnSlot.getColumn();
            Interval interval = columnSlot.getInterval();
            if (!column.isPrimaryKey() || column.getPosition() != position || !columnSlot.isNullValue() && !interval.isSingleValue()) break;
            consecutivePKColumns.add(columnSlot);
            ++position;
        }
        return consecutivePKColumns;
    }

    private List<IntervalQuery> optimize(List<PrefixQuery> prefixQueries) {
        if (prefixQueries == null || prefixQueries.isEmpty()) {
            return null;
        }
        Map<QueryFilterInfo, Queue<Interval>> queries = this.groupByFilterInfo(prefixQueries);
        ArrayList<PrefixQuery> mergedPrefixQueries = new ArrayList<PrefixQuery>(prefixQueries.size());
        for (Map.Entry<QueryFilterInfo, Queue<Interval>> entry : queries.entrySet()) {
            Queue<Interval> prefixes = entry.getValue();
            List<Interval> intervals = this.union(prefixes);
            mergedPrefixQueries.add(new PrefixQuery(intervals, entry.getKey()));
        }
        return this.generateIntervalQueries(mergedPrefixQueries);
    }

    private Map<QueryFilterInfo, Queue<Interval>> groupByFilterInfo(List<PrefixQuery> prefixQueries) {
        HashMap<QueryFilterInfo, Queue<Interval>> groupByFilterInfo = new HashMap<QueryFilterInfo, Queue<Interval>>();
        for (PrefixQuery prefixQuery : prefixQueries) {
            QueryFilterInfo filterInfo = prefixQuery.getFilterInfo();
            if (!groupByFilterInfo.containsKey(filterInfo)) {
                groupByFilterInfo.put(filterInfo, new PriorityQueue<Interval>(11, new Comparator<Interval>(){

                    @Override
                    public int compare(Interval interval, Interval otherInterval) {
                        if (interval.isLowerUnbound()) {
                            return -1;
                        }
                        if (otherInterval.isLowerUnbound()) {
                            return 1;
                        }
                        return Bytes.compareTo(interval.getLower(), otherInterval.getLower());
                    }
                }));
            }
            Queue intervals = (Queue)groupByFilterInfo.get(filterInfo);
            intervals.addAll(prefixQuery.getPrefixes());
        }
        return groupByFilterInfo;
    }

    private List<Interval> union(Queue<Interval> prefixes) {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        byte[] lower = null;
        byte[] upper = null;
        boolean isUpperInclusive = false;
        while (!prefixes.isEmpty()) {
            Interval prefix = prefixes.poll();
            if (lower == null && upper == null) {
                lower = prefix.getLower();
                upper = prefix.getUpper();
                isUpperInclusive = prefix.isUpperInclusive();
                continue;
            }
            if (upper == Interval.UNBOUND || Bytes.compareTo(prefix.getLower(), upper) <= 0) {
                if (upper == Interval.UNBOUND || !prefix.isUpperUnbound() && Bytes.compareTo(upper, prefix.getUpper()) > 0) continue;
                upper = prefix.getUpper();
                isUpperInclusive = prefix.isUpperInclusive();
                continue;
            }
            intervals.add(Interval.create(lower, true, upper, isUpperInclusive));
            lower = prefix.getLower();
            upper = prefix.getUpper();
            isUpperInclusive = prefix.isUpperInclusive();
        }
        if (lower != null && upper != null) {
            intervals.add(Interval.create(lower, true, upper, isUpperInclusive));
        }
        return intervals;
    }

    private List<IntervalQuery> generateIntervalQueries(List<PrefixQuery> prefixQueries) {
        List<IntervalQuery> intervalQueries = null;
        for (PrefixQuery prefixQuery : prefixQueries) {
            intervalQueries = this.updateIntervalQueries(intervalQueries, prefixQuery);
        }
        return intervalQueries;
    }

    private List<IntervalQuery> updateIntervalQueries(List<IntervalQuery> intervalQueries, PrefixQuery prefixQuery) {
        ArrayList<IntervalQuery> newIntervalQueries = new ArrayList<IntervalQuery>();
        List<Interval> prefixes = prefixQuery.getPrefixes();
        QueryFilterInfo filterInfo = prefixQuery.getFilterInfo();
        if (intervalQueries == null) {
            for (Interval prefix : prefixes) {
                newIntervalQueries.add(new IntervalQuery(prefix, filterInfo));
            }
            return newIntervalQueries;
        }
        int i = 0;
        int j = 0;
        IntervalQuery query = null;
        Interval pInterval = null;
        Interval qInterval = null;
        byte[] pLower = null;
        byte[] qLower = null;
        while (i < intervalQueries.size() || j < prefixes.size()) {
            int upperCompare;
            if (i >= intervalQueries.size()) {
                this.addTo(newIntervalQueries, qLower, qInterval.getUpper(), qInterval.isUpperInclusive(), filterInfo);
                while (++j < prefixes.size()) {
                    newIntervalQueries.add(new IntervalQuery(prefixes.get(j), filterInfo));
                }
                break;
            }
            if (j >= prefixes.size()) {
                this.addTo(newIntervalQueries, pLower, pInterval.getUpper(), pInterval.isUpperInclusive(), query.getFilters());
                while (++i < intervalQueries.size()) {
                    newIntervalQueries.add(intervalQueries.get(i));
                }
                break;
            }
            query = intervalQueries.get(i);
            pInterval = query.getInterval();
            if (pLower == null) {
                pLower = pInterval.getLower();
            }
            qInterval = prefixes.get(j);
            if (qLower == null) {
                qLower = qInterval.getLower();
            }
            if (this.isIntervalOnTheLeft(pInterval, qLower)) {
                this.addTo(newIntervalQueries, pLower, pInterval.getUpper(), pInterval.isUpperInclusive(), query.getFilters());
                ++i;
                pLower = null;
                continue;
            }
            if (this.isIntervalOnTheLeft(qInterval, pLower)) {
                this.addTo(newIntervalQueries, qLower, qInterval.getUpper(), qInterval.isUpperInclusive(), filterInfo);
                ++j;
                qLower = null;
                continue;
            }
            int lowerCompare = Bytes.compareTo(pLower, qLower);
            if (lowerCompare <= 0) {
                if (lowerCompare != 0) {
                    this.addTo(newIntervalQueries, pLower, qLower, false, query.getFilters());
                }
                if ((upperCompare = this.compareUpper(pInterval, qInterval)) <= 0) {
                    this.addTo(newIntervalQueries, qLower, pInterval.getUpper(), pInterval.isUpperInclusive(), this.unionFilters(query.getFilters(), filterInfo));
                    if (upperCompare == 0) {
                        ++j;
                        qLower = null;
                    } else {
                        qLower = !pInterval.isUpperInclusive() ? pInterval.getUpper() : this.getNextValueByPaddingZeroByte(pInterval.getUpper());
                    }
                    ++i;
                    pLower = null;
                    continue;
                }
                this.addTo(newIntervalQueries, qLower, qInterval.getUpper(), qInterval.isUpperInclusive(), this.unionFilters(query.getFilters(), filterInfo));
                pLower = !qInterval.isUpperInclusive() ? qInterval.getUpper() : this.getNextValueByPaddingZeroByte(qInterval.getUpper());
                ++j;
                qLower = null;
                continue;
            }
            this.addTo(newIntervalQueries, qLower, pLower, false, filterInfo);
            upperCompare = this.compareUpper(qInterval, pInterval);
            if (upperCompare <= 0) {
                this.addTo(newIntervalQueries, pLower, qInterval.getUpper(), qInterval.isUpperInclusive(), this.unionFilters(query.getFilters(), filterInfo));
                if (upperCompare == 0) {
                    ++i;
                    pLower = null;
                } else {
                    pLower = !qInterval.isUpperInclusive() ? qInterval.getUpper() : this.getNextValueByPaddingZeroByte(qInterval.getUpper());
                }
                ++j;
                qLower = null;
                continue;
            }
            this.addTo(newIntervalQueries, pLower, pInterval.getUpper(), pInterval.isUpperInclusive(), this.unionFilters(query.getFilters(), filterInfo));
            qLower = !pInterval.isUpperInclusive() ? pInterval.getUpper() : this.getNextValueByPaddingZeroByte(pInterval.getUpper());
            ++i;
            pLower = null;
        }
        return newIntervalQueries;
    }

    private void addTo(List<IntervalQuery> intervalQueries, byte[] lower, byte[] upper, boolean upperInclusive, QueryFilterInfo filterInfo) {
        Interval interval = Interval.create(lower, true, upper, upperInclusive);
        if (!interval.equals(Interval.EMPTY_RANGE)) {
            intervalQueries.add(new IntervalQuery(interval, filterInfo));
        }
    }

    private void addTo(List<IntervalQuery> intervalQueries, byte[] lower, byte[] upper, boolean upperInclusive, List<QueryFilterInfo> filters) {
        Interval interval = Interval.create(lower, true, upper, upperInclusive);
        if (!interval.equals(Interval.EMPTY_RANGE)) {
            intervalQueries.add(new IntervalQuery(interval, filters));
        }
    }

    private boolean isIntervalOnTheLeft(Interval interval, byte[] lower) {
        if (interval.isUpperUnbound() || lower == Interval.UNBOUND) {
            return false;
        }
        int compare = Bytes.compareTo(interval.getUpper(), lower);
        return compare < 0 || compare == 0 && !interval.isUpperInclusive();
    }

    private int compareUpper(Interval interval, Interval otherInterval) {
        if (interval.isUpperUnbound()) {
            return otherInterval.isUpperUnbound() ? 0 : 1;
        }
        if (otherInterval.isUpperUnbound()) {
            return -1;
        }
        int compare = Bytes.compareTo(interval.getUpper(), otherInterval.getUpper());
        if (compare != 0) {
            return compare;
        }
        if (interval.isUpperInclusive() == otherInterval.isUpperInclusive()) {
            return 0;
        }
        return interval.isUpperInclusive() ? 1 : -1;
    }

    private List<QueryFilterInfo> unionFilters(List<QueryFilterInfo> filters, QueryFilterInfo filterInfo) {
        if (filters == null || filterInfo == null || filterInfo.getColumnSlots() == null) {
            return null;
        }
        ArrayList<QueryFilterInfo> newFilters = new ArrayList<QueryFilterInfo>(filters.size() + 1);
        newFilters.addAll(filters);
        newFilters.add(filterInfo);
        return newFilters;
    }

    private byte[] getNextValueByPaddingZeroByte(byte[] value) {
        byte[] nextValue = new byte[value.length + 1];
        System.arraycopy(value, 0, nextValue, 0, value.length);
        nextValue[nextValue.length - 1] = 0;
        return nextValue;
    }
}

