/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc.locator;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.ipc.LDServerList;
import com.alibaba.lindorm.client.core.ipc.LDServerLocator;
import com.alibaba.lindorm.client.core.ipc.locator.IDCSorter;
import com.alibaba.lindorm.client.core.ipc.locator.PingDelayMeasurer;
import com.alibaba.lindorm.client.core.metrics.MostRecentlySample;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IDCPingSorter
extends IDCSorter {
    private static final Log LOG = LogFactory.getLog((String)IDCPingSorter.class.getName());
    ConcurrentHashMap<String, MostRecentlySample> pingSamples = new ConcurrentHashMap();
    ConcurrentHashMap<String, Long> pingDelays = new ConcurrentHashMap();
    ConcurrentHashMap<String, Integer> pingFailures = new ConcurrentHashMap();
    PingUpdater updater;
    PingDelayMeasurer measurer;
    private List<String> availableIDCList = null;
    private List<String> nearbyIDCList = null;
    private int windowSize;
    private int pingLimit;
    private int updaterPause;
    private int nearbyPingDelay;
    private LDServerList serverList;
    private String priorityIdc;

    public IDCPingSorter(LindormClientConfig config, LDServerLocator locator) {
        super(config, locator);
        Class<?> pingDetectorClass = config.getClass("lindorm.ping.delay.measurer.impl", "com.alibaba.lindorm.client.core.ipc.locator.PingDelayMeasurer", LindormClientConstants.LINDORM_PING_MEASURER_CLASS_DEFAULT);
        try {
            Constructor<?> meth = pingDetectorClass.getDeclaredConstructor(LindormClientConfig.class);
            meth.setAccessible(true);
            this.measurer = (PingDelayMeasurer)meth.newInstance(config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.onConfigChange(config);
        this.updater = new PingUpdater();
        this.updater.setDaemon(true);
        this.updater.start();
    }

    @Override
    public void onConfigChange(LindormClientConfig config) {
        super.onConfigChange(config);
        this.updaterPause = config.getInt("lindorm.rpc.idc.detect.interval", 10000);
        this.pingLimit = config.getInt("lindorm.rpc.idc.ping.number.limit", 3);
        this.windowSize = config.getInt("lindorm.rpc.idc.ping.window", 50);
        this.nearbyPingDelay = config.getInt("lindorm.rpc.idc.nearby.max.ping.delay", 100);
        this.measurer.onConfigChange(config);
    }

    @Override
    public void sortIDCs(LDServerList serverList, String priorityIDC) {
        this.serverList = serverList;
        this.priorityIdc = priorityIDC;
        List<String> idcList = serverList.getAllIDCNames();
        ArrayList<String> nearbyIdcList = new ArrayList<String>();
        for (String idc : idcList) {
            if (!this.pingDelays.containsKey(idc)) {
                this.updateScoreForIdc(idc);
            }
            if (this.pingDelays.get(idc) >= TimeUnit.MILLISECONDS.toNanos(this.nearbyPingDelay)) continue;
            nearbyIdcList.add(idc);
        }
        Collections.sort(idcList, new Comparator<String>(){

            @Override
            public int compare(String idc1, String idc2) {
                return IDCPingSorter.this.compareEndpoints(idc1, idc2);
            }
        });
        Iterator<String> it = idcList.iterator();
        while (it.hasNext()) {
            String idc;
            idc = it.next();
            if (this.pingDelays.get(idc) != null && this.pingDelays.get(idc) != Long.MAX_VALUE) continue;
            it.remove();
        }
        if (this.availableIDCList != null) {
            if (!this.availableIDCList.equals(idcList)) {
                LOG.warn((Object)("Sorted available idc list changed, old list " + this.availableIDCList + ", current " + idcList));
            }
        } else {
            LOG.warn((Object)("Init sorted available idc list" + idcList));
        }
        this.availableIDCList = idcList;
        this.nearbyIDCList = !nearbyIdcList.isEmpty() ? nearbyIdcList : idcList;
    }

    @Override
    public List<String> getAvailableIDCList() {
        return this.availableIDCList;
    }

    @Override
    public List<String> getNearbySortedIDCList() {
        return this.nearbyIDCList;
    }

    @Override
    public void triggerDetection() {
        this.updater.triggerNow();
    }

    @Override
    public String getSorterType() {
        return "PINGSORTER";
    }

    @Override
    public void close() {
        this.updater.close();
    }

    public int compareEndpoints(String idc1, String idc2) {
        if (idc1.equals(this.priorityIdc)) {
            return -1;
        }
        if (idc2.equals(this.priorityIdc)) {
            return 1;
        }
        Long delayIdc1 = this.pingDelays.get(idc1);
        Long delayIdc2 = this.pingDelays.get(idc2);
        if (delayIdc1 == null) {
            return 1;
        }
        if (delayIdc2 == null) {
            return -1;
        }
        return delayIdc1.compareTo(delayIdc2);
    }

    private void updatePingDelayForIDC(String idc, List<LDServerAddress> servers) {
        if (servers == null || servers.size() == 0) {
            Integer failures = this.pingFailures.get(idc);
            failures = failures + 1;
            this.pingFailures.put(idc, failures);
            return;
        }
        Collections.shuffle(servers);
        int limit = Math.min(this.pingLimit, servers.size());
        for (int i = 0; i < limit; ++i) {
            LDServerAddress server = servers.get(i);
            try {
                long delay = this.measurer.getPingDelay(server);
                MostRecentlySample sample = this.pingSamples.get(idc);
                sample.update(delay);
                this.pingFailures.put(idc, 0);
                return;
            }
            catch (Throwable t) {
                LOG.info((Object)("Failed to get ping delay for server " + server), t);
                continue;
            }
        }
        Integer failures = this.pingFailures.get(idc);
        failures = failures + 1;
        this.pingFailures.put(idc, failures);
        if (failures == 2) {
            LOG.warn((Object)("Find unavailble idc, possibly a network partition: " + idc));
        }
    }

    private synchronized void updateScore() {
        List<String> idcs = this.locator.getAllIDC();
        for (String idc : idcs) {
            this.updateScoreForIdc(idc);
        }
    }

    private synchronized void updateScoreForIdc(String idc) {
        if (!this.pingDelays.containsKey(idc)) {
            this.pingFailures.put(idc, 0);
            this.pingSamples.put(idc, new MostRecentlySample(this.windowSize));
        }
        this.updatePingDelayForIDC(idc, this.locator.getServersOfIDC(idc));
        MostRecentlySample sample = this.pingSamples.get(idc);
        Integer failures = this.pingFailures.get(idc);
        double median = sample.getSnapshot().getMedian();
        if (median == 0.0 || failures >= 2) {
            this.pingDelays.put(idc, Long.MAX_VALUE);
        } else {
            this.pingDelays.put(idc, (long)median);
        }
    }

    public class PingUpdater
    extends Thread {
        private volatile boolean isStopped = false;
        private final Object sleepLock = new Object();

        public PingUpdater() {
            this.setName("PingDelayUpdater");
        }

        public void close() {
            this.isStopped = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isStopped) {
                Object object = this.sleepLock;
                synchronized (object) {
                    try {
                        this.sleepLock.wait(IDCPingSorter.this.updaterPause);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                IDCPingSorter.this.updateScore();
                IDCPingSorter.this.sortIDCs(IDCPingSorter.this.serverList, IDCPingSorter.this.priorityIdc);
            }
            LOG.info((Object)(this.getName() + " exits"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void triggerNow() {
            Object object = this.sleepLock;
            synchronized (object) {
                this.sleepLock.notifyAll();
            }
        }
    }
}

