/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.sql.client;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.DriverVersion;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.Driver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LindormThinDriver
extends Driver {
    public static final Log LOG = LogFactory.getLog(LindormThinDriver.class);
    public static final String CONNECT_STRING_PREFIX = "jdbc:lindorm:thin:";
    private static final String DEFAULT_SERIALIZATION = "PROTOBUF";

    protected static Properties getProperties(String user, String password) {
        Properties properties = new Properties();
        properties.put("user", user);
        properties.put("password", password);
        return properties;
    }

    public static String getConnectionUrl(String hostname, int port) {
        return LindormThinDriver.getConnectionUrl("http", hostname, port);
    }

    private static String getConnectionUrl(String protocol, String hostname, int port) {
        return LindormThinDriver.getConnectionUrl(protocol, hostname, port, DEFAULT_SERIALIZATION);
    }

    private static String getConnectionUrl(String protocol, String hostname, int port, String serialization) {
        String urlFmt = "jdbc:lindorm:thin:url=%s://%s:%s;serialization=%s";
        return String.format(urlFmt, protocol, hostname, port, serialization);
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "com-alibaba-lindorm-remote-jdbc.properties", "Lindorm Remote JDBC Driver", "unknown version", "Alibaba Lindorm", "unknown version");
    }

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        try {
            return super.connect(url, info);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        LOG.info((Object)"register lindorm thin driver");
        new LindormThinDriver().register();
    }
}

