/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.esri.core.geometry;

import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.EditShape;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Envelope1D;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Line;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.NonSimpleResult;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.NumberUtils;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Point2D;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Segment;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Treap;
import java.util.ArrayList;

class SweepComparator
extends Treap.Comparator {
    private EditShape m_shape;
    boolean m_b_intersection_detected;
    NonSimpleResult m_non_simple_result;
    SimpleEdge m_temp_simple_edge_1;
    SimpleEdge m_temp_simple_edge_2;
    int m_prev_1;
    int m_prev_2;
    int m_vertex_1;
    int m_vertex_2;
    int m_current_node;
    double m_prevx_1;
    double m_prevx_2;
    double m_prev_y;
    double m_prev_x;
    double m_sweep_y;
    double m_sweep_x;
    double m_tolerance;
    double m_tolerance_10;
    boolean m_b_is_simple;
    ArrayList<SimpleEdge> m_simple_edges_cache;
    ArrayList<SimpleEdge> m_simple_edges_recycle;
    ArrayList<SimpleEdge> m_simple_edges_buffer;

    SimpleEdge tryGetCachedEdge_(int value) {
        SimpleEdge se = this.m_simple_edges_cache.get((value & NumberUtils.intMax()) % this.m_simple_edges_cache.size());
        if (se != null && se.m_value == value) {
            return se;
        }
        return null;
    }

    void tryDeleteCachedEdge_(int value) {
        int ind = (value & NumberUtils.intMax()) % this.m_simple_edges_cache.size();
        SimpleEdge se = this.m_simple_edges_cache.get(ind);
        if (se != null && se.m_value == value) {
            this.m_simple_edges_recycle.add(se);
            this.m_simple_edges_cache.set(ind, null);
        }
    }

    SimpleEdge tryCreateCachedEdge_(int value) {
        int ind = (value & NumberUtils.intMax()) % this.m_simple_edges_cache.size();
        SimpleEdge se = this.m_simple_edges_cache.get(ind);
        if (se == null) {
            if (this.m_simple_edges_recycle.isEmpty()) {
                this.m_simple_edges_buffer.add(new SimpleEdge());
                se = this.m_simple_edges_buffer.get(this.m_simple_edges_buffer.size() - 1);
            } else {
                se = this.m_simple_edges_recycle.get(this.m_simple_edges_recycle.size() - 1);
                this.m_simple_edges_recycle.remove(this.m_simple_edges_recycle.size() - 1);
            }
            se.m_value = value;
            this.m_simple_edges_cache.set(ind, se);
            return se;
        }
        assert (se.m_value != value);
        return null;
    }

    void initSimpleEdge_(SimpleEdge se, int vertex) {
        se.m_segment = this.m_shape.getSegment(vertex);
        boolean bl = se.m_b_curve = se.m_segment != null;
        if (!se.m_b_curve) {
            this.m_shape.queryLineConnector(vertex, se.m_line);
            se.m_segment = se.m_line;
            se.m_env.setCoordsNoNaN_(se.m_line.getStartX(), se.m_line.getEndX());
            se.m_env.vmax += this.m_tolerance;
            se.m_line.orientBottomUp_();
            boolean bl2 = se.m_b_horizontal = se.m_line.getEndY() == se.m_line.getStartY();
            if (!se.m_b_horizontal) {
                se.m_dxdy = (se.m_line.getEndX() - se.m_line.getStartX()) / (se.m_line.getEndY() - se.m_line.getStartY());
            }
        }
    }

    int compareTwoSegments_(Segment seg_1, Segment seg_2) {
        int res = seg_1._isIntersecting(seg_2, this.m_tolerance, true);
        if (res != 0) {
            if (res == 2) {
                return this.errorCoincident();
            }
            return this.errorCracking();
        }
        Point2D start_1 = seg_1.getStartXY();
        Point2D end1 = seg_1.getEndXY();
        Point2D start2 = seg_2.getStartXY();
        Point2D end2 = seg_2.getEndXY();
        Point2D ptSweep = new Point2D();
        ptSweep.setCoords(this.m_sweep_x, this.m_sweep_y);
        if (start_1.isEqual(start2) && this.m_sweep_y == start_1.y) {
            assert (start_1.compare(end1) < 0 && start2.compare(end2) < 0);
            if (end1.compare(end2) < 0) {
                ptSweep.setCoords(end1);
            } else {
                ptSweep.setCoords(end2);
            }
        } else if (start_1.isEqual(end2) && this.m_sweep_y == start_1.y) {
            assert (start_1.compare(end1) < 0 && start2.compare(end2) > 0);
            if (end1.compare(start2) < 0) {
                ptSweep.setCoords(end1);
            } else {
                ptSweep.setCoords(start2);
            }
        } else if (start2.isEqual(end1) && this.m_sweep_y == start2.y) {
            assert (end1.compare(start_1) < 0 && start2.compare(end2) < 0);
            if (start_1.compare(end2) < 0) {
                ptSweep.setCoords(start_1);
            } else {
                ptSweep.setCoords(end2);
            }
        } else if (end1.isEqual(end2) && this.m_sweep_y == end1.y) {
            assert (start_1.compare(end1) > 0 && start2.compare(end2) > 0);
            if (start_1.compare(start2) < 0) {
                ptSweep.setCoords(start_1);
            } else {
                ptSweep.setCoords(start2);
            }
        }
        double xleft = seg_1.intersectionOfYMonotonicWithAxisX(ptSweep.y, ptSweep.x);
        double xright = seg_2.intersectionOfYMonotonicWithAxisX(ptSweep.y, ptSweep.x);
        assert (xleft != xright);
        return xleft < xright ? -1 : 1;
    }

    int compareNonHorizontal_(SimpleEdge line_1, SimpleEdge line_2) {
        if (line_1.m_line.getStartY() == line_2.m_line.getStartY() && line_1.m_line.getStartX() == line_2.m_line.getStartX()) {
            if (line_1.m_line.getEndY() == line_2.m_line.getEndY() && line_1.m_line.getEndX() == line_2.m_line.getEndX()) {
                if (this.m_b_is_simple) {
                    return this.errorCoincident();
                }
                return 0;
            }
            return this.compareNonHorizontalUpperEnd_(line_1, line_2);
        }
        if (line_1.m_line.getEndY() == line_2.m_line.getEndY() && line_1.m_line.getEndX() == line_2.m_line.getEndX()) {
            return this.compareNonHorizontalLowerEnd_(line_1, line_2);
        }
        int lower = this.compareNonHorizontalLowerEnd_(line_1, line_2);
        int upper = this.compareNonHorizontalUpperEnd_(line_1, line_2);
        if (lower < 0 && upper < 0) {
            return -1;
        }
        if (lower > 0 && upper > 0) {
            return 1;
        }
        return this.errorCracking();
    }

    int compareHorizontal1Case1_(Line line_1, Line line_2) {
        if (line_1.getEndX() > line_2.getEndX()) {
            if (line_2.getEndX() > line_2.getStartX() && line_2.getEndY() - line_2.getStartY() < 2.0 * this.m_tolerance && line_1._isIntersectingPoint(line_2.getEndXY(), this.m_tolerance, true)) {
                return this.errorCracking();
            }
        } else {
            assert (line_2.getEndX() - line_2.getStartX() != 0.0);
            double dydx = (line_2.getEndY() - line_2.getStartY()) / (line_2.getEndX() - line_2.getStartX());
            double d = dydx * (line_1.getEndX() - line_1.getStartX());
            if (d < this.m_tolerance_10 && line_2._isIntersectingPoint(line_1.getEndXY(), this.m_tolerance, true)) {
                return this.errorCracking();
            }
        }
        return 1;
    }

    int compareHorizontal1Case2_(Line line_1, Line line_2) {
        double dydx;
        double d;
        if (line_1.getStartX() < line_2.getStartX() ? line_2.getEndX() > line_2.getStartX() && line_2.getEndY() - line_2.getStartY() < 2.0 * this.m_tolerance && line_1._isIntersectingPoint(line_2.getEndXY(), this.m_tolerance, true) : (d = (dydx = (line_2.getEndY() - line_2.getStartY()) / (line_2.getEndX() - line_2.getStartX())) * (line_1.getStartX() - line_1.getEndX())) < this.m_tolerance_10 && line_2._isIntersectingPoint(line_1.getStartXY(), this.m_tolerance, true)) {
            return this.errorCracking();
        }
        return -1;
    }

    int compareHorizontal1Case3_(Line line_1, Line line_2) {
        Point2D v0 = new Point2D();
        v0.sub(line_2.getEndXY(), line_2.getStartXY());
        v0.rightPerpendicular();
        v0.normalize();
        Point2D v_1 = new Point2D();
        v_1.sub(line_1.getStartXY(), line_2.getStartXY());
        Point2D v_2 = new Point2D();
        v_2.sub(line_1.getEndXY(), line_2.getStartXY());
        double d_1 = v_1.dotProduct(v0);
        double d_2 = v_2.dotProduct(v0);
        double ad1 = Math.abs(d_1);
        double ad2 = Math.abs(d_2);
        if (ad1 < ad2 ? ad1 < this.m_tolerance_10 && line_2._isIntersectingPoint(line_1.getStartXY(), this.m_tolerance, true) : ad2 < this.m_tolerance_10 && line_2._isIntersectingPoint(line_1.getEndXY(), this.m_tolerance, true)) {
            return this.errorCracking();
        }
        if (d_1 < 0.0 && d_2 < 0.0) {
            return -1;
        }
        if (d_1 > 0.0 && d_2 > 0.0) {
            return 1;
        }
        return this.errorCracking();
    }

    int compareHorizontal1_(Line line_1, Line line_2) {
        if (line_1.getStartY() == line_2.getStartY() && line_1.getStartX() == line_2.getStartX()) {
            return this.compareHorizontal1Case1_(line_1, line_2);
        }
        if (line_1.getEndY() == line_2.getEndY() && line_1.getEndX() == line_2.getEndX()) {
            return this.compareHorizontal1Case2_(line_1, line_2);
        }
        return this.compareHorizontal1Case3_(line_1, line_2);
    }

    int compareHorizontal2_(Line line_1, Line line_2) {
        if (line_1.getEndY() == line_2.getEndY() && line_1.getEndX() == line_2.getEndX() && line_1.getStartY() == line_2.getStartY() && line_1.getStartX() == line_2.getStartX()) {
            if (this.m_b_is_simple) {
                return this.errorCoincident();
            }
            return 0;
        }
        return this.errorCracking();
    }

    int compareNonHorizontalLowerEnd_(SimpleEdge line_1, SimpleEdge line_2) {
        double tol;
        double x2;
        int sign = 1;
        if (line_1.m_line.getStartY() < line_2.m_line.getStartY()) {
            sign = -1;
            SimpleEdge tmp = line_1;
            line_1 = line_2;
            line_2 = tmp;
        }
        Line l1 = line_1.m_line;
        Line l2 = line_2.m_line;
        double x_1 = l1.getStartX() - l2.getStartX();
        if (x_1 < (x2 = line_2.m_dxdy * (l1.getStartY() - l2.getStartY())) - (tol = this.m_tolerance_10)) {
            return -sign;
        }
        if (x_1 > x2 + tol) {
            return sign;
        }
        if (l2._isIntersectingPoint(l1.getStartXY(), this.m_tolerance, true)) {
            return this.errorCracking();
        }
        return x_1 < x2 ? -sign : sign;
    }

    int compareNonHorizontalUpperEnd_(SimpleEdge line_1, SimpleEdge line_2) {
        double tol;
        double x2;
        int sign = 1;
        if (line_2.m_line.getEndY() < line_1.m_line.getEndY()) {
            sign = -1;
            SimpleEdge tmp = line_1;
            line_1 = line_2;
            line_2 = tmp;
        }
        Line l1 = line_1.m_line;
        Line l2 = line_2.m_line;
        double x_1 = l1.getEndX() - l2.getStartX();
        if (x_1 < (x2 = line_2.m_dxdy * (l1.getEndY() - l2.getStartY())) - (tol = this.m_tolerance_10)) {
            return -sign;
        }
        if (x_1 > x2 + tol) {
            return sign;
        }
        if (l2._isIntersectingPoint(l1.getEndXY(), this.m_tolerance, true)) {
            return this.errorCracking();
        }
        return x_1 < x2 ? -sign : sign;
    }

    int errorCoincident() {
        this.m_b_intersection_detected = true;
        assert (this.m_b_is_simple);
        NonSimpleResult.Reason reason = NonSimpleResult.Reason.CrossOver;
        this.m_non_simple_result = new NonSimpleResult(reason, this.m_vertex_1, this.m_vertex_2);
        return -1;
    }

    int errorCracking() {
        this.m_b_intersection_detected = true;
        if (this.m_b_is_simple) {
            NonSimpleResult.Reason reason = NonSimpleResult.Reason.Cracking;
            this.m_non_simple_result = new NonSimpleResult(reason, this.m_vertex_1, this.m_vertex_2);
        } else {
            this.m_prev_1 = -1;
            this.m_prev_2 = -1;
            this.m_vertex_1 = -1;
            this.m_vertex_2 = -1;
        }
        return -1;
    }

    int compareSegments_(int left, int right, SimpleEdge segLeft, SimpleEdge segRight) {
        double x;
        double xright;
        double xleft;
        boolean sameY;
        if (this.m_b_intersection_detected) {
            return -1;
        }
        boolean bl = sameY = this.m_prev_y == this.m_sweep_y && this.m_prev_x == this.m_sweep_x;
        if (sameY && left == this.m_prev_1) {
            xleft = this.m_prevx_1;
        } else {
            xleft = NumberUtils.NaN();
            this.m_prev_1 = -1;
        }
        if (sameY && right == this.m_prev_2) {
            xright = this.m_prevx_2;
        } else {
            xright = NumberUtils.NaN();
            this.m_prev_2 = -1;
        }
        Envelope1D envLeft = segLeft.m_segment.queryInterval(0, 0);
        Envelope1D envRight = segRight.m_segment.queryInterval(0, 0);
        if (envLeft.vmax < envRight.vmin) {
            return -1;
        }
        if (envRight.vmax < envLeft.vmin) {
            return 1;
        }
        this.m_prev_y = this.m_sweep_y;
        this.m_prev_x = this.m_sweep_x;
        if (NumberUtils.isNaN(xleft)) {
            this.m_prev_1 = left;
            xleft = x = segLeft.m_segment.intersectionOfYMonotonicWithAxisX(this.m_sweep_y, this.m_sweep_x);
            this.m_prevx_1 = x;
        }
        if (NumberUtils.isNaN(xright)) {
            this.m_prev_2 = right;
            xright = x = segRight.m_segment.intersectionOfYMonotonicWithAxisX(this.m_sweep_y, this.m_sweep_x);
            this.m_prevx_2 = x;
        }
        if (Math.abs(xleft - xright) <= this.m_tolerance) {
            return this.compareTwoSegments_(segLeft.m_segment, segRight.m_segment);
        }
        return xleft < xright ? -1 : (xleft > xright ? 1 : 0);
    }

    SweepComparator(EditShape shape, double tol, boolean bIsSimple) {
        super(true);
        this.m_shape = shape;
        this.m_sweep_y = Double.NaN;
        this.m_sweep_x = 0.0;
        this.m_prev_x = 0.0;
        this.m_prev_y = Double.NaN;
        this.m_tolerance = tol;
        this.m_tolerance_10 = 10.0 * tol;
        this.m_prevx_2 = Double.NaN;
        this.m_prevx_1 = Double.NaN;
        this.m_b_intersection_detected = false;
        this.m_prev_1 = -1;
        this.m_prev_2 = -1;
        this.m_vertex_1 = -1;
        this.m_vertex_2 = -1;
        this.m_current_node = -1;
        this.m_b_is_simple = bIsSimple;
        this.m_temp_simple_edge_1 = new SimpleEdge();
        this.m_temp_simple_edge_2 = new SimpleEdge();
        int s = Math.min(shape.getTotalPointCount() * 3 / 2, 67);
        int cache_size = Math.min(7, s);
        this.m_simple_edges_buffer = new ArrayList();
        this.m_simple_edges_recycle = new ArrayList();
        this.m_simple_edges_cache = new ArrayList();
        for (int i = 0; i < cache_size; ++i) {
            this.m_simple_edges_cache.add(null);
        }
    }

    void clearIntersectionDetectedFlag() {
        this.m_b_intersection_detected = false;
    }

    boolean intersectionDetected() {
        return this.m_b_intersection_detected;
    }

    int getLastComparedNode() {
        return this.m_current_node;
    }

    NonSimpleResult getResult() {
        return this.m_non_simple_result;
    }

    void setSweepY(double y, double x) {
        this.m_sweep_y = y;
        this.m_sweep_x = x;
        this.m_prev_1 = -1;
        this.m_prev_2 = -1;
        this.m_vertex_1 = -1;
        this.m_vertex_2 = -1;
    }

    @Override
    int compare(Treap treap, int left, int node) {
        if (this.m_b_intersection_detected) {
            return -1;
        }
        int right = treap.getElement(node);
        this.m_current_node = node;
        return this.compareSegments(left, left, right, right);
    }

    int compareSegments(int leftElm, int left_vertex, int right_elm, int right_vertex) {
        SimpleEdge edgeLeft = this.tryGetCachedEdge_(leftElm);
        if (edgeLeft == null) {
            if (this.m_vertex_1 == left_vertex) {
                edgeLeft = this.m_temp_simple_edge_1;
            } else {
                this.m_vertex_1 = left_vertex;
                edgeLeft = this.tryCreateCachedEdge_(leftElm);
                if (edgeLeft == null) {
                    edgeLeft = this.m_temp_simple_edge_1;
                    this.m_temp_simple_edge_1.m_value = leftElm;
                }
                this.initSimpleEdge_(edgeLeft, left_vertex);
            }
        } else {
            this.m_vertex_1 = left_vertex;
        }
        SimpleEdge edgeRight = this.tryGetCachedEdge_(right_elm);
        if (edgeRight == null) {
            if (this.m_vertex_2 == right_vertex) {
                edgeRight = this.m_temp_simple_edge_2;
            } else {
                this.m_vertex_2 = right_vertex;
                edgeRight = this.tryCreateCachedEdge_(right_elm);
                if (edgeRight == null) {
                    edgeRight = this.m_temp_simple_edge_2;
                    this.m_temp_simple_edge_2.m_value = right_elm;
                }
                this.initSimpleEdge_(edgeRight, right_vertex);
            }
        } else {
            this.m_vertex_2 = right_vertex;
        }
        if (edgeLeft.m_b_curve || edgeRight.m_b_curve) {
            return this.compareSegments_(left_vertex, right_vertex, edgeLeft, edgeRight);
        }
        if (edgeLeft.m_env.vmax < edgeRight.m_env.vmin) {
            return -1;
        }
        if (edgeRight.m_env.vmax < edgeLeft.m_env.vmin) {
            return 1;
        }
        int kind = edgeLeft.m_b_horizontal ? 1 : 0;
        if ((kind |= edgeRight.m_b_horizontal ? 2 : 0) == 0) {
            return this.compareNonHorizontal_(edgeLeft, edgeRight);
        }
        if (kind == 1) {
            return this.compareHorizontal1_(edgeLeft.m_line, edgeRight.m_line);
        }
        if (kind == 2) {
            return this.compareHorizontal1_(edgeRight.m_line, edgeLeft.m_line) * -1;
        }
        return this.compareHorizontal2_(edgeLeft.m_line, edgeRight.m_line);
    }

    @Override
    void onDelete(int elm) {
        this.tryDeleteCachedEdge_(elm);
    }

    @Override
    void onSet(int oldelm) {
        this.tryDeleteCachedEdge_(oldelm);
    }

    @Override
    void onEndSearch(int elm) {
        this.tryDeleteCachedEdge_(elm);
    }

    @Override
    void onAddUniqueElementFailed(int elm) {
        this.tryDeleteCachedEdge_(elm);
    }

    static final class SimpleEdge {
        int m_value = -1;
        Line m_line = new Line();
        Segment m_segment;
        Envelope1D m_env = new Envelope1D();
        double m_dxdy = 5.5555555E7;
        boolean m_b_horizontal = false;
        boolean m_b_curve = false;

        SimpleEdge() {
            this.m_env.setCoordsNoNaN_(0.0, 0.0);
        }
    }
}

