/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.esri.core.geometry.ogc;

import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Geometry;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.GeometryEngine;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.MultiPath;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Operator;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorExportToWkb;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.OperatorFactoryLocal;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.Polyline;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.SpatialReference;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.ogc.OGCCurve;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.ogc.OGCGeometry;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.ogc.OGCMultiLineString;
import com.alibaba.lindorm.thirdparty.com.esri.core.geometry.ogc.OGCPoint;
import java.nio.ByteBuffer;

public class OGCLineString
extends OGCCurve {
    MultiPath multiPath = new Polyline();

    public int numPoints() {
        if (this.multiPath.isEmpty()) {
            return 0;
        }
        int d = this.multiPath.isClosedPath(0) ? 1 : 0;
        return this.multiPath.getPointCount() + d;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 4);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(4, this.getEsriGeometry(), null);
    }

    public OGCPoint pointN(int n) {
        int nn = this.multiPath.isClosedPath(0) && n == this.multiPath.getPathSize(0) ? this.multiPath.getPathStart(0) : n + this.multiPath.getPathStart(0);
        return (OGCPoint)OGCGeometry.createFromEsriGeometry(this.multiPath.getPoint(nn), this.esriSR);
    }

    @Override
    public boolean isClosed() {
        return this.multiPath.isClosedPathInXYPlane(0);
    }

    public OGCLineString(MultiPath mp, int pathIndex, SpatialReference sr) {
        if (!mp.isEmpty()) {
            this.multiPath.addPath(mp, pathIndex, true);
        }
        this.esriSR = sr;
    }

    public OGCLineString(MultiPath mp, int pathIndex, SpatialReference sr, boolean reversed) {
        if (!mp.isEmpty()) {
            this.multiPath.addPath(mp, pathIndex, !reversed);
        }
        this.esriSR = sr;
    }

    @Override
    public double length() {
        return this.multiPath.calculateLength2D();
    }

    @Override
    public OGCPoint startPoint() {
        return this.pointN(0);
    }

    @Override
    public OGCPoint endPoint() {
        return this.pointN(this.numPoints() - 1);
    }

    @Override
    public String geometryType() {
        return "LineString";
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.multiPath;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return new OGCMultiLineString((Polyline)this.multiPath, this.esriSR);
    }
}

