/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles;

import com.alibaba.lindorm.thirdparty.com.yahoo.memory.Memory;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.Family;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.SketchesArgumentException;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles.DoublesUpdateImpl;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles.DoublesUtil;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles.PreambleUtil;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.quantiles.Util;
import java.util.Arrays;

final class HeapUpdateDoublesSketch
extends UpdateDoublesSketch {
    static final int MIN_HEAP_DOUBLES_SER_VER = 1;
    private double minValue_;
    private double maxValue_;
    private long n_;
    private int baseBufferCount_;
    private long bitPattern_;
    private double[] combinedBuffer_;

    private HeapUpdateDoublesSketch(int k) {
        super(k);
    }

    static HeapUpdateDoublesSketch newInstance(int k) {
        HeapUpdateDoublesSketch hqs = new HeapUpdateDoublesSketch(k);
        int baseBufAlloc = 2 * Math.min(2, k);
        hqs.n_ = 0L;
        hqs.combinedBuffer_ = new double[baseBufAlloc];
        hqs.baseBufferCount_ = 0;
        hqs.bitPattern_ = 0L;
        hqs.minValue_ = Double.POSITIVE_INFINITY;
        hqs.maxValue_ = Double.NEGATIVE_INFINITY;
        return hqs;
    }

    static HeapUpdateDoublesSketch heapifyInstance(Memory srcMem) {
        long n;
        boolean empty;
        int k;
        int flags;
        int familyID;
        int serVer;
        int preLongs;
        long memCapBytes = srcMem.getCapacity();
        if (memCapBytes < 8L) {
            throw new SketchesArgumentException("Source Memory too small: " + memCapBytes + " < 8");
        }
        if (srcMem.isReadOnly() && !srcMem.isDirect()) {
            preLongs = srcMem.getByte(0L) & 0xFF;
            serVer = srcMem.getByte(1L) & 0xFF;
            familyID = srcMem.getByte(2L) & 0xFF;
            flags = srcMem.getByte(3L) & 0xFF;
            k = srcMem.getShort(4L) & 0xFFFF;
            empty = (flags & 4) > 0;
            n = empty ? 0L : srcMem.getLong(8L);
        } else {
            Object memObj = srcMem.array();
            long memAdd = srcMem.getCumulativeOffset(0L);
            preLongs = PreambleUtil.extractPreLongs(memObj, memAdd);
            serVer = PreambleUtil.extractSerVer(memObj, memAdd);
            familyID = PreambleUtil.extractFamilyID(memObj, memAdd);
            flags = PreambleUtil.extractFlags(memObj, memAdd);
            k = PreambleUtil.extractK(memObj, memAdd);
            empty = (flags & 4) > 0;
            n = empty ? 0L : PreambleUtil.extractN(memObj, memAdd);
        }
        DoublesUtil.checkDoublesSerVer(serVer, 1);
        Util.checkHeapFlags(flags);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer(flags, serVer, preLongs);
        Util.checkFamilyID(familyID);
        HeapUpdateDoublesSketch hds = HeapUpdateDoublesSketch.newInstance(k);
        if (empty) {
            return hds;
        }
        boolean srcIsCompact = serVer == 2 | (flags & 8) > 0;
        HeapUpdateDoublesSketch.checkHeapMemCapacity(k, n, srcIsCompact, serVer, memCapBytes);
        hds.n_ = n;
        int combBufCap = Util.computeCombinedBufferItemCapacity(k, n);
        hds.baseBufferCount_ = Util.computeBaseBufferItems(k, n);
        hds.bitPattern_ = Util.computeBitPattern(k, n);
        hds.srcMemoryToCombinedBuffer(srcMem, serVer, srcIsCompact, combBufCap);
        return hds;
    }

    @Override
    public void update(double dataItem) {
        if (Double.isNaN(dataItem)) {
            return;
        }
        double maxValue = this.getMaxValue();
        double minValue = this.getMinValue();
        if (dataItem > maxValue) {
            this.putMaxValue(dataItem);
        }
        if (dataItem < minValue) {
            this.putMinValue(dataItem);
        }
        int curBBCount = this.baseBufferCount_;
        int newBBCount = curBBCount + 1;
        long newN = this.n_ + 1L;
        int combBufItemCap = this.combinedBuffer_.length;
        if (newBBCount > combBufItemCap) {
            this.growBaseBuffer();
        }
        this.combinedBuffer_[curBBCount] = dataItem;
        if (newBBCount == this.k_ << 1) {
            int spaceNeeded = DoublesUpdateImpl.getRequiredItemCapacity(this.k_, newN);
            if (spaceNeeded > combBufItemCap) {
                this.growCombinedBuffer(combBufItemCap, spaceNeeded);
            }
            DoublesSketchAccessor bbAccessor = DoublesSketchAccessor.wrap(this, true);
            bbAccessor.sort();
            long newBitPattern = DoublesUpdateImpl.inPlacePropagateCarry(0, null, bbAccessor, true, this.k_, DoublesSketchAccessor.wrap(this, true), this.bitPattern_);
            assert (newBitPattern == Util.computeBitPattern(this.k_, newN));
            assert (newBitPattern == this.bitPattern_ + 1L);
            this.bitPattern_ = newBitPattern;
            this.baseBufferCount_ = 0;
        } else {
            this.baseBufferCount_ = newBBCount;
        }
        this.n_ = newN;
    }

    @Override
    public long getN() {
        return this.n_;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public double getMinValue() {
        return this.minValue_;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue_;
    }

    @Override
    public void reset() {
        this.n_ = 0L;
        int combinedBufferItemCapacity = 2 * Math.min(2, this.k_);
        this.combinedBuffer_ = new double[combinedBufferItemCapacity];
        this.baseBufferCount_ = 0;
        this.bitPattern_ = 0L;
        this.minValue_ = Double.POSITIVE_INFINITY;
        this.maxValue_ = Double.NEGATIVE_INFINITY;
    }

    private void srcMemoryToCombinedBuffer(Memory srcMem, int serVer, boolean srcIsCompact, int combBufCap) {
        int preLongs = 2;
        int extra = serVer == 1 ? 3 : 2;
        int preBytes = 2 + extra << 3;
        int bbCnt = this.baseBufferCount_;
        int k = this.getK();
        long n = this.getN();
        double[] combinedBuffer = new double[combBufCap];
        this.putMinValue(srcMem.getDouble(16L));
        this.putMaxValue(srcMem.getDouble(24L));
        if (srcIsCompact) {
            long bitPattern;
            srcMem.getDoubleArray(preBytes, combinedBuffer, 0, bbCnt);
            if (bitPattern != 0L) {
                long memOffset = preBytes + (bbCnt << 3);
                int combBufOffset = 2 * k;
                for (bitPattern = this.bitPattern_; bitPattern != 0L; bitPattern >>>= 1) {
                    if ((bitPattern & 1L) > 0L) {
                        srcMem.getDoubleArray(memOffset, combinedBuffer, combBufOffset, k);
                        memOffset += (long)(k << 3);
                    }
                    combBufOffset += k;
                }
            }
        } else {
            int levels = Util.computeNumLevelsNeeded(k, n);
            int totItems = levels == 0 ? bbCnt : (2 + levels) * k;
            srcMem.getDoubleArray(preBytes, combinedBuffer, 0, totItems);
        }
        this.putCombinedBuffer(combinedBuffer);
    }

    @Override
    int getBaseBufferCount() {
        return this.baseBufferCount_;
    }

    @Override
    int getCombinedBufferItemCapacity() {
        return this.combinedBuffer_.length;
    }

    @Override
    double[] getCombinedBuffer() {
        return this.combinedBuffer_;
    }

    @Override
    long getBitPattern() {
        return this.bitPattern_;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    void putMinValue(double minValue) {
        this.minValue_ = minValue;
    }

    @Override
    void putMaxValue(double maxValue) {
        this.maxValue_ = maxValue;
    }

    @Override
    void putN(long n) {
        this.n_ = n;
    }

    @Override
    void putCombinedBuffer(double[] combinedBuffer) {
        this.combinedBuffer_ = combinedBuffer;
    }

    @Override
    void putBaseBufferCount(int baseBufferCount) {
        this.baseBufferCount_ = baseBufferCount;
    }

    @Override
    void putBitPattern(long bitPattern) {
        this.bitPattern_ = bitPattern;
    }

    @Override
    double[] growCombinedBuffer(int currentSpace, int spaceNeeded) {
        this.combinedBuffer_ = Arrays.copyOf(this.combinedBuffer_, spaceNeeded);
        return this.combinedBuffer_;
    }

    private final void growBaseBuffer() {
        int oldSize = this.combinedBuffer_.length;
        assert (oldSize < 2 * this.k_);
        double[] baseBuffer = this.combinedBuffer_;
        int newSize = 2 * Math.max(Math.min(this.k_, oldSize), 2);
        this.combinedBuffer_ = Arrays.copyOf(baseBuffer, newSize);
    }

    static void checkPreLongsFlagsSerVer(int flags, int serVer, int preLongs) {
        boolean empty = (flags & 4) > 0;
        boolean compact = (flags & 8) > 0;
        int sw = (compact ? 1 : 0) + 2 * (empty ? 1 : 0) + 4 * (serVer & 0xF) + 32 * (preLongs & 0x3F);
        boolean valid = true;
        switch (sw) {
            case 38: 
            case 42: 
            case 46: 
            case 47: 
            case 72: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 164: {
                break;
            }
            default: {
                valid = false;
            }
        }
        if (!valid) {
            throw new SketchesArgumentException("Possible corruption. Inconsistent state: PreambleLongs = " + preLongs + ", empty = " + empty + ", SerVer = " + serVer + ", Compact = " + compact);
        }
    }

    static void checkHeapMemCapacity(int k, long n, boolean compact, int serVer, long memCapBytes) {
        int reqBufBytes;
        int metaPre = Family.QUANTILES.getMaxPreLongs() + (serVer == 1 ? 3 : 2);
        int retainedItems = Util.computeRetainedItems(k, n);
        if (compact) {
            reqBufBytes = metaPre + retainedItems << 3;
        } else {
            int totLevels = Util.computeNumLevelsNeeded(k, n);
            int n2 = reqBufBytes = totLevels == 0 ? metaPre + retainedItems << 3 : metaPre + (2 + totLevels) * k << 3;
        }
        if (memCapBytes < (long)reqBufBytes) {
            throw new SketchesArgumentException("Possible corruption: Memory capacity too small: " + memCapBytes + " < " + reqBufBytes);
        }
    }
}

