/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.yahoo.sketches.tuple;

import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.QuickSelect;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.SketchesArgumentException;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.Util;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.tuple.ArrayOfDoublesUpdatableSketch;

abstract class ArrayOfDoublesQuickSelectSketch
extends ArrayOfDoublesUpdatableSketch {
    static final byte serialVersionUID = 1;
    static final int LG_NOM_ENTRIES_BYTE = 16;
    static final int LG_CUR_CAPACITY_BYTE = 17;
    static final int LG_RESIZE_FACTOR_BYTE = 18;
    static final int SAMPLING_P_FLOAT = 20;
    static final int RETAINED_ENTRIES_INT = 24;
    static final int ENTRIES_START = 32;
    static final int DEFAULT_LG_RESIZE_FACTOR = 3;
    int rebuildThreshold_;
    int lgCurrentCapacity_;

    ArrayOfDoublesQuickSelectSketch(int numValues, long seed) {
        super(numValues, seed);
    }

    abstract void updateValues(int var1, double[] var2);

    abstract void setNotEmpty();

    abstract boolean isInSamplingMode();

    abstract int getResizeFactor();

    abstract int getCurrentCapacity();

    abstract void rebuild(int var1);

    abstract long getKey(int var1);

    abstract void setValues(int var1, double[] var2);

    abstract void incrementCount();

    abstract void setThetaLong(long var1);

    abstract int insertKey(long var1);

    abstract int findOrInsertKey(long var1);

    abstract double[] find(long var1);

    @Override
    public void trim() {
        if (this.getRetainedEntries() > this.getNominalEntries()) {
            this.updateTheta();
            this.rebuild();
        }
    }

    static int getMaxBytes(int nomEntries, int numValues) {
        return 32 + (8 + 8 * numValues) * Util.ceilingPowerOf2(nomEntries) * 2;
    }

    void merge(long key, double[] values) {
        this.setNotEmpty();
        if (key < this.theta_) {
            int index = this.findOrInsertKey(key);
            if (index < 0) {
                this.incrementCount();
                this.setValues(~index, values);
            } else {
                this.updateValues(index, values);
            }
            this.rebuildIfNeeded();
        }
    }

    void rebuildIfNeeded() {
        if (this.getRetainedEntries() < this.rebuildThreshold_) {
            return;
        }
        if (this.getCurrentCapacity() > this.getNominalEntries()) {
            this.updateTheta();
            this.rebuild();
        } else {
            this.rebuild(this.getCurrentCapacity() * this.getResizeFactor());
        }
    }

    void rebuild() {
        this.rebuild(this.getCurrentCapacity());
    }

    void insert(long key, double[] values) {
        int index = this.insertKey(key);
        this.setValues(index, values);
        this.incrementCount();
    }

    void setRebuildThreshold() {
        this.rebuildThreshold_ = this.getCurrentCapacity() > this.getNominalEntries() ? (int)((double)this.getCurrentCapacity() * 0.9375) : (int)((double)this.getCurrentCapacity() * 0.5);
    }

    @Override
    void insertOrIgnore(long key, double[] values) {
        if (values.length != this.getNumValues()) {
            throw new SketchesArgumentException("input array of values must have " + this.getNumValues() + " elements, but has " + values.length);
        }
        this.setNotEmpty();
        if (key == 0L || key >= this.theta_) {
            return;
        }
        int index = this.findOrInsertKey(key);
        if (index < 0) {
            this.incrementCount();
            this.setValues(~index, values);
        } else {
            this.updateValues(index, values);
        }
        this.rebuildIfNeeded();
    }

    void updateTheta() {
        long[] keys = new long[this.getRetainedEntries()];
        int i = 0;
        for (int j = 0; j < this.getCurrentCapacity(); ++j) {
            long key = this.getKey(j);
            if (key == 0L) continue;
            keys[i++] = key;
        }
        this.setThetaLong(QuickSelect.select(keys, 0, this.getRetainedEntries() - 1, this.getNominalEntries()));
    }
}

