/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.com.yahoo.sketches.tuple;

import com.alibaba.lindorm.thirdparty.com.yahoo.memory.Memory;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.hash.MurmurHash3;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.tuple.QuickSelectSketch;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.tuple.SummaryFactory;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.tuple.UpdatableSummary;
import com.alibaba.lindorm.thirdparty.com.yahoo.sketches.tuple.Util;

public class UpdatableSketch<U, S extends UpdatableSummary<U>>
extends QuickSelectSketch<S> {
    UpdatableSketch(int nomEntries, int lgResizeFactor, float samplingProbability, SummaryFactory<S> summaryFactory) {
        super(nomEntries, lgResizeFactor, samplingProbability, summaryFactory);
    }

    UpdatableSketch(Memory mem) {
        super(mem);
    }

    public void update(long key, U value) {
        this.update(new long[]{key}, value);
    }

    public void update(double key, U value) {
        this.update(Util.doubleToLongArray(key), value);
    }

    public void update(String key, U value) {
        this.update(Util.stringToByteArray(key), value);
    }

    public void update(byte[] key, U value) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, 9001L)[0] >>> 1, value);
    }

    public void update(int[] key, U value) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, 9001L)[0] >>> 1, value);
    }

    public void update(long[] key, U value) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, 9001L)[0] >>> 1, value);
    }

    private void insertOrIgnore(long key, U value) {
        this.setNotEmpty();
        if (key >= this.getThetaLong()) {
            return;
        }
        int index = this.findOrInsert(key);
        if (index < 0) {
            ((UpdatableSummary[])this.summaries_)[index ^= 0xFFFFFFFF] = (UpdatableSummary)this.getSummaryFactory().newSummary();
        }
        ((UpdatableSummary[])this.summaries_)[index].update(value);
        this.rebuildIfNeeded();
    }
}

