/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Predicates;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableMap;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.DataContext;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableInterpretable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.BindableConvention;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.BindableRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.InterpretableRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.Node;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.Row;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.Sink;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Enumerable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Enumerator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.ConventionTraitDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTrait;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.convert.ConverterImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.convert.ConverterRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.RelFactories;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.runtime.ArrayBindable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.runtime.Bindable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.tools.RelBuilderFactory;
import java.util.List;

public class EnumerableBindable
extends ConverterImpl
implements BindableRel {
    protected EnumerableBindable(RelOptCluster cluster, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), input);
    }

    @Override
    public EnumerableBindable copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableBindable(this.getCluster(), EnumerableBindable.sole(inputs));
    }

    @Override
    public Class<Object[]> getElementType() {
        return Object[].class;
    }

    @Override
    public Enumerable<Object[]> bind(DataContext dataContext) {
        ImmutableMap<String, Object> map = ImmutableMap.of();
        Bindable bindable = EnumerableInterpretable.toBindable(map, null, (EnumerableRel)this.getInput(), EnumerableRel.Prefer.ARRAY);
        ArrayBindable arrayBindable = EnumerableInterpretable.box(bindable);
        return arrayBindable.bind(dataContext);
    }

    @Override
    public Node implement(final InterpretableRel.InterpreterImplementor implementor) {
        return new Node(){

            @Override
            public void run() throws InterruptedException {
                Sink sink = implementor.relSinks.get(EnumerableBindable.this).get(0);
                Enumerable<Object[]> enumerable = EnumerableBindable.this.bind(implementor.dataContext);
                Enumerator enumerator = enumerable.enumerator();
                while (enumerator.moveNext()) {
                    sink.send(Row.asCopy((Object[])enumerator.current()));
                }
            }
        };
    }

    public static class EnumerableToBindableConverterRule
    extends ConverterRule {
        public static final EnumerableToBindableConverterRule INSTANCE = new EnumerableToBindableConverterRule(RelFactories.LOGICAL_BUILDER);

        public EnumerableToBindableConverterRule(RelBuilderFactory relBuilderFactory) {
            super(EnumerableRel.class, Predicates.alwaysTrue(), EnumerableConvention.INSTANCE, BindableConvention.INSTANCE, relBuilderFactory, "EnumerableToBindableConverterRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            return new EnumerableBindable(rel.getCluster(), rel);
        }
    }
}

