/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.jdbc;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.jdbc.JdbcConvention;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.jdbc.JdbcImplementor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.jdbc.JdbcRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.jdbc.JdbcToEnumerableConverterRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Queryable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expression;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.Convention;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCost;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptPlanner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTrait;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare.Prepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.InvalidRelException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.SingleRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.convert.ConverterRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Aggregate;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.AggregateCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.CorrelationId;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Filter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Intersect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Join;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.JoinRelType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Minus;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Project;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.RelFactories;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Sort;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.TableModify;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Union;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Values;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalAggregate;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalCalc;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalFilter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalIntersect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalJoin;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalMinus;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalProject;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalTableModify;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalUnion;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalValues;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMdUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.rel2sql.SqlImplementor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexInputRef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexMultisetUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexProgram;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.ModifiableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlAggFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableBitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.trace.CalciteTrace;
import com.alibaba.lindorm.thirdparty.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class JdbcRules {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();

    private JdbcRules() {
    }

    public static List<RelOptRule> rules(JdbcConvention out) {
        return ImmutableList.of(new JdbcToEnumerableConverterRule(out, RelFactories.LOGICAL_BUILDER), new JdbcJoinRule(out), new JdbcCalcRule(out), new JdbcProjectRule(out), new JdbcFilterRule(out), new JdbcAggregateRule(out), new JdbcSortRule(out), new JdbcUnionRule(out), new JdbcIntersectRule(out), new JdbcMinusRule(out), new JdbcTableModificationRule(out), new JdbcValuesRule(out), new RelOptRule[0]);
    }

    private static boolean canImplement(SqlAggFunction aggregation, SqlDialect sqlDialect) {
        return sqlDialect.supportsAggregateFunction(aggregation.getKind());
    }

    public static class JdbcValues
    extends Values
    implements JdbcRel {
        JdbcValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traitSet) {
            super(cluster, rowType, tuples, traitSet);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (inputs.isEmpty());
            return new JdbcValues(this.getCluster(), this.rowType, this.tuples, traitSet);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcValuesRule
    extends JdbcConverterRule {
        private JdbcValuesRule(JdbcConvention out) {
            super(LogicalValues.class, (RelTrait)Convention.NONE, out, "JdbcValuesRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalValues values = (LogicalValues)rel;
            return new JdbcValues(values.getCluster(), values.getRowType(), values.getTuples(), values.getTraitSet().replace(this.out));
        }
    }

    public static class JdbcTableModify
    extends TableModify
    implements JdbcRel {
        private final Expression expression;

        public JdbcTableModify(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode input, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
            super(cluster, traitSet, table, catalogReader, input, operation, updateColumnList, sourceExpressionList, flattened);
            assert (input.getConvention() instanceof JdbcConvention);
            assert (this.getConvention() instanceof JdbcConvention);
            ModifiableTable modifiableTable = table.unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                throw new AssertionError();
            }
            this.expression = table.getExpression(Queryable.class);
            if (this.expression == null) {
                throw new AssertionError();
            }
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new JdbcTableModify(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), JdbcTableModify.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), this.isFlattened());
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcTableModificationRule
    extends JdbcConverterRule {
        private JdbcTableModificationRule(JdbcConvention out) {
            super(LogicalTableModify.class, (RelTrait)Convention.NONE, out, "JdbcTableModificationRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalTableModify modify = (LogicalTableModify)rel;
            ModifiableTable modifiableTable = modify.getTable().unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                return null;
            }
            RelTraitSet traitSet = modify.getTraitSet().replace(this.out);
            return new JdbcTableModify(modify.getCluster(), traitSet, modify.getTable(), modify.getCatalogReader(), JdbcTableModificationRule.convert(modify.getInput(), traitSet), modify.getOperation(), modify.getUpdateColumnList(), modify.getSourceExpressionList(), modify.isFlattened());
        }
    }

    public static class JdbcMinus
    extends Minus
    implements JdbcRel {
        public JdbcMinus(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public JdbcMinus copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcMinus(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    private static class JdbcMinusRule
    extends JdbcConverterRule {
        private JdbcMinusRule(JdbcConvention out) {
            super(LogicalMinus.class, (RelTrait)Convention.NONE, out, "JdbcMinusRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalMinus minus = (LogicalMinus)rel;
            if (minus.all) {
                return null;
            }
            RelTraitSet traitSet = rel.getTraitSet().replace(this.out);
            return new JdbcMinus(rel.getCluster(), traitSet, JdbcMinusRule.convertList(minus.getInputs(), this.out), false);
        }
    }

    public static class JdbcIntersect
    extends Intersect
    implements JdbcRel {
        public JdbcIntersect(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public JdbcIntersect copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcIntersect(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    private static class JdbcIntersectRule
    extends JdbcConverterRule {
        private JdbcIntersectRule(JdbcConvention out) {
            super(LogicalIntersect.class, (RelTrait)Convention.NONE, out, "JdbcIntersectRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalIntersect intersect = (LogicalIntersect)rel;
            if (intersect.all) {
                return null;
            }
            RelTraitSet traitSet = intersect.getTraitSet().replace(this.out);
            return new JdbcIntersect(rel.getCluster(), traitSet, JdbcIntersectRule.convertList(intersect.getInputs(), this.out), false);
        }
    }

    public static class JdbcUnion
    extends Union
    implements JdbcRel {
        public JdbcUnion(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
        }

        @Override
        public JdbcUnion copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcUnion(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    private static class JdbcUnionRule
    extends JdbcConverterRule {
        private JdbcUnionRule(JdbcConvention out) {
            super(LogicalUnion.class, (RelTrait)Convention.NONE, out, "JdbcUnionRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalUnion union = (LogicalUnion)rel;
            RelTraitSet traitSet = union.getTraitSet().replace(this.out);
            return new JdbcUnion(rel.getCluster(), traitSet, JdbcUnionRule.convertList(union.getInputs(), this.out), union.all);
        }
    }

    public static class JdbcSort
    extends Sort
    implements JdbcRel {
        public JdbcSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation) {
            super(cluster, traitSet, input, collation);
            assert (this.getConvention() instanceof JdbcConvention);
            assert (this.getConvention() == input.getConvention());
        }

        @Override
        public JdbcSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
            if (offset != null || fetch != null) {
                throw new IllegalArgumentException("not supported: offset or fetch");
            }
            return new JdbcSort(this.getCluster(), traitSet, newInput, newCollation);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    private static class JdbcSortRule
    extends JdbcConverterRule {
        private JdbcSortRule(JdbcConvention out) {
            super(Sort.class, (RelTrait)Convention.NONE, out, "JdbcSortRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            Sort sort = (Sort)rel;
            if (sort.offset != null || sort.fetch != null) {
                return null;
            }
            RelTraitSet traitSet = sort.getTraitSet().replace(this.out);
            return new JdbcSort(rel.getCluster(), traitSet, JdbcSortRule.convert(sort.getInput(), traitSet), sort.getCollation());
        }
    }

    public static class JdbcAggregate
    extends Aggregate
    implements JdbcRel {
        public JdbcAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
            super(cluster, traitSet, input, indicator, groupSet, groupSets, aggCalls);
            assert (this.getConvention() instanceof JdbcConvention);
            assert (this.groupSets.size() == 1) : "Grouping sets not supported";
            assert (!this.indicator);
            SqlDialect dialect = ((JdbcConvention)this.getConvention()).dialect;
            for (AggregateCall aggCall : aggCalls) {
                if (JdbcRules.canImplement(aggCall.getAggregation(), dialect)) continue;
                throw new InvalidRelException("cannot implement aggregate function " + aggCall.getAggregation());
            }
        }

        @Override
        public JdbcAggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            try {
                return new JdbcAggregate(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    private static class JdbcAggregateRule
    extends JdbcConverterRule {
        private JdbcAggregateRule(JdbcConvention out) {
            super(LogicalAggregate.class, (RelTrait)Convention.NONE, out, "JdbcAggregateRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalAggregate agg = (LogicalAggregate)rel;
            if (agg.getGroupSets().size() != 1) {
                return null;
            }
            RelTraitSet traitSet = agg.getTraitSet().replace(this.out);
            try {
                return new JdbcAggregate(rel.getCluster(), traitSet, JdbcAggregateRule.convert(agg.getInput(), this.out), agg.indicator, agg.getGroupSet(), agg.getGroupSets(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                LOGGER.debug(e.toString());
                return null;
            }
        }
    }

    public static class JdbcFilter
    extends Filter
    implements JdbcRel {
        public JdbcFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode condition) {
            super(cluster, traitSet, input, condition);
            assert (this.getConvention() instanceof JdbcConvention);
        }

        @Override
        public JdbcFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
            return new JdbcFilter(this.getCluster(), traitSet, input, condition);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    private static class JdbcFilterRule
    extends JdbcConverterRule {
        private JdbcFilterRule(JdbcConvention out) {
            super(LogicalFilter.class, (RelTrait)Convention.NONE, out, "JdbcFilterRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalFilter filter = (LogicalFilter)rel;
            return new JdbcFilter(rel.getCluster(), rel.getTraitSet().replace(this.out), JdbcFilterRule.convert(filter.getInput(), filter.getInput().getTraitSet().replace(this.out)), filter.getCondition());
        }
    }

    public static class JdbcProject
    extends Project
    implements JdbcRel {
        public JdbcProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
            super(cluster, traitSet, input, projects, rowType);
            assert (this.getConvention() instanceof JdbcConvention);
        }

        @Deprecated
        public JdbcProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType, int flags) {
            this(cluster, traitSet, input, projects, rowType);
            Util.discard(flags);
        }

        @Override
        public JdbcProject copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
            return new JdbcProject(this.getCluster(), traitSet, input, projects, rowType);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.8);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    private static class JdbcProjectRule
    extends JdbcConverterRule {
        private JdbcProjectRule(JdbcConvention out) {
            super(LogicalProject.class, (RelTrait)Convention.NONE, out, "JdbcProjectRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            return new JdbcProject(rel.getCluster(), rel.getTraitSet().replace(this.out), JdbcProjectRule.convert(project.getInput(), project.getInput().getTraitSet().replace(this.out)), project.getProjects(), project.getRowType());
        }
    }

    public static class JdbcCalc
    extends SingleRel
    implements JdbcRel {
        private final RexProgram program;

        public JdbcCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program) {
            super(cluster, traitSet, input);
            assert (this.getConvention() instanceof JdbcConvention);
            this.program = program;
            this.rowType = program.getOutputRowType();
        }

        @Deprecated
        public JdbcCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program, int flags) {
            this(cluster, traitSet, input, program);
            Util.discard(flags);
        }

        @Override
        public RelWriter explainTerms(RelWriter pw) {
            return this.program.explainCalc(super.explainTerms(pw));
        }

        @Override
        public double estimateRowCount(RelMetadataQuery mq) {
            return RelMdUtil.estimateFilteredRows(this.getInput(), this.program, mq);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            double dRows = mq.getRowCount(this);
            double dCpu = mq.getRowCount(this.getInput()) * (double)this.program.getExprCount();
            double dIo = 0.0;
            return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new JdbcCalc(this.getCluster(), traitSet, JdbcCalc.sole(inputs), this.program);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    private static class JdbcCalcRule
    extends JdbcConverterRule {
        private JdbcCalcRule(JdbcConvention out) {
            super(LogicalCalc.class, (RelTrait)Convention.NONE, out, "JdbcCalcRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalCalc calc = (LogicalCalc)rel;
            if (RexMultisetUtil.containsMultiset(calc.getProgram())) {
                return null;
            }
            return new JdbcCalc(rel.getCluster(), rel.getTraitSet().replace(this.out), JdbcCalcRule.convert(calc.getInput(), calc.getTraitSet().replace(this.out)), calc.getProgram());
        }
    }

    public static class JdbcJoin
    extends Join
    implements JdbcRel {
        protected JdbcJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) throws InvalidRelException {
            super(cluster, traitSet, left, right, condition, variablesSet, joinType);
        }

        @Deprecated
        protected JdbcJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
            this(cluster, traitSet, left, right, condition, CorrelationId.setOf(variablesStopped), joinType);
        }

        @Override
        public JdbcJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
            try {
                return new JdbcJoin(this.getCluster(), traitSet, left, right, condition, this.variablesSet, joinType);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            double rowCount = mq.getRowCount(this);
            return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
        }

        @Override
        public double estimateRowCount(RelMetadataQuery mq) {
            double leftRowCount = this.left.estimateRowCount(mq);
            double rightRowCount = this.right.estimateRowCount(mq);
            return Math.max(leftRowCount, rightRowCount);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    private static class JdbcJoinRule
    extends JdbcConverterRule {
        private JdbcJoinRule(JdbcConvention out) {
            super(LogicalJoin.class, (RelTrait)Convention.NONE, out, "JdbcJoinRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalJoin join = (LogicalJoin)rel;
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : join.getInputs()) {
                if (input.getConvention() != this.getOutTrait()) {
                    input = JdbcJoinRule.convert(input, input.getTraitSet().replace(this.out));
                }
                newInputs.add(input);
            }
            if (!this.canJoinOnCondition(join.getCondition())) {
                return null;
            }
            try {
                return new JdbcJoin(join.getCluster(), join.getTraitSet().replace(this.out), (RelNode)newInputs.get(0), (RelNode)newInputs.get(1), join.getCondition(), join.getVariablesSet(), join.getJoinType());
            }
            catch (InvalidRelException e) {
                LOGGER.debug(e.toString());
                return null;
            }
        }

        private boolean canJoinOnCondition(RexNode node) {
            switch (node.getKind()) {
                case AND: 
                case OR: {
                    List<RexNode> operands = ((RexCall)node).getOperands();
                    for (RexNode operand : operands) {
                        if (this.canJoinOnCondition(operand)) continue;
                        return false;
                    }
                    return true;
                }
                case EQUALS: 
                case IS_NOT_DISTINCT_FROM: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    List<RexNode> operands = ((RexCall)node).getOperands();
                    if (!(operands.get(0) instanceof RexInputRef) || !(operands.get(1) instanceof RexInputRef)) break;
                    return true;
                }
            }
            return false;
        }
    }

    static abstract class JdbcConverterRule
    extends ConverterRule {
        protected final JdbcConvention out;

        JdbcConverterRule(Class<? extends RelNode> clazz, RelTrait in, JdbcConvention out, String description) {
            super(clazz, in, out, description);
            this.out = out;
        }
    }
}

