/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.AvaticaUtils;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.Meta;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.MissingResultsException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.NoSuchStatementException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.MetricsSystem;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.Timer;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.noop.NoopMetricsSystem;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.MetricsHelper;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.ProtobufMeta;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LocalService
implements Service {
    final Meta meta;
    final MetricsSystem metrics;
    private final Timer executeTimer;
    private final Timer commitTimer;
    private final Timer prepareTimer;
    private final Timer prepareAndExecuteTimer;
    private final Timer connectionSyncTimer;
    private Service.RpcMetadataResponse serverLevelRpcMetadata;

    public LocalService(Meta meta) {
        this(meta, NoopMetricsSystem.getInstance());
    }

    public LocalService(Meta meta, MetricsSystem metrics) {
        this.meta = meta;
        this.metrics = Objects.requireNonNull(metrics);
        this.executeTimer = this.metrics.getTimer(LocalService.name("Execute"));
        this.commitTimer = this.metrics.getTimer(LocalService.name("Commit"));
        this.prepareTimer = this.metrics.getTimer(LocalService.name("Prepare"));
        this.prepareAndExecuteTimer = this.metrics.getTimer(LocalService.name("PrepareAndExecute"));
        this.connectionSyncTimer = this.metrics.getTimer(LocalService.name("ConnectionSync"));
    }

    private static String name(String timer) {
        return MetricsHelper.concat(LocalService.class, timer);
    }

    @Override
    public void setRpcMetadata(Service.RpcMetadataResponse serverLevelRpcMetadata) {
        this.serverLevelRpcMetadata = Objects.requireNonNull(serverLevelRpcMetadata);
    }

    private static <E> List<E> list(Iterable<E> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<E> rowList = new ArrayList<E>();
        for (E row : iterable) {
            rowList.add(row);
        }
        return rowList;
    }

    public Service.ResultSetResponse toResponse(Meta.MetaResultSet resultSet) {
        if (resultSet.updateCount != -1L) {
            return new Service.ResultSetResponse(resultSet.connectionId, resultSet.statementId, resultSet.ownStatement, null, null, resultSet.updateCount, this.serverLevelRpcMetadata);
        }
        Meta.Signature signature = resultSet.signature;
        Meta.CursorFactory cursorFactory = resultSet.signature.cursorFactory;
        Meta.Frame frame = null;
        int updateCount = -1;
        if (resultSet.firstFrame != null) {
            List<Object> list = LocalService.list(resultSet.firstFrame.rows);
            switch (cursorFactory.style) {
                case ARRAY: {
                    cursorFactory = Meta.CursorFactory.LIST;
                    break;
                }
                case MAP: 
                case LIST: {
                    break;
                }
                case RECORD: {
                    cursorFactory = Meta.CursorFactory.LIST;
                    break;
                }
                default: {
                    cursorFactory = Meta.CursorFactory.map(cursorFactory.fieldNames);
                }
            }
            boolean done = resultSet.firstFrame.done;
            frame = new Meta.Frame(0L, done, list);
            updateCount = -1;
            if (signature.statementType != null && signature.statementType.canUpdate()) {
                frame = null;
                updateCount = ((Number)((List)list.get(0)).get(0)).intValue();
            }
        } else {
            cursorFactory = Meta.CursorFactory.LIST;
        }
        if (cursorFactory != resultSet.signature.cursorFactory) {
            signature = signature.setCursorFactory(cursorFactory);
        }
        return new Service.ResultSetResponse(resultSet.connectionId, resultSet.statementId, resultSet.ownStatement, signature, frame, updateCount, this.serverLevelRpcMetadata);
    }

    @Override
    public Service.ResultSetResponse apply(Service.CatalogsRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.MetaResultSet resultSet = this.meta.getCatalogs(ch);
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.SchemasRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.MetaResultSet resultSet = this.meta.getSchemas(ch, request.catalog, Meta.Pat.of(request.schemaPattern));
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.TablesRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.MetaResultSet resultSet = this.meta.getTables(ch, request.catalog, Meta.Pat.of(request.schemaPattern), Meta.Pat.of(request.tableNamePattern), request.typeList);
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.TableTypesRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.MetaResultSet resultSet = this.meta.getTableTypes(ch);
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.TypeInfoRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.MetaResultSet resultSet = this.meta.getTypeInfo(ch);
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.ColumnsRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.MetaResultSet resultSet = this.meta.getColumns(ch, request.catalog, Meta.Pat.of(request.schemaPattern), Meta.Pat.of(request.tableNamePattern), Meta.Pat.of(request.columnNamePattern));
        return this.toResponse(resultSet);
    }

    @Override
    public Service.PrepareResponse apply(Service.PrepareRequest request) {
        try (Timer.Context ignore = this.prepareTimer.start();){
            Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
            Meta.StatementHandle h = this.meta.prepare(ch, request.sql, request.maxRowCount);
            Service.PrepareResponse prepareResponse = new Service.PrepareResponse(h, this.serverLevelRpcMetadata);
            return prepareResponse;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Service.ExecuteResponse apply(Service.PrepareAndExecuteRequest request) {
        Throwable throwable = null;
        try (Timer.Context ignore = this.prepareAndExecuteTimer.start();){
            Meta.StatementHandle sh = new Meta.StatementHandle(request.connectionId, request.statementId, null);
            try {
                Meta.ExecuteResult executeResult = this.meta.prepareAndExecute(sh, request.sql, request.maxRowCount, request.maxRowsInFirstFrame, new Meta.PrepareCallback(){

                    @Override
                    public Object getMonitor() {
                        return LocalService.class;
                    }

                    @Override
                    public void clear() {
                    }

                    @Override
                    public void assign(Meta.Signature signature, Meta.Frame firstFrame, long updateCount) {
                    }

                    @Override
                    public void execute() {
                    }
                });
                ArrayList<Service.ResultSetResponse> results = new ArrayList<Service.ResultSetResponse>();
                for (Meta.MetaResultSet metaResultSet : executeResult.resultSets) {
                    results.add(this.toResponse(metaResultSet));
                }
                Service.ExecuteResponse executeResponse = new Service.ExecuteResponse(results, false, this.serverLevelRpcMetadata);
                return executeResponse;
            }
            catch (NoSuchStatementException e) {
                Service.ExecuteResponse executeResponse;
                block18: {
                    block19: {
                        executeResponse = new Service.ExecuteResponse(null, true, this.serverLevelRpcMetadata);
                        if (ignore == null) break block18;
                        if (throwable == null) break block19;
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block18;
                    }
                    ignore.close();
                }
                return executeResponse;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    @Override
    public Service.FetchResponse apply(Service.FetchRequest request) {
        Meta.StatementHandle h = new Meta.StatementHandle(request.connectionId, request.statementId, null);
        try {
            Meta.Frame frame = this.meta.fetch(h, request.offset, request.fetchMaxRowCount);
            return new Service.FetchResponse(frame, false, false, this.serverLevelRpcMetadata);
        }
        catch (NoSuchStatementException | NullPointerException e) {
            return new Service.FetchResponse(null, true, true, this.serverLevelRpcMetadata);
        }
        catch (MissingResultsException e) {
            return new Service.FetchResponse(null, false, true, this.serverLevelRpcMetadata);
        }
    }

    @Override
    public Service.ExecuteResponse apply(Service.ExecuteRequest request) {
        Throwable throwable = null;
        try (Timer.Context ignore = this.executeTimer.start();){
            Meta.ExecuteResult executeResult = this.meta.execute(request.statementHandle, request.parameterValues, AvaticaUtils.toSaturatedInt(request.maxRowCount));
            ArrayList<Service.ResultSetResponse> results = new ArrayList<Service.ResultSetResponse>(executeResult.resultSets.size());
            for (Meta.MetaResultSet metaResultSet : executeResult.resultSets) {
                results.add(this.toResponse(metaResultSet));
            }
            Service.ExecuteResponse executeResponse = new Service.ExecuteResponse(results, false, this.serverLevelRpcMetadata);
            return executeResponse;
        }
        catch (NoSuchStatementException e) {
            Service.ExecuteResponse executeResponse = new Service.ExecuteResponse(null, true, this.serverLevelRpcMetadata);
            return executeResponse;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    @Override
    public Service.CreateStatementResponse apply(Service.CreateStatementRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.StatementHandle h = this.meta.createStatement(ch);
        return new Service.CreateStatementResponse(h.connectionId, h.id, this.serverLevelRpcMetadata);
    }

    @Override
    public Service.CloseStatementResponse apply(Service.CloseStatementRequest request) {
        Meta.StatementHandle h = new Meta.StatementHandle(request.connectionId, request.statementId, null);
        this.meta.closeStatement(h);
        return new Service.CloseStatementResponse(this.serverLevelRpcMetadata);
    }

    @Override
    public Service.OpenConnectionResponse apply(Service.OpenConnectionRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        this.meta.openConnection(ch, request.info);
        return new Service.OpenConnectionResponse(this.serverLevelRpcMetadata);
    }

    @Override
    public Service.CloseConnectionResponse apply(Service.CloseConnectionRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        this.meta.closeConnection(ch);
        return new Service.CloseConnectionResponse(this.serverLevelRpcMetadata);
    }

    @Override
    public Service.ConnectionSyncResponse apply(Service.ConnectionSyncRequest request) {
        try (Timer.Context ignore = this.connectionSyncTimer.start();){
            Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
            Meta.ConnectionProperties connProps = this.meta.connectionSync(ch, request.connProps);
            Service.ConnectionSyncResponse connectionSyncResponse = new Service.ConnectionSyncResponse(connProps, this.serverLevelRpcMetadata);
            return connectionSyncResponse;
        }
    }

    @Override
    public Service.DatabasePropertyResponse apply(Service.DatabasePropertyRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        return new Service.DatabasePropertyResponse(this.meta.getDatabaseProperties(ch), this.serverLevelRpcMetadata);
    }

    @Override
    public Service.SyncResultsResponse apply(Service.SyncResultsRequest request) {
        Service.SyncResultsResponse response;
        Meta.StatementHandle h = new Meta.StatementHandle(request.connectionId, request.statementId, null);
        try {
            response = new Service.SyncResultsResponse(this.meta.syncResults(h, request.state, request.offset), false, this.serverLevelRpcMetadata);
        }
        catch (NoSuchStatementException e) {
            response = new Service.SyncResultsResponse(false, true, this.serverLevelRpcMetadata);
        }
        return response;
    }

    @Override
    public Service.CommitResponse apply(Service.CommitRequest request) {
        try (Timer.Context ignore = this.commitTimer.start();){
            this.meta.commit(new Meta.ConnectionHandle(request.connectionId));
            Service.CommitResponse commitResponse = new Service.CommitResponse();
            return commitResponse;
        }
    }

    @Override
    public Service.RollbackResponse apply(Service.RollbackRequest request) {
        this.meta.rollback(new Meta.ConnectionHandle(request.connectionId));
        return new Service.RollbackResponse();
    }

    @Override
    public Service.ExecuteBatchResponse apply(Service.PrepareAndExecuteBatchRequest request) {
        Meta.StatementHandle h = new Meta.StatementHandle(request.connectionId, request.statementId, null);
        try {
            Meta.ExecuteBatchResult result = this.meta.prepareAndExecuteBatch(h, request.sqlCommands);
            return new Service.ExecuteBatchResponse(request.connectionId, request.statementId, result.updateCounts, false, this.serverLevelRpcMetadata);
        }
        catch (NoSuchStatementException e) {
            return new Service.ExecuteBatchResponse(request.connectionId, request.statementId, null, true, this.serverLevelRpcMetadata);
        }
    }

    @Override
    public Service.ExecuteBatchResponse apply(Service.ExecuteBatchRequest request) {
        Meta.StatementHandle h = new Meta.StatementHandle(request.connectionId, request.statementId, null);
        try {
            Meta.ExecuteBatchResult result = request.hasProtoUpdateBatches() && this.meta instanceof ProtobufMeta ? ((ProtobufMeta)this.meta).executeBatchProtobuf(h, request.getProtoUpdateBatches()) : this.meta.executeBatch(h, request.parameterValues);
            return new Service.ExecuteBatchResponse(request.connectionId, request.statementId, result.updateCounts, false, this.serverLevelRpcMetadata);
        }
        catch (NoSuchStatementException e) {
            return new Service.ExecuteBatchResponse(request.connectionId, request.statementId, null, true, this.serverLevelRpcMetadata);
        }
    }
}

