/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.AvaticaUtils;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.MetricsSystem;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.Timer;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.metrics.noop.NoopMetricsSystem;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.Handler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.MetricsHelper;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.ProtobufHandler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.ProtobufTranslation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.ProtobufTranslationImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.remote.Service;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.AbstractAvaticaHandler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.AvaticaJsonHandler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.RemoteUserDisallowedException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.server.RemoteUserExtractionException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.util.UnsynchronizedBuffer;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.Request;
import com.alibaba.lindorm.thirdparty.org.slf4j.Logger;
import com.alibaba.lindorm.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AvaticaProtobufHandler
extends AbstractAvaticaHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaJsonHandler.class);
    private final Service service;
    private final ProtobufHandler pbHandler;
    private final ProtobufTranslation protobufTranslation;
    private final MetricsSystem metrics;
    private final Timer requestTimer;
    private final AvaticaServerConfiguration serverConfig;
    final ThreadLocal<UnsynchronizedBuffer> threadLocalBuffer;

    public AvaticaProtobufHandler(Service service) {
        this(service, NoopMetricsSystem.getInstance());
    }

    public AvaticaProtobufHandler(Service service, MetricsSystem metrics) {
        this(service, metrics, null);
    }

    public AvaticaProtobufHandler(Service service, MetricsSystem metrics, AvaticaServerConfiguration serverConfig) {
        this.service = Objects.requireNonNull(service);
        this.metrics = Objects.requireNonNull(metrics);
        this.requestTimer = this.metrics.getTimer(MetricsHelper.concat(AvaticaProtobufHandler.class, "Handler.RequestTimings"));
        this.protobufTranslation = new ProtobufTranslationImpl();
        this.pbHandler = new ProtobufHandler(service, this.protobufTranslation, metrics);
        this.threadLocalBuffer = new ThreadLocal<UnsynchronizedBuffer>(){

            @Override
            public UnsynchronizedBuffer initialValue() {
                return new UnsynchronizedBuffer();
            }
        };
        this.serverConfig = serverConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block37: {
            try (Timer.Context ctx = this.requestTimer.start();){
                Handler.HandlerResponse<Object> handlerResponse;
                byte[] requestBytes;
                if (!this.isUserPermitted(this.serverConfig, request, response)) {
                    LOG.debug("HTTP request from {} is unauthenticated and authentication is required", (Object)request.getRemoteAddr());
                    return;
                }
                response.setContentType("application/octet-stream;charset=utf-8");
                response.setStatus(200);
                if (!request.getMethod().equals("POST")) break block37;
                UnsynchronizedBuffer buffer = this.threadLocalBuffer.get();
                try (ServletInputStream inputStream = request.getInputStream();){
                    requestBytes = AvaticaUtils.readFullyToBytes((InputStream)inputStream, buffer);
                }
                finally {
                    buffer.reset();
                }
                try {
                    if (null != this.serverConfig && this.serverConfig.supportsImpersonation()) {
                        String remoteUser = this.serverConfig.getRemoteUserExtractor().extract(request);
                        handlerResponse = this.serverConfig.doAsRemoteUser(remoteUser, request.getRemoteAddr(), new Callable<Handler.HandlerResponse<byte[]>>(){

                            @Override
                            public Handler.HandlerResponse<byte[]> call() {
                                return AvaticaProtobufHandler.this.pbHandler.apply(requestBytes);
                            }
                        });
                    } else {
                        handlerResponse = this.pbHandler.apply(requestBytes);
                    }
                }
                catch (RemoteUserExtractionException e) {
                    LOG.debug("Failed to extract remote user from request", e);
                    handlerResponse = this.pbHandler.unauthenticatedErrorResponse(e);
                }
                catch (RemoteUserDisallowedException e) {
                    LOG.debug("Remote user is not authorized", e);
                    handlerResponse = this.pbHandler.unauthorizedErrorResponse(e);
                }
                catch (Exception e) {
                    LOG.debug("Error invoking request from {}", (Object)baseRequest.getRemoteAddr(), (Object)e);
                    handlerResponse = this.pbHandler.convertToErrorResponse(e);
                }
                baseRequest.setHandled(true);
                response.setStatus(handlerResponse.getStatusCode());
                response.getOutputStream().write((byte[])handlerResponse.getResponse());
            }
        }
    }

    @Override
    public void setServerRpcMetadata(Service.RpcMetadataResponse metadata) {
        this.service.setRpcMetadata(metadata);
        this.pbHandler.setRpcMetadata(metadata);
    }

    @Override
    public MetricsSystem getMetrics() {
        return this.metrics;
    }
}

