/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.plan;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Function;
import com.alibaba.lindorm.thirdparty.com.google.common.base.Supplier;
import com.alibaba.lindorm.thirdparty.com.google.common.base.Suppliers;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableCollection;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Iterables;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Lists;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Sets;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.MaterializedViewSubstitutionVisitor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptLattice;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptMaterialization;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.hep.HepPlanner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.hep.HepProgram;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.hep.HepProgramBuilder;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare.CalcitePrepareImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.rules.ProjectMergeRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.rules.ProjectRemoveRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Pair;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.graph.DefaultDirectedGraph;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.graph.DefaultEdge;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.graph.Graphs;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.graph.TopologicalOrderIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class RelOptMaterializations {
    private static final Function<RelOptTable, List<String>> GET_QUALIFIED_NAME = new Function<RelOptTable, List<String>>(){

        @Override
        public List<String> apply(RelOptTable relOptTable) {
            return relOptTable.getQualifiedName();
        }
    };

    public static List<Pair<RelNode, List<RelOptMaterialization>>> useMaterializedViews(RelNode rel, List<RelOptMaterialization> materializations) {
        List<RelOptMaterialization> applicableMaterializations = RelOptMaterializations.getApplicableMaterializations(rel, materializations);
        ArrayList<Pair<RelNode, ImmutableCollection>> applied = new ArrayList<Pair<RelNode, ImmutableCollection>>();
        applied.add(Pair.of(rel, ImmutableList.of()));
        for (RelOptMaterialization m : applicableMaterializations) {
            int count = applied.size();
            for (int i = 0; i < count; ++i) {
                Pair current = (Pair)applied.get(i);
                List<RelNode> sub = RelOptMaterializations.substitute((RelNode)current.left, m);
                if (sub.isEmpty()) continue;
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.addAll((Iterable)current.right);
                builder.add(m);
                ImmutableCollection uses = builder.build();
                for (RelNode rel2 : sub) {
                    applied.add(Pair.of(rel2, uses));
                }
            }
        }
        return applied.subList(1, applied.size());
    }

    public static List<Pair<RelNode, RelOptLattice>> useLattices(final RelNode rel, List<RelOptLattice> lattices) {
        Set<RelOptTable> queryTables = RelOptUtil.findTables(rel);
        ArrayList<Pair<RelNode, RelOptLattice>> latticeUses = Lists.newArrayList();
        HashSet<List<String>> queryTableNames = Sets.newHashSet(Iterables.transform(queryTables, GET_QUALIFIED_NAME));
        Supplier<RelNode> leafJoinRoot = Suppliers.memoize(new Supplier<RelNode>(){

            @Override
            public RelNode get() {
                return RelOptMaterialization.toLeafJoinForm(rel);
            }
        });
        for (RelOptLattice lattice : lattices) {
            RelNode rel2;
            if (!queryTableNames.contains(lattice.rootTable().getQualifiedName()) || (rel2 = lattice.rewrite(leafJoinRoot.get())) == null) continue;
            if (CalcitePrepareImpl.DEBUG) {
                System.out.println("use lattice:\n" + RelOptUtil.toString(rel2));
            }
            latticeUses.add(Pair.of(rel2, lattice));
        }
        return latticeUses;
    }

    public static List<RelOptMaterialization> getApplicableMaterializations(RelNode rel, List<RelOptMaterialization> materializations) {
        DefaultDirectedGraph<List<String>, DefaultEdge> usesGraph = DefaultDirectedGraph.create();
        HashMap<List<String>, RelOptMaterialization> qnameMap = new HashMap<List<String>, RelOptMaterialization>();
        for (RelOptMaterialization materialization : materializations) {
            if (materialization.qualifiedTableName == null || materialization.starTable != null) continue;
            List<String> qname = materialization.qualifiedTableName;
            qnameMap.put(qname, materialization);
            for (RelOptTable usedTable : RelOptUtil.findTables(materialization.queryRel)) {
                usesGraph.addVertex(qname);
                usesGraph.addVertex(usedTable.getQualifiedName());
                usesGraph.addEdge(usedTable.getQualifiedName(), qname);
            }
        }
        Graphs.FrozenGraph<List<String>, DefaultEdge> frozenGraph = Graphs.makeImmutable(usesGraph);
        Set<RelOptTable> queryTablesUsed = RelOptUtil.findTables(rel);
        ArrayList<RelOptMaterialization> applicableMaterializations = Lists.newArrayList();
        for (List qname : TopologicalOrderIterator.of(usesGraph)) {
            RelOptMaterialization materialization = (RelOptMaterialization)qnameMap.get(qname);
            if (materialization == null || !RelOptMaterializations.usesTable(materialization.qualifiedTableName, queryTablesUsed, frozenGraph)) continue;
            applicableMaterializations.add(materialization);
        }
        return applicableMaterializations;
    }

    private static List<RelNode> substitute(RelNode root, RelOptMaterialization materialization) {
        RelNode newRoot;
        if (materialization.starTable != null && (newRoot = RelOptMaterialization.tryUseStar(root, materialization.starRelOptTable)) != null) {
            root = newRoot;
        }
        RelNode target = materialization.queryRel;
        HepProgram program = new HepProgramBuilder().addRuleInstance(FilterProjectTransposeRule.INSTANCE).addRuleInstance(ProjectMergeRule.INSTANCE).addRuleInstance(ProjectRemoveRule.INSTANCE).build();
        HepPlanner hepPlanner = new HepPlanner(program);
        hepPlanner.setRoot(target);
        target = hepPlanner.findBestExp();
        hepPlanner.setRoot(root);
        root = hepPlanner.findBestExp();
        return new MaterializedViewSubstitutionVisitor(target, root).go(materialization.tableRel);
    }

    private static boolean usesTable(List<String> qualifiedName, Set<RelOptTable> usedTables, Graphs.FrozenGraph<List<String>, DefaultEdge> usesGraph) {
        for (RelOptTable queryTable : usedTables) {
            if (usesGraph.getShortestPath(queryTable.getQualifiedName(), qualifiedName) == null) continue;
            return true;
        }
        return false;
    }
}

