/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.com.google.common.base.Supplier;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.Convention;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTrait;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelCollationTraitDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelDistribution;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelDistributionTraitDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelInput;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelShuttle;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.CorrelationId;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Filter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMdCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMdDistribution;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import java.util.List;
import java.util.Set;

public final class LogicalFilter
extends Filter {
    private final ImmutableSet<CorrelationId> variablesSet;

    public LogicalFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition, ImmutableSet<CorrelationId> variablesSet) {
        super(cluster, traitSet, child, condition);
        this.variablesSet = Preconditions.checkNotNull(variablesSet);
    }

    @Deprecated
    public LogicalFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        this(cluster, traitSet, child, condition, ImmutableSet.of());
    }

    @Deprecated
    public LogicalFilter(RelOptCluster cluster, RelNode child, RexNode condition) {
        this(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), child, condition, ImmutableSet.of());
    }

    public LogicalFilter(RelInput input) {
        super(input);
        this.variablesSet = ImmutableSet.of();
    }

    public static LogicalFilter create(RelNode input, RexNode condition) {
        return LogicalFilter.create(input, condition, ImmutableSet.of());
    }

    public static LogicalFilter create(final RelNode input, RexNode condition, ImmutableSet<CorrelationId> variablesSet) {
        RelOptCluster cluster = input.getCluster();
        final RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.NONE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

            @Override
            public List<RelCollation> get() {
                return RelMdCollation.filter(mq, input);
            }
        }).replaceIf(RelDistributionTraitDef.INSTANCE, new Supplier<RelDistribution>(){

            @Override
            public RelDistribution get() {
                return RelMdDistribution.filter(mq, input);
            }
        });
        return new LogicalFilter(cluster, traitSet, input, condition, variablesSet);
    }

    @Override
    public Set<CorrelationId> getVariablesSet() {
        return this.variablesSet;
    }

    @Override
    public LogicalFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new LogicalFilter(this.getCluster(), traitSet, input, condition, this.variablesSet);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("variablesSet", this.variablesSet, !this.variablesSet.isEmpty());
    }
}

