/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.runtime;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Function;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Holder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public enum Hook {
    CURRENT_TIME,
    STANDARD_STREAMS,
    REL_BUILDER_SIMPLIFY,
    ENABLE_BINDABLE,
    PARSE_TREE,
    STRING_TO_QUERY,
    JAVA_PLAN,
    CONVERTED,
    PLANNER,
    TRIMMED,
    SUB,
    EXPRESSION_REDUCER,
    PROGRAM,
    CREATE_MATERIALIZATION,
    QUERY_PLAN;

    private final List<Function<Object, Object>> handlers = new CopyOnWriteArrayList<Function<Object, Object>>();
    private final ThreadLocal<List<Function<Object, Object>>> threadHandlers = new ThreadLocal<List<Function<Object, Object>>>(){

        @Override
        protected List<Function<Object, Object>> initialValue() {
            return new ArrayList<Function<Object, Object>>();
        }
    };

    public <T, R> Closeable add(final Function<T, R> handler) {
        this.handlers.add(handler);
        return new Closeable(){

            @Override
            public void close() {
                Hook.this.remove(handler);
            }
        };
    }

    private boolean remove(Function handler) {
        return this.handlers.remove(handler);
    }

    public <T, R> Closeable addThread(final Function<T, R> handler) {
        this.threadHandlers.get().add(handler);
        return new Closeable(){

            @Override
            public void close() {
                Hook.this.removeThread(handler);
            }
        };
    }

    private boolean removeThread(Function handler) {
        return this.threadHandlers.get().remove(handler);
    }

    public static <V> Function<Holder<V>, Void> property(final V v) {
        return new Function<Holder<V>, Void>(){

            @Override
            public Void apply(Holder<V> holder) {
                holder.set(v);
                return null;
            }
        };
    }

    public void run(Object arg) {
        for (Function<Object, Object> handler : this.handlers) {
            handler.apply(arg);
        }
        for (Function<Object, Object> handler : this.threadHandlers.get()) {
            handler.apply(arg);
        }
    }

    public <V> V get(V defaultValue) {
        Holder<V> holder = Holder.of(defaultValue);
        this.run(holder);
        return holder.get();
    }

    public static interface Closeable
    extends AutoCloseable {
        public static final Closeable EMPTY = new Closeable(){

            @Override
            public void close() {
            }
        };

        @Override
        public void close();
    }
}

