/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteConnection;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.FunctionParameter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Schemas;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.TableMacro;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.TranslatableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.MaterializedViewTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.ModifiableViewTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.ViewTable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public class ViewTableMacro
implements TableMacro {
    protected final String viewSql;
    protected final CalciteSchema schema;
    private final Boolean modifiable;
    protected final List<String> schemaPath;
    protected final List<String> viewPath;

    public ViewTableMacro(CalciteSchema schema, String viewSql, List<String> schemaPath, List<String> viewPath, Boolean modifiable) {
        this.viewSql = viewSql;
        this.schema = schema;
        this.viewPath = viewPath == null ? null : ImmutableList.copyOf(viewPath);
        this.modifiable = modifiable;
        this.schemaPath = schemaPath == null ? null : ImmutableList.copyOf(schemaPath);
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public TranslatableTable apply(List<Object> arguments) {
        List<String> schemaPath1;
        CalciteConnection connection = MaterializedViewTable.MATERIALIZATION_CONNECTION;
        CalcitePrepare.AnalyzeViewResult parsed = Schemas.analyzeView(connection, this.schema, this.schemaPath, this.viewSql, this.viewPath, this.modifiable != null && this.modifiable != false);
        List<String> list = schemaPath1 = this.schemaPath != null ? this.schemaPath : this.schema.path(null);
        if ((this.modifiable == null || this.modifiable.booleanValue()) && parsed.modifiable && parsed.table != null) {
            return this.modifiableViewTable(parsed, this.viewSql, schemaPath1, this.viewPath, this.schema);
        }
        return this.viewTable(parsed, this.viewSql, schemaPath1, this.viewPath);
    }

    protected ModifiableViewTable modifiableViewTable(CalcitePrepare.AnalyzeViewResult parsed, String viewSql, List<String> schemaPath, List<String> viewPath, CalciteSchema schema) {
        JavaTypeFactory typeFactory = (JavaTypeFactory)parsed.typeFactory;
        Type elementType = typeFactory.getJavaClass(parsed.rowType);
        return new ModifiableViewTable(elementType, RelDataTypeImpl.proto(parsed.rowType), viewSql, schemaPath, viewPath, parsed.table, Schemas.path(schema.root(), parsed.tablePath), parsed.constraint, parsed.columnMapping);
    }

    protected ViewTable viewTable(CalcitePrepare.AnalyzeViewResult parsed, String viewSql, List<String> schemaPath, List<String> viewPath) {
        JavaTypeFactory typeFactory = (JavaTypeFactory)parsed.typeFactory;
        Type elementType = typeFactory.getJavaClass(parsed.rowType);
        return new ViewTable(elementType, RelDataTypeImpl.proto(parsed.rowType), viewSql, schemaPath, viewPath);
    }
}

