/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.materialize.MaterializationKey;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.materialize.MaterializationService;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelProtoDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Schema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.TranslatableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.ViewTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.ViewTableMacro;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCreate;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlExecutableStatement;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIdentifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNodeList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSpecialOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlCreateTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlDdlNodes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.CalciteSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableNullableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Pair;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Static;
import java.util.List;

public class SqlCreateMaterializedView
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private final SqlNodeList columnList;
    private final SqlNode query;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE MATERIALIZED VIEW", SqlKind.CREATE_MATERIALIZED_VIEW);

    SqlCreateMaterializedView(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNodeList columnList, SqlNode query) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Preconditions.checkNotNull(name);
        this.columnList = columnList;
        this.query = Preconditions.checkNotNull(query);
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columnList, this.query);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("MATERIALIZED VIEW");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.query.unparse(writer, 0, 0);
    }

    @Override
    public void execute(CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        if (((CalciteSchema)pair.left).plus().getTable((String)pair.right) != null) {
            if (!this.ifNotExists) {
                throw SqlUtil.newContextException(this.name.getParserPosition(), Static.RESOURCE.tableExists((String)pair.right));
            }
            return;
        }
        SqlNode q = SqlDdlNodes.renameColumns(this.columnList, this.query);
        String sql = q.toSqlString(CalciteSqlDialect.DEFAULT).getSql();
        List<String> schemaPath = ((CalciteSchema)pair.left).path(null);
        ViewTableMacro viewTableMacro = ViewTable.viewMacro(((CalciteSchema)pair.left).plus(), sql, schemaPath, context.getObjectPath(), false);
        TranslatableTable x = viewTableMacro.apply(ImmutableList.of());
        RelDataType rowType = x.getRowType(context.getTypeFactory());
        MaterializedViewTable table = new MaterializedViewTable((String)pair.right, RelDataTypeImpl.proto(rowType));
        ((CalciteSchema)pair.left).add((String)pair.right, table);
        SqlDdlNodes.populate(this.name, this.query, context);
        table.key = MaterializationService.instance().defineMaterialization((CalciteSchema)pair.left, null, sql, schemaPath, (String)pair.right, true, true);
    }

    private static class MaterializedViewTable
    extends SqlCreateTable.MutableArrayTable {
        MaterializationKey key;

        MaterializedViewTable(String name, RelProtoDataType protoRowType) {
            super(name, protoRowType, protoRowType, NullInitializerExpressionFactory.INSTANCE);
        }

        @Override
        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.MATERIALIZED_VIEW;
        }

        @Override
        public <C> C unwrap(Class<C> aClass) {
            if (MaterializationKey.class.isAssignableFrom(aClass) && aClass.isInstance(this.key)) {
                return aClass.cast(this.key);
            }
            return super.unwrap(aClass);
        }
    }
}

