/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlDrop;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlExecutableStatement;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIdentifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSpecialOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Static;
import java.util.List;

public class SqlDropSchema
extends SqlDrop
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("DROP SCHEMA", SqlKind.DROP_SCHEMA);

    SqlDropSchema(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        super(OPERATOR, pos, ifExists);
        this.name = name;
    }

    public String getSchemaName() {
        return this.name.toString();
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return null;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
    }

    @Override
    public void execute(CalcitePrepare.Context context) {
        List<String> path = context.getDefaultSchemaPath();
        CalciteSchema schema = context.getRootSchema();
        for (String p : path) {
            schema = schema.getSubSchema(p, true);
        }
        boolean existed = schema.removeSubSchema(this.name.getSimple());
        if (!existed && !this.ifExists) {
            throw SqlUtil.newContextException(this.name.getParserPosition(), Static.RESOURCE.schemaNotFound(this.name.getSimple()));
        }
    }
}

