/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.util.TimeUnit;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCallBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlFunctionCategory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIntervalQualifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperandCountRange;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.InferTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.OperandTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.ReturnTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidator;
import java.util.List;

public class SqlDatePartFunction
extends SqlFunction {
    private final TimeUnit timeUnit;

    public SqlDatePartFunction(String name, TimeUnit timeUnit) {
        super(name, SqlKind.OTHER, ReturnTypes.BIGINT_NULLABLE, InferTypes.FIRST_KNOWN, OperandTypes.DATETIME, SqlFunctionCategory.TIMEDATE);
        this.timeUnit = timeUnit;
    }

    @Override
    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        SqlParserPos pos = call.getParserPosition();
        return SqlStdOperatorTable.EXTRACT.createCall(pos, new SqlIntervalQualifier(this.timeUnit, null, SqlParserPos.ZERO), operands.get(0));
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(1);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (1 == operandsCount);
        return "{0}({1})";
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return OperandTypes.DATETIME.checkSingleOperandType(callBinding, callBinding.operand(0), 0, throwOnFailure);
    }
}

