/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.eclipse.jetty.security;

import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.security.CrossContextPsuedoSession;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HashCrossContextPsuedoSession<T>
implements CrossContextPsuedoSession<T> {
    private final String _cookieName;
    private final String _cookiePath;
    private final Random _random = new SecureRandom();
    private final Map<String, T> _data = new HashMap<String, T>();

    public HashCrossContextPsuedoSession(String cookieName, String cookiePath) {
        this._cookieName = cookieName;
        this._cookiePath = cookiePath == null ? "/" : cookiePath;
    }

    @Override
    public T fetch(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!this._cookieName.equals(cookie.getName())) continue;
            String key = cookie.getValue();
            return this._data.get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(T datum, HttpServletResponse response) {
        String key;
        Map<String, T> map = this._data;
        synchronized (map) {
            while (this._data.containsKey(key = Long.toString(Math.abs(this._random.nextLong()), 30 + (int)(System.currentTimeMillis() % 7L)))) {
            }
            this._data.put(key, datum);
        }
        Cookie cookie = new Cookie(this._cookieName, key);
        cookie.setPath(this._cookiePath);
        response.addCookie(cookie);
    }

    @Override
    public void clear(HttpServletRequest request) {
        for (Cookie cookie : request.getCookies()) {
            if (!this._cookieName.equals(cookie.getName())) continue;
            String key = cookie.getValue();
            this._data.remove(key);
            break;
        }
    }
}

