/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server;

import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.TypeUtil;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.component.Dumpable;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Collections;

public class ClassLoaderDump
implements Dumpable {
    final ClassLoader _loader;

    public ClassLoaderDump(ClassLoader loader) {
        this._loader = loader;
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        if (this._loader == null) {
            out.append("No ClassLoader\n");
        } else {
            out.append(String.valueOf(this._loader)).append("\n");
            Object parent = this._loader.getParent();
            if (parent != null) {
                if (!(parent instanceof Dumpable)) {
                    parent = new ClassLoaderDump((ClassLoader)parent);
                }
                if (this._loader instanceof URLClassLoader) {
                    ContainerLifeCycle.dump(out, indent, TypeUtil.asList(((URLClassLoader)this._loader).getURLs()), Collections.singleton(parent));
                } else {
                    ContainerLifeCycle.dump(out, indent, Collections.singleton(parent));
                }
            }
        }
    }
}

