/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server;

import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.http.HttpScheme;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.Connector;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.Request;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.Jetty;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.annotation.ManagedAttribute;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.annotation.ManagedObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@ManagedObject(value="HTTP Configuration")
public class HttpConfiguration {
    public static final String SERVER_VERSION = "Jetty(" + Jetty.VERSION + ")";
    private List<Customizer> _customizers = new CopyOnWriteArrayList<Customizer>();
    private int _outputBufferSize = 32768;
    private int _outputAggregationSize = this._outputBufferSize / 4;
    private int _requestHeaderSize = 8192;
    private int _responseHeaderSize = 8192;
    private int _headerCacheSize = 512;
    private int _securePort;
    private String _secureScheme = HttpScheme.HTTPS.asString();
    private boolean _sendServerVersion = true;
    private boolean _sendXPoweredBy = false;
    private boolean _sendDateHeader = true;
    private boolean _delayDispatchUntilContent = false;

    public HttpConfiguration() {
    }

    public HttpConfiguration(HttpConfiguration config) {
        this._customizers.addAll(config._customizers);
        this._outputBufferSize = config._outputBufferSize;
        this._outputAggregationSize = config._outputAggregationSize;
        this._requestHeaderSize = config._requestHeaderSize;
        this._responseHeaderSize = config._responseHeaderSize;
        this._securePort = config._securePort;
        this._secureScheme = config._secureScheme;
        this._sendDateHeader = config._sendDateHeader;
        this._sendServerVersion = config._sendServerVersion;
        this._headerCacheSize = config._headerCacheSize;
    }

    public void addCustomizer(Customizer customizer) {
        this._customizers.add(customizer);
    }

    public List<Customizer> getCustomizers() {
        return this._customizers;
    }

    public <T> T getCustomizer(Class<T> type) {
        for (Customizer c : this._customizers) {
            if (!type.isAssignableFrom(c.getClass())) continue;
            return (T)c;
        }
        return null;
    }

    @ManagedAttribute(value="The size in bytes of the output buffer used to aggregate HTTP output")
    public int getOutputBufferSize() {
        return this._outputBufferSize;
    }

    @ManagedAttribute(value="The maximum size in bytes for HTTP output to be aggregated")
    public int getOutputAggregationSize() {
        return this._outputAggregationSize;
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for a HTTP request header")
    public int getRequestHeaderSize() {
        return this._requestHeaderSize;
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for a HTTP response header")
    public int getResponseHeaderSize() {
        return this._responseHeaderSize;
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for a HTTP header field cache")
    public int getHeaderCacheSize() {
        return this._headerCacheSize;
    }

    @ManagedAttribute(value="The port to which Integral or Confidential security constraints are redirected")
    public int getSecurePort() {
        return this._securePort;
    }

    @ManagedAttribute(value="The scheme with which Integral or Confidential security constraints are redirected")
    public String getSecureScheme() {
        return this._secureScheme;
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this._sendServerVersion = sendServerVersion;
    }

    @ManagedAttribute(value="if true, send the Server header in responses")
    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    public void setSendXPoweredBy(boolean sendXPoweredBy) {
        this._sendXPoweredBy = sendXPoweredBy;
    }

    @ManagedAttribute(value="if true, send the X-Powered-By header in responses")
    public boolean getSendXPoweredBy() {
        return this._sendXPoweredBy;
    }

    public void setSendDateHeader(boolean sendDateHeader) {
        this._sendDateHeader = sendDateHeader;
    }

    @ManagedAttribute(value="if true, include the date in HTTP headers")
    public boolean getSendDateHeader() {
        return this._sendDateHeader;
    }

    public void setDelayDispatchUntilContent(boolean delay) {
        this._delayDispatchUntilContent = delay;
    }

    @ManagedAttribute(value="if true, delay the application dispatch until content is available")
    public boolean isDelayDispatchUntilContent() {
        return this._delayDispatchUntilContent;
    }

    public void setCustomizers(List<Customizer> customizers) {
        this._customizers.clear();
        this._customizers.addAll(customizers);
    }

    public void setOutputBufferSize(int outputBufferSize) {
        this._outputBufferSize = outputBufferSize;
        this.setOutputAggregationSize(outputBufferSize / 4);
    }

    public void setOutputAggregationSize(int outputAggregationSize) {
        this._outputAggregationSize = outputAggregationSize;
    }

    public void setRequestHeaderSize(int requestHeaderSize) {
        this._requestHeaderSize = requestHeaderSize;
    }

    public void setResponseHeaderSize(int responseHeaderSize) {
        this._responseHeaderSize = responseHeaderSize;
    }

    public void setHeaderCacheSize(int headerCacheSize) {
        this._headerCacheSize = headerCacheSize;
    }

    public void setSecurePort(int securePort) {
        this._securePort = securePort;
    }

    public void setSecureScheme(String secureScheme) {
        this._secureScheme = secureScheme;
    }

    public String toString() {
        return String.format("%s@%x{%d/%d,%d/%d,%s://:%d,%s}", this.getClass().getSimpleName(), this.hashCode(), this._outputBufferSize, this._outputAggregationSize, this._requestHeaderSize, this._responseHeaderSize, this._secureScheme, this._securePort, this._customizers);
    }

    public static interface ConnectionFactory {
        public HttpConfiguration getHttpConfiguration();
    }

    public static interface Customizer {
        public void customize(Connector var1, HttpConfiguration var2, Request var3);
    }
}

