/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.session;

import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.session.AbstractSession;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.session.AbstractSessionIdManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HashSessionIdManager
extends AbstractSessionIdManager {
    private final Map<String, Set<WeakReference<HttpSession>>> _sessions = new HashMap<String, Set<WeakReference<HttpSession>>>();

    public HashSessionIdManager() {
    }

    public HashSessionIdManager(Random random) {
        super(random);
    }

    public Collection<String> getSessions() {
        return Collections.unmodifiableCollection(this._sessions.keySet());
    }

    public Collection<HttpSession> getSession(String id) {
        ArrayList<HttpSession> sessions = new ArrayList<HttpSession>();
        Set<WeakReference<HttpSession>> refs = this._sessions.get(id);
        if (refs != null) {
            for (WeakReference<HttpSession> ref : refs) {
                HttpSession session = (HttpSession)ref.get();
                if (session == null) continue;
                sessions.add(session);
            }
        }
        return sessions;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this._sessions.clear();
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean idInUse(String id) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            return this._sessions.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(HttpSession session) {
        String id = this.getClusterId(session.getId());
        WeakReference<HttpSession> ref = new WeakReference<HttpSession>(session);
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            Set<WeakReference<HttpSession>> sessions = this._sessions.get(id);
            if (sessions == null) {
                sessions = new HashSet<WeakReference<HttpSession>>();
                this._sessions.put(id, sessions);
            }
            sessions.add(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(HttpSession session) {
        String id = this.getClusterId(session.getId());
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            Collection sessions = this._sessions.get(id);
            if (sessions != null) {
                Iterator iter2 = sessions.iterator();
                while (iter2.hasNext()) {
                    WeakReference ref = (WeakReference)iter2.next();
                    HttpSession s = (HttpSession)ref.get();
                    if (s == null) {
                        iter2.remove();
                        continue;
                    }
                    if (s != session) continue;
                    iter2.remove();
                    break;
                }
                if (sessions.isEmpty()) {
                    this._sessions.remove(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll(String id) {
        Collection sessions;
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            sessions = this._sessions.remove(id);
        }
        if (sessions != null) {
            for (WeakReference ref : sessions) {
                AbstractSession session = (AbstractSession)ref.get();
                if (session == null || !session.isValid()) continue;
                session.invalidate();
            }
            sessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewSessionId(String oldClusterId, String oldNodeId, HttpServletRequest request) {
        String newClusterId = this.newSessionId(request.hashCode());
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            Set<WeakReference<HttpSession>> sessions = this._sessions.remove(oldClusterId);
            if (sessions != null) {
                for (WeakReference<HttpSession> ref : sessions) {
                    HttpSession s = (HttpSession)ref.get();
                    if (s == null || !(s instanceof AbstractSession)) continue;
                    AbstractSession abstractSession = (AbstractSession)s;
                    abstractSession.getSessionManager().renewSessionId(oldClusterId, oldNodeId, newClusterId, this.getNodeId(newClusterId, request));
                }
                this._sessions.put(newClusterId, sessions);
            }
        }
    }
}

