/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util;

import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.Callback;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.log.Log;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.log.Logger;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.thread.NonBlockingThread;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class SharedBlockingCallback {
    static final Logger LOG = Log.getLogger(SharedBlockingCallback.class);
    final ReentrantLock _lock = new ReentrantLock();
    final Condition _idle = this._lock.newCondition();
    final Condition _complete = this._lock.newCondition();
    private static Throwable IDLE = new Throwable(){

        @Override
        public String toString() {
            return "IDLE";
        }
    };
    private static Throwable SUCCEEDED = new Throwable(){

        @Override
        public String toString() {
            return "SUCCEEDED";
        }
    };
    private static Throwable FAILED = new Throwable(){

        @Override
        public String toString() {
            return "FAILED";
        }
    };
    Blocker _blocker = new Blocker();

    protected long getIdleTimeout() {
        return -1L;
    }

    public Blocker acquire() throws IOException {
        this._lock.lock();
        long idle = this.getIdleTimeout();
        try {
            while (this._blocker._state != IDLE) {
                if (idle > 0L && idle < 0x3FFFFFFFFFFFFFFFL) {
                    if (this._idle.await(idle * 2L, TimeUnit.MILLISECONDS)) continue;
                    throw new IOException(new TimeoutException());
                }
                this._idle.await();
            }
            this._blocker._state = null;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this._lock.unlock();
        }
        return this._blocker;
    }

    protected void notComplete(Blocker blocker) {
        LOG.warn("Blocker not complete {}", blocker);
        if (LOG.isDebugEnabled()) {
            LOG.debug(new Throwable());
        }
    }

    private static class BlockerTimeoutException
    extends TimeoutException {
        private BlockerTimeoutException() {
        }
    }

    public class Blocker
    implements Callback,
    Closeable {
        Throwable _state = SharedBlockingCallback.access$000();

        protected Blocker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void succeeded() {
            block4: {
                SharedBlockingCallback.this._lock.lock();
                try {
                    if (this._state == null) {
                        this._state = SUCCEEDED;
                        SharedBlockingCallback.this._complete.signalAll();
                        break block4;
                    }
                    throw new IllegalStateException(this._state);
                }
                finally {
                    SharedBlockingCallback.this._lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable cause) {
            block4: {
                SharedBlockingCallback.this._lock.lock();
                try {
                    if (this._state == null) {
                        this._state = cause == null ? FAILED : (cause instanceof BlockerTimeoutException ? new IOException(cause) : cause);
                        SharedBlockingCallback.this._complete.signalAll();
                        break block4;
                    }
                    throw new IllegalStateException(this._state);
                }
                finally {
                    SharedBlockingCallback.this._lock.unlock();
                }
            }
        }

        public void block() throws IOException {
            if (NonBlockingThread.isNonBlockingThread()) {
                LOG.warn("Blocking a NonBlockingThread: ", new Throwable());
            }
            SharedBlockingCallback.this._lock.lock();
            long idle = SharedBlockingCallback.this.getIdleTimeout();
            try {
                while (this._state == null) {
                    if (idle > 0L && idle < 0x3FFFFFFFFFFFFFFFL) {
                        if (SharedBlockingCallback.this._complete.await(idle + idle / 2L, TimeUnit.MILLISECONDS)) continue;
                        this._state = new BlockerTimeoutException();
                        continue;
                    }
                    SharedBlockingCallback.this._complete.await();
                }
                if (this._state == SUCCEEDED) {
                    return;
                }
                try {
                    if (this._state == IDLE) {
                        throw new IllegalStateException("IDLE");
                    }
                    if (this._state instanceof IOException) {
                        throw (IOException)this._state;
                    }
                    if (this._state instanceof CancellationException) {
                        throw (CancellationException)this._state;
                    }
                    if (this._state instanceof RuntimeException) {
                        throw (RuntimeException)this._state;
                    }
                    if (this._state instanceof Error) {
                        throw (Error)this._state;
                    }
                    throw new IOException(this._state);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
            finally {
                SharedBlockingCallback.this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            SharedBlockingCallback.this._lock.lock();
            try {
                if (this._state == IDLE) {
                    throw new IllegalStateException("IDLE");
                }
                if (this._state == null) {
                    SharedBlockingCallback.this.notComplete(this);
                }
            }
            finally {
                try {
                    if (this._state instanceof BlockerTimeoutException) {
                        SharedBlockingCallback.this._blocker = new Blocker();
                    } else {
                        this._state = IDLE;
                    }
                    SharedBlockingCallback.this._idle.signalAll();
                    SharedBlockingCallback.this._complete.signalAll();
                }
                finally {
                    SharedBlockingCallback.this._lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            SharedBlockingCallback.this._lock.lock();
            try {
                String string = String.format("%s@%x{%s}", Blocker.class.getSimpleName(), this.hashCode(), this._state);
                return string;
            }
            finally {
                SharedBlockingCallback.this._lock.unlock();
            }
        }
    }
}

