/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.sqlline;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class OutputFile {
    final File file;
    final PrintWriter out;

    public OutputFile(String filename) throws IOException {
        filename = OutputFile.expand(filename);
        this.file = new File(filename);
        this.out = new PrintWriter((Writer)new FileWriter(this.file), true);
    }

    private static String expand(String filename) {
        if (filename.startsWith("~" + File.separator)) {
            try {
                String home = System.getProperty("user.home");
                if (home != null) {
                    return home + filename.substring(1);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return filename;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public void addLine(String command) {
        this.out.println(command);
    }

    public void print(String command) {
        this.out.print(command);
    }

    public void close() throws IOException {
        this.out.close();
    }
}

