/*
 * Copyright Alibaba Group Holding Ltd.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.hbase.client;

import com.alibaba.lindorm.client.SystemService;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AliHBaseUEClientService
    implements ClientProtos.ClientService.BlockingInterface {

  private static final Logger LOG = LoggerFactory.getLogger(AliHBaseUEClientService.class);

  public static boolean isTest;

  private SystemService systemService;

  public AliHBaseUEClientService(AliHBaseUEConnection connection) {
    AliHBaseDirectImplFactory factory = (AliHBaseDirectImplFactory) connection
        .getFactory();
    try {
      this.systemService = factory.getSystemService();
    } catch (IOException e) {
      throw new UnsupportedOperationException("Create systemService exception ",
          e);
    }
  }

  @Override
  public ClientProtos.MutateResponse mutate(RpcController rpcController,
      ClientProtos.MutateRequest mutateRequest) throws ServiceException {
    throw new UnsupportedOperationException(
        "mutate(rpcController,mutateRequest) " + "not supported");
  }

  @Override
  public ClientProtos.ScanResponse scan(RpcController rpcController,
      ClientProtos.ScanRequest scanRequest) throws ServiceException {
    throw new UnsupportedOperationException(
        "scan(rpcController,scanRequest) " + "not supported");
  }

  @Override
  public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(
      RpcController rpcController,
      ClientProtos.BulkLoadHFileRequest bulkLoadHFileRequest)
      throws ServiceException {

    checkBulkLoadSupported(bulkLoadHFileRequest);

    List<ClientProtos.BulkLoadHFileRequest.FamilyPath> paths = bulkLoadHFileRequest
        .getFamilyPathList();

    List<Pair<byte[], String>> familyPaths = new ArrayList<>(paths.size());

    for (ClientProtos.BulkLoadHFileRequest.FamilyPath fp : paths) {
      familyPaths.add(new Pair<>(fp.getFamily().toByteArray(), fp.getPath()));
    }


    try {
      byte[][] regionInfos = HRegionInfo
          .parseRegionName(bulkLoadHFileRequest.getRegion().getValue().toByteArray());
      TableName tb = TableName.valueOf(regionInfos[0]);

      boolean bulkloadResult = systemService
          .bulkLoadLdFiles(systemService.getLConnection().getAllIDC().get(0),
              tb.getNamespaceAsString(), tb.getQualifierAsString(),
              regionInfos[1], familyPaths);
      if (!bulkloadResult) {
        throw new IOException("Bulkload region fail: " + Bytes.toStringBinary(
            bulkLoadHFileRequest.getRegion().getValue().toByteArray()));
      }

    } catch (Exception e) {
      e.printStackTrace();
      LOG.error("BulkLoad exception ", e);
      throw new ServiceException("BulkLoad exception ", e);
    }

    ClientProtos.BulkLoadHFileResponse.Builder builder = ClientProtos.BulkLoadHFileResponse
        .newBuilder();
    builder.setLoaded(true);

    return builder.build();
  }

  /**
   * Check if bulkLoad request supported
   * @param bulkLoadHFileRequest
   */
  private void checkBulkLoadSupported(
      ClientProtos.BulkLoadHFileRequest bulkLoadHFileRequest) {

    List<String> allIdcs = systemService.getLConnection().getAllIDC();

    if (allIdcs.size() > 1 && !isTest) {
      throw new IllegalStateException("BulkLoad only support single idc now"
          + " , current cluster idc count : " + allIdcs.size());
    }

  }

  @Override
  public ClientProtos.CoprocessorServiceResponse execService(
      RpcController rpcController,
      ClientProtos.CoprocessorServiceRequest coprocessorServiceRequest)
      throws ServiceException {
    throw new UnsupportedOperationException(
        "execService(rpcController,coprocessorServiceRequest) "
            + "not supported");
  }

  @Override
  public ClientProtos.CoprocessorServiceResponse execRegionServerService(
      RpcController rpcController,
      ClientProtos.CoprocessorServiceRequest coprocessorServiceRequest)
      throws ServiceException {
    throw new UnsupportedOperationException(
        "execRegionServerService(rpcController,coprocessorServiceRequest) "
            + "not supported");
  }

  @Override
  public ClientProtos.MultiResponse multi(RpcController rpcController,
      ClientProtos.MultiRequest multiRequest) throws ServiceException {
    throw new UnsupportedOperationException(
        "multi(rpcController,multiRequest) " + "not supported");
  }

  @Override
  public ClientProtos.GetResponse get(RpcController rpcController,
      ClientProtos.GetRequest getRequest) throws ServiceException {
    throw new UnsupportedOperationException(
        "get(rpcController,getRequest) " + "not supported");
  }



}
