package com.alibaba.hbase.haclient;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

public class ConnectInfo {
  private List<String> watchZkList = null;
  private ConnectConf connectConf = null;
  private String zkClusterKey = null;

  public String getZkClusterKey() {
    return zkClusterKey;
  }

  public void setZkClusterKey(String zkClusterKey) {
    this.zkClusterKey = zkClusterKey;
  }

  public ConnectInfo(List<String> watchZkList, String active, String standby){
    this.watchZkList = watchZkList;
    this.connectConf = new ConnectConf(active, standby);
  }

  public ConnectInfo(List<String> watchZkList, String active, String standby, String zkClusterKey){
    this.watchZkList = watchZkList;
    this.connectConf = new ConnectConf(active, standby);
    this.zkClusterKey = zkClusterKey;
  }

  public List<String> getWatchZkList() {
    return watchZkList;
  }

  public void setWatchZkList(List<String> watchZkList) {
    this.watchZkList = watchZkList;
  }

  public ConnectConf getConnectConf() {
    return connectConf;
  }

  public void setConnectConf(ConnectConf connectConf) {
    this.connectConf = connectConf;
  }

  public class ConnectConf{
     private String active;
     private String standby;

     public ConnectConf(String active, String standby){
       this.active = active;
       this.standby = standby;
     }

     public String getActive() {
       return active;
     }

     public void setActive(String active) {
       this.active = active;
     }

     public String getStandby() {
       return standby;
     }

     public void setStandby(String standby) {
       this.standby = standby;
     }
  }

  /**
   * get master watch zk
   * @return String
   */
  public String getMasterWatchZK(){
    return this.getWatchZkList().get(0);
  }

  /**
   * get slave watch zk list
   * @return List<String>
   */
  public List<String> getSlaveWatchZKList(){
    List<String> watchZkList = this.getWatchZkList();
    List<String> slaveWatchZkList = new ArrayList<>();
    for (int i = 1; i < watchZkList.size(); i++) {
      slaveWatchZkList.add(watchZkList.get(i));
    }
    return slaveWatchZkList;
  }

  /**
   * get active connect key
   * @return String
   */
  public String getActiveConnectKey(){
    return this.getConnectConf().getActive();
  }

  /**
   * get standby connect key
   * @return String
   */
  public String getStandbyConnectKey(){
    return this.getConnectConf().getStandby();
  }

  /**
   * to string
   * @return String
   */
  public String toString(){
    StringBuilder sb = new StringBuilder();
    sb.append("ConnectInfo::watchZKList(");
    sb.append(StringUtils.join(this.watchZkList.toArray(new String[0]), ","));
    sb.append("),");
    if(this.connectConf != null){
      sb.append("ConnectInfo::ConnectConf::active(");
      sb.append(this.getConnectConf().getActive());
      sb.append("),");
      sb.append("ConnectInfo::ConnectConf::standby(");
      sb.append(this.getConnectConf().getStandby());
      sb.append("),");
    }
    sb.append("ConnectInfo::zkClusterKey(");
    sb.append(this.zkClusterKey);
    sb.append(")");
    return sb.toString();
  }
}