package com.alibaba.hbase.haclient.dualservice;

import java.util.List;
import java.util.concurrent.Callable;

import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;

public class DualCallable<T, V> implements Callable<T> {

  private DualContext<T> context;

  private HTable htable;

  private V action;

  private DualExecutor.ActionType actionType;

  private DualExecutor.Role role;

  public DualCallable(DualContext<T> context, HTable htable, V action,
                      DualExecutor.ActionType actionType, DualExecutor.Role role){
    this.context = context;
    this.htable = htable;
    this.action = action;
    this.actionType = actionType;
    this.role = role;
  }

  @Override
  public T call() throws Exception {
    try{
      T result = null;
      switch(actionType){
        case GET:
          result = (T)this.htable.get((Get) action);
          break;
        case PUT:
          this.htable.put((Put) action);
          break;
        case DELETE:
          this.htable.delete((Delete) action);
          break;
        case BATCHGET:
          result = (T)this.htable.get((List<Get>) action);
          break;
        case BATCHPUT:
          this.htable.put((List<Put>) action);
          break;
        case BATCHDELETE:
          this.htable.delete((List<Delete>) action);
          break;
      }
      if(role == DualExecutor.Role.ACTIVE){
        this.context.onActiveComplete(result);
      }else{
        this.context.onStandbyComplete(result);
      }
      return result;
    }catch(Throwable t){
      if(role == DualExecutor.Role.ACTIVE){
        this.context.onActiveError(t);
      }else{
        this.context.onStandbyError(t);
      }
    }
    return null;
  }
}