package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;

import com.alibaba.hbase.client.AliHBaseConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;

public class AliHBaseMultiBufferedMutator extends BufferedMutatorImpl implements BufferedMutator{
  private static final Log LOG = LogFactory.getLog(AliHBaseMultiBufferedMutator.class);

  private volatile BufferedMutator currentBufferedMutator = null;
  //switch count decide switch or not
  private long switchCount = 0;
  private AliHBaseMultiClusterConnection connection;
  private BufferedMutatorParams params;
  private AliHBaseConstants.ClusterType currentType;

  public AliHBaseMultiBufferedMutator(AliHBaseMultiClusterConnection connection,
                                      BufferedMutator bufferedMutator, BufferedMutatorParams params){
    super(connection, null, null, params);
    this.currentBufferedMutator = bufferedMutator;
    this.connection = connection;
    this.params = params;
    this.currentType =
      AliHBaseConstants.ClusterType.valueOf(connection.getConfiguration().get(AliHBaseConstants.ALIHBASE_CLUSTER_TYPE));
    this.switchCount = connection.getSwitchCount();
  }

  private BufferedMutator getCurrentBufferedMutator() throws IOException{
    if(this.switchCount < connection.getSwitchCount()){
      AliHBaseConstants.ClusterType clusterType =
        AliHBaseConstants.ClusterType.valueOf(this.connection.getConfiguration().get(AliHBaseConstants.ALIHBASE_CLUSTER_TYPE));
      //only HBase to HBase no need update BufferedMutator
      if(!(this.currentType == AliHBaseConstants.ClusterType.HBASE && clusterType == AliHBaseConstants.ClusterType.HBASE)) {
        BufferedMutator newBufferedMutator = connection.getBufferedMutatorByType(params);
        BufferedMutator lastBufferedMutator = this.currentBufferedMutator;
        this.currentBufferedMutator = newBufferedMutator;
        if (lastBufferedMutator != null) {
          try {
            lastBufferedMutator.close();
          } catch (IOException e) {
            LOG.warn("last buffered mutator close failed" + e);
          }
        }
      }
      this.currentType = clusterType;
      this.switchCount = connection.getSwitchCount();
    }
    return this.currentBufferedMutator;
  }

  @Override
  public TableName getName(){
    return this.params.getTableName();
  };

  public Configuration getConfiguration(){
    return this.currentBufferedMutator.getConfiguration();
  };

  public synchronized void mutate(Mutation mutation)throws InterruptedIOException,
    RetriesExhaustedWithDetailsException {
    try {
      this.getCurrentBufferedMutator().mutate(mutation);
    }catch(InterruptedIOException e){
      throw e;
    }catch(RetriesExhaustedWithDetailsException e){
      throw e;
    }catch(IOException e) {
      LOG.error(" mutate failed : " + e);
    }
  }

  public synchronized  void mutate(List<? extends Mutation> list)throws InterruptedIOException, RetriesExhaustedWithDetailsException{
    try {
      this.getCurrentBufferedMutator().mutate(list);
    }catch(InterruptedIOException e){
      throw e;
    }catch(RetriesExhaustedWithDetailsException e){
      throw e;
    }catch(IOException e){
      LOG.error(" mutate list failed : " + e);
    }
  }

  public synchronized  void close() throws IOException{
    this.getCurrentBufferedMutator().close();
  }

  public synchronized void flush() throws InterruptedIOException, RetriesExhaustedWithDetailsException{
    try {
      this.getCurrentBufferedMutator().flush();
    }catch(InterruptedIOException e){
      throw e;
    }catch(RetriesExhaustedWithDetailsException e){
      throw e;
    }catch(IOException e){
      LOG.error(" flush failed : " + e);
    }
  }

  public long getWriteBufferSize(){
    return this.params.getWriteBufferSize();
  }

}


