/*
 * Copyright Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.hbase.client;

import java.io.IOException;

import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;

public class NoopRegistry implements Registry {

  @Override
  public void init(Connection connection) {

  }

  @Override
  public RegionLocations getMetaRegionLocation() throws IOException {
    return null;
  }

  @Override
  public String getClusterId() {
    return "fake";
  }

  @Override
  public boolean isTableOnlineState(TableName tableName, boolean b) throws IOException {
    return false;
  }

  @Override
  public int getCurrentNrHRS() throws IOException {
    return 0;
  }
}
