/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseUEConnection;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliHBaseUEBufferedMutator
implements BufferedMutator {
    private static final Logger LOG = LoggerFactory.getLogger(AliHBaseUEBufferedMutator.class);
    private final TableName tableName;
    private AliHBaseUEConnection connection;
    private volatile long writeBufferSize;
    private long currentWriteBufferSize;
    private volatile boolean clearBufferOnFail;
    private final ConcurrentLinkedQueue<Mutation> writeBuffer;
    private Table table;

    public AliHBaseUEBufferedMutator(AliHBaseUEConnection connection, TableName tableName) throws IOException {
        this.tableName = tableName;
        this.connection = connection;
        this.writeBuffer = new ConcurrentLinkedQueue();
        this.writeBufferSize = this.connection.getConfiguration().getLong("hbase.client.write.buffer", 0x200000L);
        this.currentWriteBufferSize = 0L;
        this.clearBufferOnFail = this.connection.getConfiguration().getBoolean("hbase.client.bufferedmutator.clearbufferonfail", true);
        this.table = connection.getTable(tableName);
    }

    public TableName getName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.connection.getConfiguration();
    }

    public void mutate(Mutation mutation) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.mutate(Collections.singletonList(mutation));
    }

    public void mutate(List<? extends Mutation> list) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        ArrayList<Put> flushPuts = new ArrayList<Put>();
        ArrayList<Delete> flushDeletes = new ArrayList<Delete>();
        for (Mutation mutation : list) {
            this.writeBuffer.add(mutation);
            this.currentWriteBufferSize += mutation.heapSize();
        }
        try {
            if (this.currentWriteBufferSize >= this.writeBufferSize) {
                this.extractOMutation(flushPuts, flushDeletes);
            }
            this.flush(flushPuts, flushDeletes);
        }
        catch (IOException e) {
            LOG.error("Mutate exception ", (Throwable)e);
            throw new InterruptedIOException(e.getMessage());
        }
    }

    public void setWriteBufferSize(long writeBufferSize) throws RetriesExhaustedWithDetailsException, InterruptedIOException {
        this.writeBufferSize = writeBufferSize;
        if (this.currentWriteBufferSize > writeBufferSize) {
            this.flush();
        }
    }

    private void extractOMutation(List<Put> flushPuts, List<Delete> flushDeletes) throws IOException {
        for (Mutation mutation : this.writeBuffer) {
            if (mutation instanceof Put) {
                flushPuts.add((Put)mutation);
                continue;
            }
            if (mutation instanceof Delete) {
                flushDeletes.add((Delete)mutation);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported mutation type " + mutation.getClass());
        }
        this.writeBuffer.clear();
        this.currentWriteBufferSize = 0L;
    }

    private void flush(List<Put> flushPuts, List<Delete> flushDeletes) throws IOException {
        if (!flushPuts.isEmpty()) {
            this.commitPuts(flushPuts);
        }
        if (!flushDeletes.isEmpty()) {
            this.commitDeletes(flushDeletes);
        }
    }

    public void close() throws IOException {
        this.flush();
        this.table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        ArrayList<Put> flushPuts = new ArrayList<Put>();
        ArrayList<Delete> flushDeletes = new ArrayList<Delete>();
        try {
            ConcurrentLinkedQueue<Mutation> concurrentLinkedQueue = this.writeBuffer;
            synchronized (concurrentLinkedQueue) {
                this.extractOMutation(flushPuts, flushDeletes);
            }
            this.flush(flushPuts, flushDeletes);
        }
        catch (IOException e) {
            LOG.error("Flush exception ", (Throwable)e);
            throw new InterruptedIOException(e.getMessage());
        }
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setClearBufferOnFail(boolean clearBufferOnFail) {
        this.clearBufferOnFail = clearBufferOnFail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPuts(List<Put> puts) throws IOException {
        boolean flushSuccessfully = false;
        try {
            this.table.put(puts);
            flushSuccessfully = true;
        }
        finally {
            if (!flushSuccessfully && !this.clearBufferOnFail) {
                ConcurrentLinkedQueue<Mutation> concurrentLinkedQueue = this.writeBuffer;
                synchronized (concurrentLinkedQueue) {
                    for (Put put2 : puts) {
                        this.writeBuffer.add((Mutation)put2);
                        this.currentWriteBufferSize += put2.heapSize();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitDeletes(List<Delete> deletes) throws IOException {
        boolean flushSuccessfully = false;
        try {
            this.table.delete(deletes);
            flushSuccessfully = true;
        }
        finally {
            if (!flushSuccessfully && !this.clearBufferOnFail) {
                ConcurrentLinkedQueue<Mutation> concurrentLinkedQueue = this.writeBuffer;
                synchronized (concurrentLinkedQueue) {
                    for (Delete delete : deletes) {
                        this.writeBuffer.add((Mutation)delete);
                        this.currentWriteBufferSize += delete.heapSize();
                    }
                }
            }
        }
    }
}

