/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.util.Bytes;

public class DualContext<T> {
    private volatile T activeResult;
    private volatile T standbyResult;
    private Throwable activeError;
    private Throwable standbyError;
    private CountDownLatch countDown = new CountDownLatch(1);
    private final int glitchTimeout;
    private final int operationTimeout;
    private byte[] tableName;
    private long start;
    private volatile boolean hasValue = false;
    private Boolean usePrimaryAsResult = null;

    public DualContext(byte[] tableName, int glitchTimeout, int operationTimeout) {
        this.glitchTimeout = glitchTimeout;
        this.operationTimeout = operationTimeout;
        this.tableName = tableName;
    }

    public void onActiveComplete(T result) {
        this.activeResult = result;
        this.hasValue = true;
        this.countDown.countDown();
    }

    public void onStandbyComplete(T result) {
        this.standbyResult = result;
        this.hasValue = true;
        this.countDown.countDown();
    }

    public synchronized void onActiveError(Throwable error) {
        this.activeError = error;
        if (this.standbyError != null) {
            this.countDown.countDown();
        }
    }

    public synchronized void onStandbyError(Throwable error) {
        this.standbyError = error;
        if (this.activeError != null) {
            this.countDown.countDown();
        }
    }

    public T getResult() throws IOException {
        if (this.hasValue) {
            if (this.activeResult != null) {
                this.usePrimaryAsResult = true;
                return this.activeResult;
            }
            if (this.standbyResult != null) {
                this.usePrimaryAsResult = false;
                return this.standbyResult;
            }
            return null;
        }
        if (this.activeError == null) {
            this.activeError = new CallTimeoutException("OperationTimeout");
        }
        if (this.standbyError == null) {
            this.standbyError = new CallTimeoutException("OperationTimeout");
        }
        long now = System.currentTimeMillis();
        String msg = "Failed exectuing dual operation for table " + Bytes.toString((byte[])this.tableName) + " with active error=" + this.activeError.getMessage() + " and with standby error=" + this.standbyError.getMessage() + ", timeout=" + this.operationTimeout + ", wait=" + (now - this.start);
        throw new IOException(msg, this.activeError);
    }

    public T getResultInGlitchTimeout() throws IOException {
        try {
            if (this.countDown.await(this.glitchTimeout, TimeUnit.MILLISECONDS)) {
                this.usePrimaryAsResult = true;
                return this.activeResult;
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return null;
    }

    public void waitOperationTimeout() throws IOException {
        try {
            long remaining = 0L;
            remaining = Math.max(0L, (long)this.operationTimeout + this.start - System.currentTimeMillis());
            this.countDown.await(remaining += 10L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public Boolean usePrimaryAsResult() {
        return this.usePrimaryAsResult;
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }
}

