/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.hbase.haclient.ClusterSwitchUtil;
import com.alibaba.hbase.protobuf.generated.ClusterSwitchProto;
import com.google.protobuf.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class DualTableUtil {
    private static Log LOG = LogFactory.getLog(DualTableUtil.class);
    public static final String DUALTABLE_DIR = "hbase.haclient.dualtable.dir";
    public static final String DUALTABLE_DIR_DEFATULT = "/alihbase/dualtable/";
    public static final String DUALTABLE_FILE = "hbase.haclient.dualtable.filename";
    public static final String DUALTABLE_FILE_DEFAULT = "dualtable.xml";
    public static final String DUAL_TABLE = "hbase.haclient.dual.table";

    public static List<String> toDualTables(byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        try {
            ProtobufUtil.expectPBMagicPrefix((byte[])data);
            int prefixLen = ProtobufUtil.lengthOfPBMagic();
            ClusterSwitchProto.DualTable.Builder builder = ClusterSwitchProto.DualTable.newBuilder();
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)prefixLen, (int)(data.length - prefixLen));
            ClusterSwitchProto.DualTable dualTable = builder.build();
            List<String> dualTables = dualTable.getTableListList();
            return dualTables;
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getDualTablesFromZK(String endpoint, Configuration clientConf) throws IOException, KeeperException {
        Configuration conf = new Configuration();
        if (!ClusterSwitchUtil.isValidEndpoint(endpoint)) {
            throw new IOException("Endpoint " + endpoint + " has invalid format, vaild format is hostname:port");
        }
        conf.set("hbase.zookeeper.quorum", endpoint.split(":")[0]);
        conf.set("hbase.zookeeper.property.clientPort", endpoint.split(":")[1]);
        try (ZooKeeperWatcher zk = new ZooKeeperWatcher(conf, "GetCommand", null, false);){
            List<String> dualTables;
            String baseNode = ClusterSwitchUtil.getBaseNode(clientConf.get("haclient.base.node", "/haclient"), clientConf.get("haclient.cluster.id"));
            if (ZKUtil.checkExists((ZooKeeperWatcher)zk, (String)baseNode) == -1) {
                ArrayList<String> arrayList = new ArrayList<String>();
                return arrayList;
            }
            String dualTableNode = ZKUtil.joinZNode((String)baseNode, (String)clientConf.get(ClusterSwitchUtil.ZOOKEEPER_DUAL_TABLE_NODE, ClusterSwitchUtil.ZOOKEEPER_DUAL_TABLE_NODE_DEFAULT));
            if (ZKUtil.checkExists((ZooKeeperWatcher)zk, (String)dualTableNode) == -1) {
                throw new IOException("dualTableNode " + dualTableNode + " is not exist");
            }
            byte[] data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zk, (String)dualTableNode, null);
            List<String> list = dualTables = DualTableUtil.toDualTables(data);
            return list;
        }
    }

    public static List<String> getDualTablesFromXML(Configuration conf) {
        return DualTableUtil.getDualTablesFromXML(System.getProperty("user.home") + conf.get(DUALTABLE_DIR, DUALTABLE_DIR_DEFATULT) + conf.get(DUALTABLE_FILE, DUALTABLE_FILE_DEFAULT));
    }

    public static List<String> getDualTablesFromXML(String file) {
        try {
            Configuration conf = new Configuration();
            conf.addResource(new Path(file));
            String dualTablesString = conf.get(DUAL_TABLE, null);
            if (dualTablesString == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> dualTables = new ArrayList<String>(Arrays.asList(StringUtils.split((String)dualTablesString, (String)",")));
            return dualTables;
        }
        catch (Exception e) {
            LOG.error((Object)("Get dual tables from xml failed, " + e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushDualTables(List<String> dualTables, Configuration clientConf) {
        if (dualTables == null || dualTables.isEmpty()) {
            return;
        }
        Configuration conf = new Configuration();
        conf.clear();
        conf.set(DUAL_TABLE, StringUtils.join(dualTables, (String)","));
        String dirName = System.getProperty("user.home") + clientConf.get(DUALTABLE_DIR, DUALTABLE_DIR_DEFATULT);
        String fileName = dirName + clientConf.get(DUALTABLE_FILE, DUALTABLE_FILE_DEFAULT);
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream out = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            out = new FileOutputStream(file);
            conf.writeXml((OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            LOG.warn((Object)("flush dual tables failed : " + e));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                LOG.debug((Object)"flush dual tables FileOutputStream close failed");
            }
        }
    }

    public static byte[] toDualTablesBytes(List<String> dualTables) {
        ClusterSwitchProto.DualTable.Builder builder = ClusterSwitchProto.DualTable.newBuilder();
        for (String dualTable : dualTables) {
            builder.addTableList(dualTable);
        }
        return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
    }
}

