/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.ipc.ConfigObserver;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.ipc.LConnectionManager;
import com.alibaba.lindorm.client.core.utils.ClientEnvLogUtil;
import com.alibaba.lindorm.client.core.utils.ConfigUtil;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LindormBasicService
implements ConfigObserver {
    public static final Log LOG = LogFactory.getLog(LindormBasicService.class);
    protected LConnection lconnection;
    protected LindormClientConfig config;
    protected String namespace;
    protected boolean closed;
    protected int operationTimeout;
    protected int glitchTimeout;
    protected int ddlOperationTimeout;
    protected int maxRetryDDL;
    protected int ddlPause;
    protected int systemOperationTimeout;
    protected final String serviceName;
    protected String doAsUser = null;
    protected boolean eagleeyeEnabled = false;

    public LindormBasicService() {
        this.serviceName = "test";
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LindormBasicService(LindormClientConfig config, String serviceName) throws LindormException {
        this.config = config;
        this.serviceName = serviceName;
        String timeOutKey = ConfigUtil.createServiceConfKey(serviceName, "lindorm.client.timeout");
        this.operationTimeout = config.getInt(timeOutKey, config.getInt("lindorm.client.timeout", 120000));
        String glitchKey = ConfigUtil.createServiceConfKey(serviceName, "lindorm.rpc.glitchtime");
        this.glitchTimeout = config.getInt(glitchKey, config.getInt("lindorm.rpc.glitchtime", -1));
        this.systemOperationTimeout = this.config.getInt("lindorm.client.system.timeout", 60000);
        this.ddlOperationTimeout = config.getInt("lindorm.client.ddl.timeout", 180000);
        this.maxRetryDDL = config.getInt("lindorm.client.ddl.max.retries.number", 300);
        this.ddlPause = config.getInt("lindorm.client.ddl.query.pause", 1000);
        this.namespace = config.getNamespace();
        this.eagleeyeEnabled = config.getBoolean("lindorm.client.eagleeye.enabled", false);
        this.eagleeyeEnabled = this.eagleeyeEnabled || config.getBoolean("lindorm.client.eagleeye.enabled", false);
        try {
            this.lconnection = LConnectionManager.getLConnection(config);
        }
        catch (IOException ioe) {
            String seedServer = config.getSeedServer();
            String user = config.getUser();
            LOG.error((Object)("getLConnection failed, seedServer:" + seedServer + " user:" + user), (Throwable)ioe);
            throw new LindormException(ioe);
        }
        boolean success = this.lconnection.registerService(serviceName, this);
        if (!success) {
            throw new LindormException("Duplicate service name " + serviceName);
        }
        LindormClientConfig lconnectionConfig = this.lconnection.getConfig();
        Class<LindormBasicService> clazz = LindormBasicService.class;
        synchronized (LindormBasicService.class) {
            lconnectionConfig.setInt(timeOutKey, this.operationTimeout);
            lconnectionConfig.setInt(glitchKey, this.glitchTimeout);
            // ** MonitorExit[var7_10] (shouldn't be in output)
            LOG.info((Object)("Start service " + serviceName + ", OperationTimeout " + this.operationTimeout + ", GlitchTimeout " + this.glitchTimeout));
            this.closed = false;
            return;
        }
    }

    public void checkOpen() throws LindormException {
        if (this.closed) {
            throw new LindormException("Service already closed");
        }
    }

    @Override
    public void onConfigChange(LindormClientConfig config) throws LindormException {
        this.config = config;
        String eagleeyeKey = ConfigUtil.createServiceConfKey(this.serviceName, "lindorm.client.eagleeye.enabled");
        this.eagleeyeEnabled = config.getBoolean(eagleeyeKey, config.getBoolean("lindorm.client.eagleeye.enabled", false));
        this.eagleeyeEnabled = this.eagleeyeEnabled || config.getBoolean(eagleeyeKey, config.getBoolean("lindorm.client.eagleeye.enabled", false));
        String timeOutKey = ConfigUtil.createServiceConfKey(this.serviceName, "lindorm.client.timeout");
        this.operationTimeout = config.getInt(timeOutKey, config.getInt("lindorm.client.timeout", 120000));
        String glitchKey = ConfigUtil.createServiceConfKey(this.serviceName, "lindorm.rpc.glitchtime");
        this.glitchTimeout = config.getInt(glitchKey, config.getInt("lindorm.rpc.glitchtime", -1));
        ClientEnvLogUtil.resetLoggerLevel(config);
        LOG.info((Object)("Service " + this.serviceName + "Configuration changed , timeout: " + this.operationTimeout + ", glitch " + this.glitchTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        this.lconnection.unregisterService(this.serviceName);
        String timeOutKey = ConfigUtil.createServiceConfKey(this.serviceName, "lindorm.client.timeout");
        String glitchKey = ConfigUtil.createServiceConfKey(this.serviceName, "lindorm.rpc.glitchtime");
        Class<LindormBasicService> clazz = LindormBasicService.class;
        synchronized (LindormBasicService.class) {
            this.lconnection.getConfig().remove(timeOutKey);
            this.lconnection.getConfig().remove(glitchKey);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.lconnection.close();
            return;
        }
    }

    public void doAsUser(String user) {
        this.doAsUser = user;
    }

    public String getDoAsUser() {
        return this.doAsUser;
    }

    public LConnection getLConnection() {
        return this.lconnection;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public int getGlitchTimeout() {
        return this.glitchTimeout;
    }
}

