/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.meta.Tuple;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.SimpleConditionParser;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RowComparisonExpression
extends Condition {
    private Row row;
    private ConditionFactory.CompareOp op;

    public RowComparisonExpression() {
    }

    public RowComparisonExpression(Row row, ConditionFactory.CompareOp op) {
        this.row = row;
        this.op = op;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        this.row.writeTo(out);
        WritableUtils.writeVInt(out, this.op.ordinal());
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.row = new Row();
        this.row.readFrom(in);
        this.op = ConditionFactory.CompareOp.values()[WritableUtils.readVInt(in)];
    }

    @Override
    public String toString() {
        return String.format("((%s) %s (%s))", this.getColumnsAsString(), Bytes.toString(SimpleConditionParser.convertCompareOpToByteArray(this.op)), this.getValuesAsString());
    }

    @Override
    public String toParseableString() {
        return String.format("%s((%s) %s (%s))", "EXP", this.getColumnsAsString(), Bytes.toString(SimpleConditionParser.convertCompareOpToByteArray(this.op)), this.getValuesAsString());
    }

    private String getColumnsAsString() {
        StringBuilder builder = new StringBuilder();
        for (ColumnValue columnValue : this.row.getColumnValues()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(Bytes.toString(columnValue.getFullName()));
        }
        return builder.toString();
    }

    private String getValuesAsString() {
        StringBuilder builder = new StringBuilder();
        for (ColumnValue columnValue : this.row.getColumnValues()) {
            DataType type;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            if ((type = columnValue.getType()) == DataType.STRING) {
                builder.append("'");
                builder.append(columnValue.getValueObject().toString());
                builder.append("'");
                continue;
            }
            builder.append(columnValue.getValueObject().toString());
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RowComparisonExpression)) {
            return false;
        }
        RowComparisonExpression other = (RowComparisonExpression)obj;
        return this.row.equals(other.row) && this.op.equals((Object)other.op);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesPtr result) throws LindormException {
        throw new LindormException("Row comparison expression can not be evaluated");
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        return visitor.visit(this);
    }

    @Override
    public void reset() {
    }

    public Row getRow() {
        return this.row;
    }

    public ConditionFactory.CompareOp getOp() {
        return this.op;
    }
}

