/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.ExternalIndexRowFormatterType;
import com.alibaba.lindorm.client.core.meta.ExternalIndexType;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ExternalIndexConfig
extends VersionedObjectWithAttributes {
    private static final String CONFIGPREFIX = "__config__.";
    private String targetIndexName;
    private ExternalIndexType indexType = ExternalIndexType.SOLR;
    private ExternalIndexRowFormatterType rowFormatterType = ExternalIndexRowFormatterType.STRING;

    public void addExtraConfig(String key, String value) {
        Preconditions.checkArgument(!StringUtils.isNullOrEmpty(key));
        String configKey = CONFIGPREFIX + key;
        this.setAttribute(configKey, value);
    }

    public ExternalIndexConfig() {
    }

    public ExternalIndexConfig(String targetIndexName, ExternalIndexType indexType, ExternalIndexRowFormatterType rowFormatterType) {
        this.targetIndexName = targetIndexName;
        if (indexType != null) {
            this.indexType = indexType;
        }
        if (rowFormatterType != null) {
            this.rowFormatterType = rowFormatterType;
        }
    }

    public ExternalIndexConfig(String targetIndexName) {
        this(targetIndexName, ExternalIndexType.SOLR, ExternalIndexRowFormatterType.STRING);
    }

    public String getTargetIndexName() {
        return this.targetIndexName;
    }

    public ExternalIndexType getIndexType() {
        return this.indexType;
    }

    public ExternalIndexRowFormatterType getRowFormatterType() {
        return this.rowFormatterType;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.targetIndexName);
        WritableUtils.writeString(out, this.indexType.name());
        WritableUtils.writeString(out, this.rowFormatterType.name());
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.targetIndexName = WritableUtils.readString(in);
        this.indexType = ExternalIndexType.valueOf(WritableUtils.readString(in));
        this.rowFormatterType = ExternalIndexRowFormatterType.valueOf(WritableUtils.readString(in));
    }

    @Override
    public String toString() {
        return "targetIndexName=" + (this.targetIndexName == null ? "" : this.targetIndexName) + ", indexType=" + (Object)((Object)this.indexType) + ", rowFormatterType" + (Object)((Object)this.rowFormatterType);
    }
}

