/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.LindormTableService;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.ipc.ClientCompletableFuture;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.tableservice.LMutationResult;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.DataInputBuffer;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.dml.Upsert;
import com.alibaba.lindorm.client.exception.DoNotRetryIOException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;

public class LUpsert
extends DmlOperation
implements Upsert {
    private static final String WHERE_ATTR = "CONDITION";
    private static final String ROW_EXISTENCE_ATTR = "ROW_CONDITION";
    private List<Row> rows;
    private Condition where = null;
    private ConditionFactory.RowExistenceCondition rowExistenceCondition;

    public LUpsert() {
    }

    public LUpsert(LindormTableService service) {
        super(service);
    }

    @Override
    public Upsert into(String tableName) throws LindormException {
        if (this.service != null) {
            this.namespace = this.service.getNamespace();
        }
        this.tableName = tableName;
        return this;
    }

    @Override
    public Upsert add(Row row) {
        if (this.rows == null) {
            this.rows = CollectionUtils.newArrayList();
        }
        this.rows.add(row);
        return this;
    }

    @Override
    public Upsert setRows(List<Row> rows) {
        this.rows = rows;
        return this;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public Condition getWhere() {
        return this.where;
    }

    private LServerCallable<LMutationResult> buildUpsertCallable(OperationContext.OperationType operationType) {
        return new LServerCallable<LMutationResult>((DmlOperation)this, operationType){

            @Override
            public LMutationResult call() throws Exception {
                return this.server.upsert(LUpsert.this);
            }
        };
    }

    private OperationContext.OperationType getOperationType() {
        if (this.where != null) {
            return OperationContext.OperationType.CONDITIONAL_UPSERT;
        }
        return OperationContext.OperationType.UPSERT;
    }

    protected void checkResultCompatibility(Object[] results) throws IOException {
        if (results == null) {
            return;
        }
        for (int index = results.length - 1; index >= 0; --index) {
            if (results[index] instanceof VersionedObjectWithAttributes) continue;
            throw new DoNotRetryIOException("Some rows are not finished, maybe we are requesting LDServer with a older version?");
        }
    }

    @Override
    public Future<Integer> executeAsync() throws LindormException {
        final ClientCompletableFuture<Integer> future = new ClientCompletableFuture<Integer>();
        this.executeAsync(new AsyncCallback<Integer>(){

            @Override
            public void onComplete(Integer result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public void executeAsync(AsyncCallback<Integer> callback) throws LindormException {
        if (this.isEmpty()) {
            callback.onComplete(0);
            return;
        }
        this.validate();
        this.setupRouteKey();
        OperationContext.OperationType operationType = this.getOperationType();
        RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        LServerCallable<LMutationResult> upsertCallable = this.buildUpsertCallable(operationType);
        Object eagleEyeContext = this.service.startEagleeyeTraceAsync(this.tableName, operationType);
        int rows = this.getRows() == null ? 0 : this.getRows().size();
        AsyncUpsertHandler asyncUpsertHandler = new AsyncUpsertHandler(callback, operationType, System.currentTimeMillis(), rows, eagleEyeContext);
        retryingCaller.withRetriesAsync(upsertCallable, asyncUpsertHandler);
    }

    @Override
    public int execute() throws LindormException {
        if (this.isEmpty()) {
            return 0;
        }
        this.validate();
        OperationContext.OperationType operationType = this.getOperationType();
        long start = System.currentTimeMillis();
        this.service.startEagleeyeTrace(this.tableName, operationType);
        try {
            RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
            LServerCallable<LMutationResult> upsertCallable = this.buildUpsertCallable(operationType);
            this.setupRouteKey();
            LMutationResult response = retryingCaller.withRetries(upsertCallable);
            this.handleResultAttributes(this, response);
            int affectedRows = response.getNumberOfRowsAffected();
            this.checkResultCompatibility(response.getResults());
            this.service.getLConnection().getTableMetricsManager().onOperationSuccess(this.namespace, this.tableName, operationType, System.currentTimeMillis() - start, affectedRows);
            int n = affectedRows;
            return n;
        }
        catch (Throwable t) {
            String msg = this.buildErrorMsg(operationType, t, System.currentTimeMillis() - start, this.getRows() == null ? 0 : this.getRows().size());
            LindormException error = new LindormException(msg);
            this.service.getLConnection().getTableMetricsManager().onOperationError(this.namespace, this.tableName, operationType, error);
            throw error;
        }
        finally {
            this.service.endEagleeyeTrace();
        }
    }

    @Override
    public List<Object> executeWithResults() throws LindormException {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        this.validate();
        OperationContext.OperationType operationType = this.getOperationType();
        long start = System.currentTimeMillis();
        this.service.startEagleeyeTrace(this.tableName, operationType);
        try {
            RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
            LServerCallable<LMutationResult> upsertCallable = this.buildUpsertCallable(operationType);
            this.setupRouteKey();
            LMutationResult response = retryingCaller.withRetries(upsertCallable);
            this.handleResultAttributes(this, response);
            this.service.getLConnection().getTableMetricsManager().onOperationSuccess(this.namespace, this.tableName, operationType, System.currentTimeMillis() - start, this.rows.size());
            List<Object> list = Arrays.asList(response.getResults());
            return list;
        }
        catch (Throwable t) {
            String msg = this.buildErrorMsg(operationType, t, System.currentTimeMillis() - start, this.getRows() == null ? 0 : this.getRows().size());
            LindormException error = new LindormException(msg);
            this.service.getLConnection().getTableMetricsManager().onOperationError(this.namespace, this.tableName, operationType, error);
            throw error;
        }
        finally {
            this.service.endEagleeyeTrace();
        }
    }

    @Override
    public Future<List<Object>> executeWithResultsAsync() throws LindormException {
        final ClientCompletableFuture<List<Object>> future = new ClientCompletableFuture<List<Object>>();
        this.executeWithResultsAsync(new AsyncCallback<List<Object>>(){

            @Override
            public void onComplete(List<Object> result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public void executeWithResultsAsync(AsyncCallback<List<Object>> callback) throws LindormException {
        if (this.isEmpty()) {
            callback.onComplete(Collections.emptyList());
            return;
        }
        this.validate();
        this.setupRouteKey();
        OperationContext.OperationType operationType = this.getOperationType();
        RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        LServerCallable<LMutationResult> upsertCallable = this.buildUpsertCallable(operationType);
        Object eagleEyeContext = this.service.startEagleeyeTraceAsync(this.tableName, operationType);
        AsyncUpsertWithResultsHandler asyncUpsertHandler = new AsyncUpsertWithResultsHandler(callback, operationType, System.currentTimeMillis(), eagleEyeContext);
        retryingCaller.withRetriesAsync(upsertCallable, asyncUpsertHandler);
    }

    @Override
    public Upsert where(Condition condition) throws LindormException {
        this.where = condition;
        return this;
    }

    @Override
    public Upsert check(Condition condition, ConditionFactory.RowExistenceCondition rowExistenceCondition) throws LindormException {
        if (rowExistenceCondition == null) {
            throw new LindormException("The row existence condition must be specified");
        }
        this.where = condition;
        this.rowExistenceCondition = rowExistenceCondition;
        return this;
    }

    @Override
    public Upsert check(Condition condition) throws LindormException {
        return this.check(condition, ConditionFactory.RowExistenceCondition.IGNORE);
    }

    public ConditionFactory.RowExistenceCondition getRowExistenceCondition() {
        return this.rowExistenceCondition;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setAttributes();
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.rows.size());
        for (Row row : this.rows) {
            row.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int numberOfRows = WritableUtils.readVInt(in);
        this.rows = CollectionUtils.newArrayListWithCapacity(numberOfRows);
        for (int i = 0; i < numberOfRows; ++i) {
            Row r = new Row();
            r.readFrom(in);
            this.rows.add(r);
        }
        this.handleAttributes();
    }

    private void setAttributes() throws IOException {
        if (this.where != null) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteStream);
            WritableUtils.writeVInt(out, ExpressionType.getOrdinal(this.where));
            this.where.writeTo(out);
            this.setAttribute(WHERE_ATTR, byteStream.toByteArray());
        } else {
            this.setAttribute(WHERE_ATTR, (byte[])null);
        }
        if (this.rowExistenceCondition != null) {
            this.setAttribute(ROW_EXISTENCE_ATTR, Bytes.toBytes(this.rowExistenceCondition.ordinal()));
        } else {
            this.removeAttribute(ROW_EXISTENCE_ATTR);
        }
    }

    private void handleAttributes() throws IOException {
        byte[] rowConditionBytes;
        byte[] whereBytes = this.getAttribute(WHERE_ATTR);
        if (whereBytes != null) {
            DataInputBuffer in = new DataInputBuffer();
            in.reset(whereBytes, 0, whereBytes.length);
            this.where = (Condition)ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
            this.where.readFrom(in);
        }
        if ((rowConditionBytes = this.getAttribute(ROW_EXISTENCE_ATTR)) != null) {
            this.rowExistenceCondition = ConditionFactory.RowExistenceCondition.values()[Bytes.toInt(rowConditionBytes)];
        }
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("UPSERT INTO ");
        str.append(this.tableName);
        str.append(" VALUES ");
        int num = 0;
        if (this.rows != null && !this.rows.isEmpty()) {
            str.append(this.rows.size());
            str.append("(");
            for (Row r : this.rows) {
                str.append(r.toString());
                if (++num > 3) break;
                str.append(",");
            }
            str.setLength(str.length() - 1);
            str.append(")");
        }
        return str.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LUpsert)) {
            return false;
        }
        LUpsert other = (LUpsert)obj;
        if (!this.rows.equals(other.rows)) {
            return false;
        }
        if (this.where == null != (other.where == null)) {
            return false;
        }
        return this.where == null || this.where.equals(other.where);
    }

    @Override
    protected byte[] computeRowKey(TableMeta meta) throws LindormException {
        try {
            Row r = this.rows.get(0);
            byte[][] pkBytes = new byte[meta.getPkColumns().size()][];
            for (ColumnValue cv : r.getColumnValues()) {
                LColumn c = meta.resolveColumnNoThrow(cv.getColumnKey());
                if (c == null || !c.isPrimaryKey()) continue;
                pkBytes[c.getPosition()] = LDataType.toBytes(c, cv);
            }
            int rowkeySize = 0;
            for (byte[] keyPart : pkBytes) {
                rowkeySize += keyPart.length;
            }
            byte[] rowkey = new byte[rowkeySize];
            int offset = 0;
            for (byte[] keyPart : pkBytes) {
                System.arraycopy(keyPart, 0, rowkey, offset, keyPart.length);
                offset += keyPart.length;
            }
            return rowkey;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void validate() throws LindormException {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new LindormException("Table name must not be null or empty.");
        }
    }

    private boolean isEmpty() {
        return this.rows == null || this.rows.isEmpty();
    }

    private class AsyncUpsertWithResultsHandler
    extends DmlOperation.AsyncLMutationResultHandler<List<Object>> {
        public AsyncUpsertWithResultsHandler(AsyncCallback<List<Object>> callback, OperationContext.OperationType operationType, long startTime, Object eagleEyeContext) {
            super(LUpsert.this, callback, operationType, startTime, eagleEyeContext);
        }

        @Override
        protected List<Object> getReturnValue(LMutationResult result) {
            return Arrays.asList(result.getResults());
        }
    }

    private class AsyncUpsertHandler
    extends DmlOperation.AsyncLMutationResultHandler<Integer> {
        public AsyncUpsertHandler(AsyncCallback<Integer> callback, OperationContext.OperationType operationType, long startTime, int rows, Object eagleEyeContext) {
            super(LUpsert.this, callback, operationType, startTime, rows, eagleEyeContext);
        }

        @Override
        protected Integer getReturnValue(LMutationResult result) {
            return result.getNumberOfRowsAffected();
        }

        @Override
        public void onComplete(LMutationResult result) {
            try {
                LUpsert.this.checkResultCompatibility(result.getResults());
            }
            catch (Throwable t) {
                this.onError(t);
                return;
            }
            super.onComplete(result);
        }
    }
}

