/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.exception;

import com.alibaba.lindorm.client.core.ipc.Address;
import com.alibaba.lindorm.client.exception.VersionMismatchException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public final class LDRemoteException
extends IOException {
    private final String type;
    private final String msg;
    private Address serverAddress;
    private static final HashMap<String, String> REMOTE_EXCEPTION_TYPES = new HashMap();
    private static final long serialVersionUID = 1279775242L;

    public LDRemoteException(String type, String msg, Address serverAddress) {
        super(msg + LDRemoteException.addServerInfo(serverAddress));
        this.type = type;
        this.msg = msg;
        this.serverAddress = serverAddress;
    }

    private static String addServerInfo(Address serverAddress) {
        if (serverAddress == null) {
            return "";
        }
        return "[Remote Server:" + serverAddress.toString() + "]";
    }

    public LDRemoteException(String type, String msg) {
        this(type, msg, null);
    }

    public String getType() {
        return this.type;
    }

    public IOException unwrapRemoteException() {
        String exceptionClassName = this.type;
        if (REMOTE_EXCEPTION_TYPES.containsKey(this.type)) {
            exceptionClassName = REMOTE_EXCEPTION_TYPES.get(this.type);
        }
        try {
            Class<?> realClass = Class.forName(this.type);
            return this.instantiateException(realClass.asSubclass(IOException.class), this.msg);
        }
        catch (Throwable throwable) {
            return this;
        }
    }

    private IOException instantiateException(Class<? extends IOException> cls, String message) throws Exception {
        Constructor<? extends IOException> cn = cls.getConstructor(String.class);
        cn.setAccessible(true);
        String msg = message;
        if (msg.contains(cls.getName())) {
            int index = msg.indexOf(":");
            msg = msg.substring(index + 2);
        }
        msg = msg + LDRemoteException.addServerInfo(this.serverAddress);
        IOException ex = cn.newInstance(msg);
        return ex;
    }

    static {
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.io.VersionMismatchException", VersionMismatchException.class.getName());
    }
}

