/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.exporter;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class FileSystemInfo
extends VersionedObjectWithAttributes {
    private String fileSystemType = "HDFS";
    private Map<String, String> properties;

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.fileSystemType);
        out.writeInt(this.properties.size());
        for (String key : this.properties.keySet()) {
            WritableUtils.writeString(out, key);
            WritableUtils.writeString(out, this.properties.get(key));
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.fileSystemType = WritableUtils.readString(in);
        int propertiesSize = in.readInt();
        this.properties = new HashMap<String, String>();
        for (int i = 0; i < propertiesSize; ++i) {
            String key = WritableUtils.readString(in);
            String value = WritableUtils.readString(in);
            this.properties.put(key, value);
        }
    }

    public String getFileSystemType() {
        return this.fileSystemType;
    }

    public void setFileSystemType(String fileSystemType) {
        this.fileSystemType = fileSystemType;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }
}

