/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.haclient.ClusterSwitchUtil;
import com.alibaba.hbase.haclient.dualservice.DualExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AliHBaseMultiAdmin;
import org.apache.hadoop.hbase.client.AliHBaseMultiBufferedMutator;
import org.apache.hadoop.hbase.client.AliHBaseMultiTable;
import org.apache.hadoop.hbase.client.AliHBaseUEAdmin;
import org.apache.hadoop.hbase.client.AliHBaseUEClusterConnection;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorImpl;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.MetaCache;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.TableConfiguration;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Threads;

public class AliHBaseMultiClusterConnection
extends ConnectionManager.HConnectionImplementation
implements Closeable {
    private static final Log LOG = LogFactory.getLog(AliHBaseMultiClusterConnection.class);
    private volatile ClusterConnection activeConnectionImpl;
    private volatile ClusterConnection standbyConnectionImpl;
    protected volatile long switchCount = 0L;
    private volatile MetaCache metaCache;
    private volatile RpcRetryingCallerFactory rpcCallerFactory;
    private volatile RpcControllerFactory rpcControllerFactory;
    private volatile ConnectionConfiguration connectionConfiguration;
    private volatile TableConfiguration tableConfiguration;
    private Constructor<?> constructorWithTableConfiguration = null;
    private Constructor<?> constructorWithConnectionConfiguration = null;
    private volatile boolean hasCellBlockSupport = false;
    protected volatile Configuration conf;
    protected volatile Configuration standbyConf;
    protected User user;
    protected volatile boolean closed = false;
    protected volatile boolean aborted = false;
    protected volatile boolean cleanupPool = false;
    protected volatile boolean cleanupStandbyPool = false;
    private ExecutorService batchPool = null;
    private ExecutorService standbyBatchPool = null;
    private AsyncProcess asyncProcess = null;
    private AliHBaseConstants.ClusterType activeClusterType = null;
    private AliHBaseConstants.ClusterType standbyClusterType = null;
    protected boolean dualServiceEnable;
    protected DualExecutor dualExecutor;

    protected AliHBaseMultiClusterConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        this(conf, false, pool, user);
    }

    protected AliHBaseMultiClusterConnection(Configuration conf, boolean managed) throws IOException {
        this(conf, managed, null, null);
    }

    protected AliHBaseMultiClusterConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        super(conf, false);
        if (managed) {
            throw new IOException("Managed connection is not supported for AliHBaseMultiClusterConnection");
        }
        this.conf = conf;
        this.user = user;
        this.batchPool = pool;
        this.dualServiceEnable = conf.getBoolean("hbase.dualservice.enable", false);
        if (this.dualServiceEnable) {
            this.dualExecutor = new DualExecutor(this.conf);
        }
    }

    protected AsyncProcess createAsyncProcess() {
        return null;
    }

    protected ExecutorService getThreadPool(int maxThreads, int coreThreads, String nameHint, BlockingQueue<Runnable> passedWorkQueue) {
        if (maxThreads == 0) {
            maxThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        if (coreThreads == 0) {
            coreThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        long keepAliveTime = this.conf.getLong("hbase.hconnection.threads.keepalivetime", 60L);
        BlockingQueue<Runnable> workQueue = passedWorkQueue;
        if (workQueue == null) {
            workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * this.conf.getInt("hbase.client.max.total.tasks", 100));
        }
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, Threads.newDaemonThreadFactory((String)(this.toString() + nameHint)));
        tpe.allowCoreThreadTimeOut(true);
        return tpe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getBatchPool() {
        if (this.batchPool == null) {
            AliHBaseMultiClusterConnection aliHBaseMultiClusterConnection = this;
            synchronized (aliHBaseMultiClusterConnection) {
                if (this.batchPool == null) {
                    this.batchPool = this.getThreadPool(this.conf.getInt("hbase.hconnection.threads.max", 256), this.conf.getInt("hbase.hconnection.threads.core", 256), "-shared-", null);
                    this.cleanupPool = true;
                }
            }
        }
        return this.batchPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getStandbyBatchPool() {
        if (this.standbyBatchPool == null) {
            AliHBaseMultiClusterConnection aliHBaseMultiClusterConnection = this;
            synchronized (aliHBaseMultiClusterConnection) {
                if (this.standbyBatchPool == null) {
                    this.standbyBatchPool = this.getThreadPool(this.standbyConf.getInt("hbase.hconnection.threads.max", 256), this.standbyConf.getInt("hbase.hconnection.threads.core", 256), "-shared-", null);
                    this.cleanupStandbyPool = true;
                }
            }
        }
        return this.standbyBatchPool;
    }

    private void getPrivatesFromCurrentConnection() {
        if (this.activeConnectionImpl != null) {
            Field field;
            try {
                field = this.activeConnectionImpl.getClass().getDeclaredField("metaCache");
                field.setAccessible(true);
                this.metaCache = (MetaCache)field.get(this.activeConnectionImpl);
            }
            catch (Throwable ex) {
                LOG.error((Object)"Error when get metaCache field", ex);
            }
            try {
                field = this.activeConnectionImpl.getClass().getDeclaredField("rpcCallerFactory");
                field.setAccessible(true);
                this.rpcCallerFactory = (RpcRetryingCallerFactory)field.get(this.activeConnectionImpl);
            }
            catch (Throwable ex) {
                LOG.error((Object)"Error when get rpcCallerFactory field", ex);
            }
            try {
                field = this.activeConnectionImpl.getClass().getDeclaredField("rpcControllerFactory");
                field.setAccessible(true);
                this.rpcControllerFactory = (RpcControllerFactory)field.get(this.activeConnectionImpl);
            }
            catch (Throwable ex) {
                LOG.error((Object)"Error when get rpcControllerFactory field", ex);
            }
            this.connectionConfiguration = new ConnectionConfiguration(this.activeConnectionImpl.getConfiguration());
            try {
                Method method = this.activeConnectionImpl.getClass().getMethod("hasCellBlockSupport", new Class[0]);
                this.hasCellBlockSupport = (Boolean)method.invoke((Object)this.activeConnectionImpl, new Object[0]);
            }
            catch (Throwable ex) {
                this.hasCellBlockSupport = false;
            }
            this.tableConfiguration = new TableConfiguration(this.activeConnectionImpl.getConfiguration());
            try {
                this.constructorWithTableConfiguration = HTable.class.getDeclaredConstructor(TableName.class, ClusterConnection.class, TableConfiguration.class, RpcRetryingCallerFactory.class, RpcControllerFactory.class, ExecutorService.class);
                this.constructorWithTableConfiguration.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (this.constructorWithTableConfiguration == null) {
                try {
                    this.constructorWithConnectionConfiguration = HTable.class.getDeclaredConstructor(TableName.class, ClusterConnection.class, ConnectionConfiguration.class, RpcRetryingCallerFactory.class, RpcControllerFactory.class, ExecutorService.class);
                    this.constructorWithConnectionConfiguration.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
    }

    protected ClusterConnection createConnection(Configuration conf, User user, ExecutorService pool) throws IOException {
        ConnectionManager.HConnectionImplementation newClusterConnection = null;
        AliHBaseConstants.ClusterType clusterType = this.getClusterTypeFromConf(conf);
        if (clusterType == AliHBaseConstants.ClusterType.HBASE) {
            newClusterConnection = new ConnectionManager.HConnectionImplementation(conf, false, pool, user);
        } else if (clusterType == AliHBaseConstants.ClusterType.HBASEUE) {
            newClusterConnection = new AliHBaseUEClusterConnection(conf, pool, user);
        } else {
            throw new IOException("Cluster is null, can not create connection");
        }
        return newClusterConnection;
    }

    protected synchronized void onChangeCluster(Configuration activeConf, Configuration standbyConf) throws IOException {
        this.conf = new Configuration(activeConf);
        String activeConnectKey = ClusterSwitchUtil.getConnectKey(activeConf);
        AliHBaseConstants.ClusterType localActiveType = this.getClusterTypeFromConf(this.conf);
        if (standbyConf == null) {
            AliHBaseConstants.ClusterType lastClusterType = this.activeClusterType;
            if (lastClusterType == null) {
                lastClusterType = localActiveType;
            }
            ClusterConnection lastConnection = this.activeConnectionImpl;
            LOG.info((Object)("Creating new connection to " + activeConnectKey));
            this.activeConnectionImpl = this.createConnection(activeConf, this.user, this.getBatchPool());
            this.activeClusterType = localActiveType;
            if (localActiveType == AliHBaseConstants.ClusterType.HBASE) {
                this.getPrivatesFromCurrentConnection();
            }
            if (lastConnection != null && !lastConnection.isClosed() && lastClusterType == AliHBaseConstants.ClusterType.HBASE) {
                LOG.info((Object)("Closing old connection on " + ClusterSwitchUtil.getConnectKey(lastConnection.getConfiguration()) + " since destination cluster is changed"));
                lastConnection.close();
            }
        } else {
            this.standbyConf = new Configuration(standbyConf);
            String standbyConnectKey = ClusterSwitchUtil.getConnectKey(standbyConf);
            AliHBaseConstants.ClusterType localStandbyType = this.getClusterTypeFromConf(standbyConf);
            ClusterConnection tempConnection = this.activeConnectionImpl;
            this.activeConnectionImpl = this.standbyConnectionImpl;
            this.standbyConnectionImpl = tempConnection;
            if (this.activeConnectionImpl == null || this.activeConnectionImpl.isClosed()) {
                LOG.info((Object)("Creating new active connection to " + activeConnectKey));
                this.activeConnectionImpl = this.createConnection(activeConf, this.user, this.getBatchPool());
            }
            if (this.standbyConnectionImpl == null || this.standbyConnectionImpl.isClosed()) {
                LOG.info((Object)("Creating new standby connection to " + standbyConnectKey));
                try {
                    this.standbyConnectionImpl = this.createConnection(standbyConf, this.user, this.getStandbyBatchPool());
                }
                catch (Throwable t) {
                    LOG.warn((Object)("Create standby connection failed with error : " + t));
                }
            }
            if (localActiveType == AliHBaseConstants.ClusterType.HBASE) {
                this.getPrivatesFromCurrentConnection();
            }
            this.activeClusterType = localActiveType;
            this.standbyClusterType = localStandbyType;
        }
        ++this.switchCount;
    }

    private AliHBaseConstants.ClusterType getClusterTypeFromConf(Configuration conf) {
        return AliHBaseConstants.ClusterType.valueOf(conf.get("hbase.cluster.type"));
    }

    public long getSwitchCount() {
        return this.switchCount;
    }

    @Deprecated
    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.activeConnectionImpl.isMasterRunning();
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.activeConnectionImpl.isTableAvailable(tableName, splitKeys);
    }

    public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
        return this.activeConnectionImpl.locateRegion(tableName, row);
    }

    public void clearRegionCache() {
        this.activeConnectionImpl.clearRegionCache();
    }

    public void cacheLocation(TableName tableName, RegionLocations regionLocations) {
        this.metaCache.cacheLocation(tableName, regionLocations);
    }

    public void clearRegionCache(TableName tableName) {
        this.activeConnectionImpl.clearRegionCache(tableName);
    }

    public void deleteCachedRegionLocation(HRegionLocation location) {
        this.activeConnectionImpl.deleteCachedRegionLocation(location);
    }

    public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
        return this.activeConnectionImpl.relocateRegion(tableName, row);
    }

    public RegionLocations relocateRegion(TableName tableName, byte[] row, int replicaId) throws IOException {
        return this.activeConnectionImpl.relocateRegion(tableName, row, replicaId);
    }

    public void updateCachedLocations(TableName tableName, byte[] regionName, byte[] rowkey, Object exception, ServerName source) {
        this.activeConnectionImpl.updateCachedLocations(tableName, regionName, rowkey, exception, source);
    }

    public HRegionLocation locateRegion(byte[] regionName) throws IOException {
        return this.activeConnectionImpl.locateRegion(regionName);
    }

    public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
        return this.activeConnectionImpl.locateRegions(tableName);
    }

    public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
        return this.activeConnectionImpl.locateRegions(tableName, useCache, offlined);
    }

    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
        return this.locateRegion(tableName, row, useCache, retry, 0);
    }

    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
        return this.activeConnectionImpl.locateRegion(tableName, row, useCache, retry, replicaId);
    }

    public MasterProtos.MasterService.BlockingInterface getMaster() {
        try {
            return this.activeConnectionImpl.getMaster();
        }
        catch (IOException e) {
            return null;
        }
    }

    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
        return this.activeConnectionImpl.getAdmin(serverName);
    }

    public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
        return this.activeConnectionImpl.getClient(serverName);
    }

    public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
        return this.activeConnectionImpl.getRegionLocation(tableName, row, reload);
    }

    public void clearCaches(ServerName sn) {
        this.activeConnectionImpl.clearCaches(sn);
    }

    @Deprecated
    public MasterKeepAliveConnection getKeepAliveMasterService() throws MasterNotRunningException {
        return this.activeConnectionImpl.getKeepAliveMasterService();
    }

    @Deprecated
    public boolean isDeadServer(ServerName serverName) {
        return this.activeConnectionImpl.isDeadServer(serverName);
    }

    public NonceGenerator getNonceGenerator() {
        return this.activeConnectionImpl.getNonceGenerator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncProcess getAsyncProcess() {
        if (this.asyncProcess != null) {
            return this.asyncProcess;
        }
        AliHBaseMultiClusterConnection aliHBaseMultiClusterConnection = this;
        synchronized (aliHBaseMultiClusterConnection) {
            if (this.asyncProcess != null) {
                return this.asyncProcess;
            }
            this.asyncProcess = this.createAsyncProcess();
            return this.asyncProcess;
        }
    }

    public RpcRetryingCallerFactory getNewRpcRetryingCallerFactory(Configuration conf) {
        return this.activeConnectionImpl.getNewRpcRetryingCallerFactory(conf);
    }

    public RpcRetryingCallerFactory getRpcRetryingCallerFactory() {
        return this.rpcCallerFactory;
    }

    public RpcControllerFactory getRpcControllerFactory() {
        return this.rpcControllerFactory;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public boolean isManaged() {
        return this.activeConnectionImpl.isManaged();
    }

    public ServerStatisticTracker getStatisticsTracker() {
        if (this.activeConnectionImpl == null) {
            return super.getStatisticsTracker();
        }
        return this.activeConnectionImpl.getStatisticsTracker();
    }

    public ClientBackoffPolicy getBackoffPolicy() {
        return this.activeConnectionImpl.getBackoffPolicy();
    }

    public boolean hasCellBlockSupport() {
        return this.hasCellBlockSupport;
    }

    public Configuration getConfiguration() {
        if (this.conf == null) {
            return super.getConfiguration();
        }
        return this.conf;
    }

    public HTableInterface getTable(String tableName) throws IOException {
        return this.getTable(TableName.valueOf((String)tableName));
    }

    public HTableInterface getTable(byte[] tableName) throws IOException {
        return this.getTable(TableName.valueOf((byte[])tableName));
    }

    public HTableInterface getTable(TableName tableName) throws IOException {
        return this.getTable(tableName, this.getBatchPool());
    }

    public HTableInterface getTable(String tableName, ExecutorService pool) throws IOException {
        return this.getTable(TableName.valueOf((String)tableName), pool);
    }

    public HTableInterface getTable(byte[] tableName, ExecutorService pool) throws IOException {
        return this.getTable(TableName.valueOf((byte[])tableName), pool);
    }

    public HTableInterface getTable(TableName tableName, ExecutorService pool) throws IOException {
        HTable htable = this.getHTableByType(tableName, pool, this.activeClusterType, (ClusterConnection)this, false);
        return new AliHBaseMultiTable(tableName, this, htable);
    }

    public HTable getHTableByType(TableName tableName) throws IOException {
        return this.getHTableByType(tableName, this.getBatchPool(), this.activeClusterType, (ClusterConnection)this, false);
    }

    public HTable getHTableWithStandbyConnection(TableName tableName) throws IOException {
        return this.getHTableByType(tableName, this.getStandbyBatchPool(), this.standbyClusterType, this.standbyConnectionImpl, true);
    }

    public HTable getHTableByType(TableName tableName, ExecutorService pool, AliHBaseConstants.ClusterType clusterType, ClusterConnection connection, boolean isStandby) throws IOException {
        if (clusterType == AliHBaseConstants.ClusterType.HBASE) {
            try {
                if (this.constructorWithTableConfiguration != null) {
                    return (HTable)this.constructorWithTableConfiguration.newInstance(tableName, connection, this.tableConfiguration, this.getRpcRetryingCallerFactory(), this.getRpcControllerFactory(), pool);
                }
                if (this.constructorWithConnectionConfiguration != null) {
                    return (HTable)this.constructorWithConnectionConfiguration.newInstance(tableName, connection, this.getConnectionConfiguration(), this.getRpcRetryingCallerFactory(), this.getRpcControllerFactory(), pool);
                }
                throw new IOException("No constructor found");
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new IOException(t);
            }
        }
        if (clusterType == AliHBaseConstants.ClusterType.HBASEUE) {
            if (!isStandby) {
                return (HTable)this.activeConnectionImpl.getTable(tableName, pool);
            }
            if (this.standbyConnectionImpl != null && !this.standbyConnectionImpl.isClosed()) {
                return (HTable)this.standbyConnectionImpl.getTable(tableName, pool);
            }
            return null;
        }
        LOG.error((Object)"getTable ClusterType is null , return null");
        return null;
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(this.conf.get("hbase.cluster.type"));
        if (clusterType == AliHBaseConstants.ClusterType.HBASE) {
            return new HRegionLocator(tableName, (ClusterConnection)this);
        }
        if (clusterType == AliHBaseConstants.ClusterType.HBASEUE) {
            return this.activeConnectionImpl.getRegionLocator(tableName);
        }
        LOG.error((Object)"getRegionLocator ClusterType is null , return null");
        return null;
    }

    public Admin getAdmin() throws IOException {
        HBaseAdmin hbaseAdmin = this.getHBaseAdmin();
        return new AliHBaseMultiAdmin(this, hbaseAdmin);
    }

    public HBaseAdmin getHBaseAdmin() throws IOException {
        AliHBaseConstants.ClusterType clusterType = this.getClusterTypeFromConf(this.conf);
        if (clusterType == AliHBaseConstants.ClusterType.HBASE) {
            return new HBaseAdmin((ClusterConnection)this);
        }
        if (clusterType == AliHBaseConstants.ClusterType.HBASEUE) {
            return (AliHBaseUEAdmin)this.activeConnectionImpl.getAdmin();
        }
        LOG.error((Object)"getHBaseAdmin ClusterType is null , return null");
        return null;
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.activeConnectionImpl.isTableEnabled(tableName);
    }

    @Deprecated
    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.activeConnectionImpl.isTableEnabled(tableName);
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.activeConnectionImpl.isTableDisabled(tableName);
    }

    @Deprecated
    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.activeConnectionImpl.isTableDisabled(tableName);
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.activeConnectionImpl.isTableAvailable(tableName);
    }

    @Deprecated
    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.activeConnectionImpl.isTableAvailable(tableName);
    }

    @Deprecated
    public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
        return this.activeConnectionImpl.isTableAvailable(tableName, splitKeys);
    }

    @Deprecated
    public HTableDescriptor[] listTables() throws IOException {
        return this.activeConnectionImpl.listTables();
    }

    @Deprecated
    public String[] getTableNames() throws IOException {
        return this.activeConnectionImpl.getTableNames();
    }

    @Deprecated
    public TableName[] listTableNames() throws IOException {
        return this.activeConnectionImpl.listTableNames();
    }

    @Deprecated
    public HTableDescriptor getHTableDescriptor(TableName tableName) throws IOException {
        return this.activeConnectionImpl.getHTableDescriptor(tableName);
    }

    @Deprecated
    public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
        return this.activeConnectionImpl.getHTableDescriptor(tableName);
    }

    @Deprecated
    public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
        return this.activeConnectionImpl.locateRegion(tableName, row);
    }

    @Deprecated
    public void clearRegionCache(byte[] tableName) {
        this.activeConnectionImpl.clearRegionCache(tableName);
    }

    @Deprecated
    public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
        return this.activeConnectionImpl.relocateRegion(tableName, row);
    }

    @Deprecated
    public void updateCachedLocations(TableName tableName, byte[] rowkey, Object exception, HRegionLocation source) {
        this.activeConnectionImpl.updateCachedLocations(tableName, rowkey, exception, source);
    }

    @Deprecated
    public void updateCachedLocations(byte[] tableName, byte[] rowkey, Object exception, HRegionLocation source) {
        this.activeConnectionImpl.updateCachedLocations(tableName, rowkey, exception, source);
    }

    @Deprecated
    public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
        return this.activeConnectionImpl.locateRegions(tableName);
    }

    @Deprecated
    public List<HRegionLocation> locateRegions(byte[] tableName, boolean useCache, boolean offlined) throws IOException {
        return this.activeConnectionImpl.locateRegions(tableName, useCache, offlined);
    }

    @Deprecated
    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName, boolean getMaster) throws IOException {
        return this.activeConnectionImpl.getAdmin(serverName, getMaster);
    }

    @Deprecated
    public HRegionLocation getRegionLocation(byte[] tableName, byte[] row, boolean reload) throws IOException {
        return this.activeConnectionImpl.getRegionLocation(tableName, row, reload);
    }

    @Deprecated
    public void processBatch(List<? extends Row> actions, TableName tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
        this.activeConnectionImpl.processBatch(actions, tableName, pool, results);
    }

    @Deprecated
    public void processBatch(List<? extends Row> actions, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
        this.activeConnectionImpl.processBatch(actions, tableName, pool, results);
    }

    @Deprecated
    public <R> void processBatchCallback(List<? extends Row> list, TableName tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.activeConnectionImpl.processBatchCallback(list, tableName, pool, results, callback);
    }

    @Deprecated
    public <R> void processBatchCallback(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.activeConnectionImpl.processBatchCallback(list, tableName, pool, results, callback);
    }

    @Deprecated
    public void setRegionCachePrefetch(TableName tableName, boolean enable) {
        this.activeConnectionImpl.setRegionCachePrefetch(tableName, enable);
    }

    @Deprecated
    public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
        this.activeConnectionImpl.setRegionCachePrefetch(tableName, enable);
    }

    @Deprecated
    public boolean getRegionCachePrefetch(TableName tableName) {
        return this.activeConnectionImpl.getRegionCachePrefetch(tableName);
    }

    @Deprecated
    public boolean getRegionCachePrefetch(byte[] tableName) {
        return this.activeConnectionImpl.getRegionCachePrefetch(tableName);
    }

    @Deprecated
    public int getCurrentNrHRS() throws IOException {
        return this.activeConnectionImpl.getCurrentNrHRS();
    }

    @Deprecated
    public HTableDescriptor[] getHTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        return this.activeConnectionImpl.getHTableDescriptorsByTableName(tableNames);
    }

    @Deprecated
    public HTableDescriptor[] getHTableDescriptors(List<String> tableNames) throws IOException {
        return this.activeConnectionImpl.getHTableDescriptors(tableNames);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public BufferedMutator getBufferedMutator(TableName tableName) {
        return this.getBufferedMutator(new BufferedMutatorParams(tableName));
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) {
        BufferedMutator bufferedMutator = this.getBufferedMutatorByType(params);
        return new AliHBaseMultiBufferedMutator(this, bufferedMutator, params);
    }

    public BufferedMutator getBufferedMutatorByType(BufferedMutatorParams params) {
        AliHBaseConstants.ClusterType clusterType = this.getClusterTypeFromConf(this.conf);
        if (clusterType == AliHBaseConstants.ClusterType.HBASE) {
            if (params.getTableName() == null) {
                throw new IllegalArgumentException("TableName cannot be null.");
            }
            if (params.getPool() == null) {
                params.pool((ExecutorService)HTable.getDefaultExecutor((Configuration)this.getConfiguration()));
            }
            if (params.getWriteBufferSize() == -1L) {
                params.writeBufferSize(this.getConnectionConfiguration().getWriteBufferSize());
            }
            if (params.getMaxKeyValueSize() == -1) {
                params.maxKeyValueSize(this.getConnectionConfiguration().getMaxKeyValueSize());
            }
            return new BufferedMutatorImpl((ClusterConnection)this, this.getRpcRetryingCallerFactory(), this.getRpcControllerFactory(), params);
        }
        if (clusterType == AliHBaseConstants.ClusterType.HBASEUE) {
            try {
                return this.activeConnectionImpl.getBufferedMutator(params);
            }
            catch (IOException e) {
                LOG.warn((Object)("get bufferd mutator failed " + e));
                return null;
            }
        }
        LOG.error((Object)"getBufferedMutator ClusterType is null , return null");
        return null;
    }

    @Override
    public void close() {
        try {
            if (this.closed) {
                return;
            }
            if (this.activeConnectionImpl != null) {
                this.activeConnectionImpl.close();
            }
            if (this.standbyConnectionImpl != null) {
                this.standbyConnectionImpl.close();
            }
            this.shutdownBatchPool(this.batchPool, this.cleanupPool);
            this.shutdownBatchPool(this.standbyBatchPool, this.cleanupStandbyPool);
            if (this.dualExecutor != null) {
                this.dualExecutor.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("close failed " + e));
        }
    }

    public void abort(String why, Throwable throwable) {
        this.activeConnectionImpl.abort(why, throwable);
        if (this.standbyConnectionImpl != null) {
            this.standbyConnectionImpl.abort(why, throwable);
        }
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    private void shutdownBatchPool(ExecutorService pool, boolean cleanupPool) {
        if (!cleanupPool || pool.isShutdown()) {
            return;
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
        }
    }

    public Configuration getOriginalConf() {
        return this.conf;
    }

    public DualExecutor getDualExecutor() {
        return this.dualExecutor;
    }
}

